/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GlueConnectionType {
    SNOWFLAKE("SNOWFLAKE"),
    BIGQUERY("BIGQUERY"),
    DOCUMENTDB("DOCUMENTDB"),
    DYNAMODB("DYNAMODB"),
    MYSQL("MYSQL"),
    OPENSEARCH("OPENSEARCH"),
    ORACLE("ORACLE"),
    POSTGRESQL("POSTGRESQL"),
    REDSHIFT("REDSHIFT"),
    SAPHANA("SAPHANA"),
    SQLSERVER("SQLSERVER"),
    TERADATA("TERADATA"),
    VERTICA("VERTICA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GlueConnectionType> VALUE_MAP;
    private final String value;

    private GlueConnectionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GlueConnectionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GlueConnectionType> knownValues() {
        EnumSet<GlueConnectionType> knownValues = EnumSet.allOf(GlueConnectionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GlueConnectionType.class, GlueConnectionType::toString);
    }
}

