/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OverallDeploymentStatus {
    PENDING_DEPLOYMENT("PENDING_DEPLOYMENT"),
    IN_PROGRESS("IN_PROGRESS"),
    SUCCESSFUL("SUCCESSFUL"),
    FAILED_VALIDATION("FAILED_VALIDATION"),
    FAILED_DEPLOYMENT("FAILED_DEPLOYMENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OverallDeploymentStatus> VALUE_MAP;
    private final String value;

    private OverallDeploymentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OverallDeploymentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OverallDeploymentStatus> knownValues() {
        EnumSet<OverallDeploymentStatus> knownValues = EnumSet.allOf(OverallDeploymentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OverallDeploymentStatus.class, OverallDeploymentStatus::toString);
    }
}

