/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.AuthorizationCodeProperties;
import software.amazon.awssdk.services.datazone.model.GlueOAuth2Credentials;
import software.amazon.awssdk.services.datazone.model.OAuth2ClientApplication;
import software.amazon.awssdk.services.datazone.model.OAuth2GrantType;
import software.amazon.awssdk.services.datazone.model.TokenUrlParametersMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OAuth2Properties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OAuth2Properties> {
    private static final SdkField<AuthorizationCodeProperties> AUTHORIZATION_CODE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authorizationCodeProperties").getter(OAuth2Properties.getter(OAuth2Properties::authorizationCodeProperties)).setter(OAuth2Properties.setter(Builder::authorizationCodeProperties)).constructor(AuthorizationCodeProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationCodeProperties").build()}).build();
    private static final SdkField<OAuth2ClientApplication> O_AUTH2_CLIENT_APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oAuth2ClientApplication").getter(OAuth2Properties.getter(OAuth2Properties::oAuth2ClientApplication)).setter(OAuth2Properties.setter(Builder::oAuth2ClientApplication)).constructor(OAuth2ClientApplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth2ClientApplication").build()}).build();
    private static final SdkField<GlueOAuth2Credentials> O_AUTH2_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oAuth2Credentials").getter(OAuth2Properties.getter(OAuth2Properties::oAuth2Credentials)).setter(OAuth2Properties.setter(Builder::oAuth2Credentials)).constructor(GlueOAuth2Credentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth2Credentials").build()}).build();
    private static final SdkField<String> O_AUTH2_GRANT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("oAuth2GrantType").getter(OAuth2Properties.getter(OAuth2Properties::oAuth2GrantTypeAsString)).setter(OAuth2Properties.setter(Builder::oAuth2GrantType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth2GrantType").build()}).build();
    private static final SdkField<String> TOKEN_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenUrl").getter(OAuth2Properties.getter(OAuth2Properties::tokenUrl)).setter(OAuth2Properties.setter(Builder::tokenUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenUrl").build()}).build();
    private static final SdkField<Map<String, String>> TOKEN_URL_PARAMETERS_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tokenUrlParametersMap").getter(OAuth2Properties.getter(OAuth2Properties::tokenUrlParametersMap)).setter(OAuth2Properties.setter(Builder::tokenUrlParametersMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenUrlParametersMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_CODE_PROPERTIES_FIELD, O_AUTH2_CLIENT_APPLICATION_FIELD, O_AUTH2_CREDENTIALS_FIELD, O_AUTH2_GRANT_TYPE_FIELD, TOKEN_URL_FIELD, TOKEN_URL_PARAMETERS_MAP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("authorizationCodeProperties", AUTHORIZATION_CODE_PROPERTIES_FIELD);
            this.put("oAuth2ClientApplication", O_AUTH2_CLIENT_APPLICATION_FIELD);
            this.put("oAuth2Credentials", O_AUTH2_CREDENTIALS_FIELD);
            this.put("oAuth2GrantType", O_AUTH2_GRANT_TYPE_FIELD);
            this.put("tokenUrl", TOKEN_URL_FIELD);
            this.put("tokenUrlParametersMap", TOKEN_URL_PARAMETERS_MAP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AuthorizationCodeProperties authorizationCodeProperties;
    private final OAuth2ClientApplication oAuth2ClientApplication;
    private final GlueOAuth2Credentials oAuth2Credentials;
    private final String oAuth2GrantType;
    private final String tokenUrl;
    private final Map<String, String> tokenUrlParametersMap;

    private OAuth2Properties(BuilderImpl builder) {
        this.authorizationCodeProperties = builder.authorizationCodeProperties;
        this.oAuth2ClientApplication = builder.oAuth2ClientApplication;
        this.oAuth2Credentials = builder.oAuth2Credentials;
        this.oAuth2GrantType = builder.oAuth2GrantType;
        this.tokenUrl = builder.tokenUrl;
        this.tokenUrlParametersMap = builder.tokenUrlParametersMap;
    }

    public final AuthorizationCodeProperties authorizationCodeProperties() {
        return this.authorizationCodeProperties;
    }

    public final OAuth2ClientApplication oAuth2ClientApplication() {
        return this.oAuth2ClientApplication;
    }

    public final GlueOAuth2Credentials oAuth2Credentials() {
        return this.oAuth2Credentials;
    }

    public final OAuth2GrantType oAuth2GrantType() {
        return OAuth2GrantType.fromValue(this.oAuth2GrantType);
    }

    public final String oAuth2GrantTypeAsString() {
        return this.oAuth2GrantType;
    }

    public final String tokenUrl() {
        return this.tokenUrl;
    }

    public final boolean hasTokenUrlParametersMap() {
        return this.tokenUrlParametersMap != null && !(this.tokenUrlParametersMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tokenUrlParametersMap() {
        return this.tokenUrlParametersMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationCodeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuth2ClientApplication());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuth2Credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuth2GrantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokenUrlParametersMap() ? this.tokenUrlParametersMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2Properties)) {
            return false;
        }
        OAuth2Properties other = (OAuth2Properties)obj;
        return Objects.equals(this.authorizationCodeProperties(), other.authorizationCodeProperties()) && Objects.equals(this.oAuth2ClientApplication(), other.oAuth2ClientApplication()) && Objects.equals(this.oAuth2Credentials(), other.oAuth2Credentials()) && Objects.equals(this.oAuth2GrantTypeAsString(), other.oAuth2GrantTypeAsString()) && Objects.equals(this.tokenUrl(), other.tokenUrl()) && this.hasTokenUrlParametersMap() == other.hasTokenUrlParametersMap() && Objects.equals(this.tokenUrlParametersMap(), other.tokenUrlParametersMap());
    }

    public final String toString() {
        return ToString.builder((String)"OAuth2Properties").add("AuthorizationCodeProperties", (Object)this.authorizationCodeProperties()).add("OAuth2ClientApplication", (Object)this.oAuth2ClientApplication()).add("OAuth2Credentials", (Object)(this.oAuth2Credentials() == null ? null : "*** Sensitive Data Redacted ***")).add("OAuth2GrantType", (Object)this.oAuth2GrantTypeAsString()).add("TokenUrl", (Object)this.tokenUrl()).add("TokenUrlParametersMap", this.hasTokenUrlParametersMap() ? this.tokenUrlParametersMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizationCodeProperties": {
                return Optional.ofNullable(clazz.cast(this.authorizationCodeProperties()));
            }
            case "oAuth2ClientApplication": {
                return Optional.ofNullable(clazz.cast(this.oAuth2ClientApplication()));
            }
            case "oAuth2Credentials": {
                return Optional.ofNullable(clazz.cast(this.oAuth2Credentials()));
            }
            case "oAuth2GrantType": {
                return Optional.ofNullable(clazz.cast(this.oAuth2GrantTypeAsString()));
            }
            case "tokenUrl": {
                return Optional.ofNullable(clazz.cast(this.tokenUrl()));
            }
            case "tokenUrlParametersMap": {
                return Optional.ofNullable(clazz.cast(this.tokenUrlParametersMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OAuth2Properties, T> g) {
        return obj -> g.apply((OAuth2Properties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AuthorizationCodeProperties authorizationCodeProperties;
        private OAuth2ClientApplication oAuth2ClientApplication;
        private GlueOAuth2Credentials oAuth2Credentials;
        private String oAuth2GrantType;
        private String tokenUrl;
        private Map<String, String> tokenUrlParametersMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OAuth2Properties model) {
            this.authorizationCodeProperties(model.authorizationCodeProperties);
            this.oAuth2ClientApplication(model.oAuth2ClientApplication);
            this.oAuth2Credentials(model.oAuth2Credentials);
            this.oAuth2GrantType(model.oAuth2GrantType);
            this.tokenUrl(model.tokenUrl);
            this.tokenUrlParametersMap(model.tokenUrlParametersMap);
        }

        public final AuthorizationCodeProperties.Builder getAuthorizationCodeProperties() {
            return this.authorizationCodeProperties != null ? this.authorizationCodeProperties.toBuilder() : null;
        }

        public final void setAuthorizationCodeProperties(AuthorizationCodeProperties.BuilderImpl authorizationCodeProperties) {
            this.authorizationCodeProperties = authorizationCodeProperties != null ? authorizationCodeProperties.build() : null;
        }

        @Override
        public final Builder authorizationCodeProperties(AuthorizationCodeProperties authorizationCodeProperties) {
            this.authorizationCodeProperties = authorizationCodeProperties;
            return this;
        }

        public final OAuth2ClientApplication.Builder getOAuth2ClientApplication() {
            return this.oAuth2ClientApplication != null ? this.oAuth2ClientApplication.toBuilder() : null;
        }

        public final void setOAuth2ClientApplication(OAuth2ClientApplication.BuilderImpl oAuth2ClientApplication) {
            this.oAuth2ClientApplication = oAuth2ClientApplication != null ? oAuth2ClientApplication.build() : null;
        }

        @Override
        public final Builder oAuth2ClientApplication(OAuth2ClientApplication oAuth2ClientApplication) {
            this.oAuth2ClientApplication = oAuth2ClientApplication;
            return this;
        }

        public final GlueOAuth2Credentials.Builder getOAuth2Credentials() {
            return this.oAuth2Credentials != null ? this.oAuth2Credentials.toBuilder() : null;
        }

        public final void setOAuth2Credentials(GlueOAuth2Credentials.BuilderImpl oAuth2Credentials) {
            this.oAuth2Credentials = oAuth2Credentials != null ? oAuth2Credentials.build() : null;
        }

        @Override
        public final Builder oAuth2Credentials(GlueOAuth2Credentials oAuth2Credentials) {
            this.oAuth2Credentials = oAuth2Credentials;
            return this;
        }

        public final String getOAuth2GrantType() {
            return this.oAuth2GrantType;
        }

        public final void setOAuth2GrantType(String oAuth2GrantType) {
            this.oAuth2GrantType = oAuth2GrantType;
        }

        @Override
        public final Builder oAuth2GrantType(String oAuth2GrantType) {
            this.oAuth2GrantType = oAuth2GrantType;
            return this;
        }

        @Override
        public final Builder oAuth2GrantType(OAuth2GrantType oAuth2GrantType) {
            this.oAuth2GrantType(oAuth2GrantType == null ? null : oAuth2GrantType.toString());
            return this;
        }

        public final String getTokenUrl() {
            return this.tokenUrl;
        }

        public final void setTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
        }

        @Override
        public final Builder tokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public final Map<String, String> getTokenUrlParametersMap() {
            if (this.tokenUrlParametersMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tokenUrlParametersMap;
        }

        public final void setTokenUrlParametersMap(Map<String, String> tokenUrlParametersMap) {
            this.tokenUrlParametersMap = TokenUrlParametersMapCopier.copy(tokenUrlParametersMap);
        }

        @Override
        public final Builder tokenUrlParametersMap(Map<String, String> tokenUrlParametersMap) {
            this.tokenUrlParametersMap = TokenUrlParametersMapCopier.copy(tokenUrlParametersMap);
            return this;
        }

        public OAuth2Properties build() {
            return new OAuth2Properties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OAuth2Properties> {
        public Builder authorizationCodeProperties(AuthorizationCodeProperties var1);

        default public Builder authorizationCodeProperties(Consumer<AuthorizationCodeProperties.Builder> authorizationCodeProperties) {
            return this.authorizationCodeProperties((AuthorizationCodeProperties)((AuthorizationCodeProperties.Builder)AuthorizationCodeProperties.builder().applyMutation(authorizationCodeProperties)).build());
        }

        public Builder oAuth2ClientApplication(OAuth2ClientApplication var1);

        default public Builder oAuth2ClientApplication(Consumer<OAuth2ClientApplication.Builder> oAuth2ClientApplication) {
            return this.oAuth2ClientApplication((OAuth2ClientApplication)((OAuth2ClientApplication.Builder)OAuth2ClientApplication.builder().applyMutation(oAuth2ClientApplication)).build());
        }

        public Builder oAuth2Credentials(GlueOAuth2Credentials var1);

        default public Builder oAuth2Credentials(Consumer<GlueOAuth2Credentials.Builder> oAuth2Credentials) {
            return this.oAuth2Credentials((GlueOAuth2Credentials)((GlueOAuth2Credentials.Builder)GlueOAuth2Credentials.builder().applyMutation(oAuth2Credentials)).build());
        }

        public Builder oAuth2GrantType(String var1);

        public Builder oAuth2GrantType(OAuth2GrantType var1);

        public Builder tokenUrl(String var1);

        public Builder tokenUrlParametersMap(Map<String, String> var1);
    }
}

