/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.AthenaPropertiesInput;
import software.amazon.awssdk.services.datazone.model.GluePropertiesInput;
import software.amazon.awssdk.services.datazone.model.HyperPodPropertiesInput;
import software.amazon.awssdk.services.datazone.model.IamPropertiesInput;
import software.amazon.awssdk.services.datazone.model.RedshiftPropertiesInput;
import software.amazon.awssdk.services.datazone.model.SparkEmrPropertiesInput;
import software.amazon.awssdk.services.datazone.model.SparkGluePropertiesInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionPropertiesInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionPropertiesInput> {
    private static final SdkField<AthenaPropertiesInput> ATHENA_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("athenaProperties").getter(ConnectionPropertiesInput.getter(ConnectionPropertiesInput::athenaProperties)).setter(ConnectionPropertiesInput.setter(Builder::athenaProperties)).constructor(AthenaPropertiesInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("athenaProperties").build()}).build();
    private static final SdkField<GluePropertiesInput> GLUE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("glueProperties").getter(ConnectionPropertiesInput.getter(ConnectionPropertiesInput::glueProperties)).setter(ConnectionPropertiesInput.setter(Builder::glueProperties)).constructor(GluePropertiesInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueProperties").build()}).build();
    private static final SdkField<HyperPodPropertiesInput> HYPER_POD_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hyperPodProperties").getter(ConnectionPropertiesInput.getter(ConnectionPropertiesInput::hyperPodProperties)).setter(ConnectionPropertiesInput.setter(Builder::hyperPodProperties)).constructor(HyperPodPropertiesInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperPodProperties").build()}).build();
    private static final SdkField<IamPropertiesInput> IAM_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iamProperties").getter(ConnectionPropertiesInput.getter(ConnectionPropertiesInput::iamProperties)).setter(ConnectionPropertiesInput.setter(Builder::iamProperties)).constructor(IamPropertiesInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamProperties").build()}).build();
    private static final SdkField<RedshiftPropertiesInput> REDSHIFT_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("redshiftProperties").getter(ConnectionPropertiesInput.getter(ConnectionPropertiesInput::redshiftProperties)).setter(ConnectionPropertiesInput.setter(Builder::redshiftProperties)).constructor(RedshiftPropertiesInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftProperties").build()}).build();
    private static final SdkField<SparkEmrPropertiesInput> SPARK_EMR_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sparkEmrProperties").getter(ConnectionPropertiesInput.getter(ConnectionPropertiesInput::sparkEmrProperties)).setter(ConnectionPropertiesInput.setter(Builder::sparkEmrProperties)).constructor(SparkEmrPropertiesInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkEmrProperties").build()}).build();
    private static final SdkField<SparkGluePropertiesInput> SPARK_GLUE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sparkGlueProperties").getter(ConnectionPropertiesInput.getter(ConnectionPropertiesInput::sparkGlueProperties)).setter(ConnectionPropertiesInput.setter(Builder::sparkGlueProperties)).constructor(SparkGluePropertiesInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkGlueProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATHENA_PROPERTIES_FIELD, GLUE_PROPERTIES_FIELD, HYPER_POD_PROPERTIES_FIELD, IAM_PROPERTIES_FIELD, REDSHIFT_PROPERTIES_FIELD, SPARK_EMR_PROPERTIES_FIELD, SPARK_GLUE_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("athenaProperties", ATHENA_PROPERTIES_FIELD);
            this.put("glueProperties", GLUE_PROPERTIES_FIELD);
            this.put("hyperPodProperties", HYPER_POD_PROPERTIES_FIELD);
            this.put("iamProperties", IAM_PROPERTIES_FIELD);
            this.put("redshiftProperties", REDSHIFT_PROPERTIES_FIELD);
            this.put("sparkEmrProperties", SPARK_EMR_PROPERTIES_FIELD);
            this.put("sparkGlueProperties", SPARK_GLUE_PROPERTIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AthenaPropertiesInput athenaProperties;
    private final GluePropertiesInput glueProperties;
    private final HyperPodPropertiesInput hyperPodProperties;
    private final IamPropertiesInput iamProperties;
    private final RedshiftPropertiesInput redshiftProperties;
    private final SparkEmrPropertiesInput sparkEmrProperties;
    private final SparkGluePropertiesInput sparkGlueProperties;
    private final Type type;

    private ConnectionPropertiesInput(BuilderImpl builder) {
        this.athenaProperties = builder.athenaProperties;
        this.glueProperties = builder.glueProperties;
        this.hyperPodProperties = builder.hyperPodProperties;
        this.iamProperties = builder.iamProperties;
        this.redshiftProperties = builder.redshiftProperties;
        this.sparkEmrProperties = builder.sparkEmrProperties;
        this.sparkGlueProperties = builder.sparkGlueProperties;
        this.type = builder.type;
    }

    public final AthenaPropertiesInput athenaProperties() {
        return this.athenaProperties;
    }

    public final GluePropertiesInput glueProperties() {
        return this.glueProperties;
    }

    public final HyperPodPropertiesInput hyperPodProperties() {
        return this.hyperPodProperties;
    }

    public final IamPropertiesInput iamProperties() {
        return this.iamProperties;
    }

    public final RedshiftPropertiesInput redshiftProperties() {
        return this.redshiftProperties;
    }

    public final SparkEmrPropertiesInput sparkEmrProperties() {
        return this.sparkEmrProperties;
    }

    public final SparkGluePropertiesInput sparkGlueProperties() {
        return this.sparkGlueProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.athenaProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperPodProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.sparkEmrProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.sparkGlueProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionPropertiesInput)) {
            return false;
        }
        ConnectionPropertiesInput other = (ConnectionPropertiesInput)obj;
        return Objects.equals(this.athenaProperties(), other.athenaProperties()) && Objects.equals(this.glueProperties(), other.glueProperties()) && Objects.equals(this.hyperPodProperties(), other.hyperPodProperties()) && Objects.equals(this.iamProperties(), other.iamProperties()) && Objects.equals(this.redshiftProperties(), other.redshiftProperties()) && Objects.equals(this.sparkEmrProperties(), other.sparkEmrProperties()) && Objects.equals(this.sparkGlueProperties(), other.sparkGlueProperties());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionPropertiesInput").add("AthenaProperties", (Object)this.athenaProperties()).add("GlueProperties", (Object)this.glueProperties()).add("HyperPodProperties", (Object)this.hyperPodProperties()).add("IamProperties", (Object)this.iamProperties()).add("RedshiftProperties", (Object)this.redshiftProperties()).add("SparkEmrProperties", (Object)this.sparkEmrProperties()).add("SparkGlueProperties", (Object)this.sparkGlueProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "athenaProperties": {
                return Optional.ofNullable(clazz.cast(this.athenaProperties()));
            }
            case "glueProperties": {
                return Optional.ofNullable(clazz.cast(this.glueProperties()));
            }
            case "hyperPodProperties": {
                return Optional.ofNullable(clazz.cast(this.hyperPodProperties()));
            }
            case "iamProperties": {
                return Optional.ofNullable(clazz.cast(this.iamProperties()));
            }
            case "redshiftProperties": {
                return Optional.ofNullable(clazz.cast(this.redshiftProperties()));
            }
            case "sparkEmrProperties": {
                return Optional.ofNullable(clazz.cast(this.sparkEmrProperties()));
            }
            case "sparkGlueProperties": {
                return Optional.ofNullable(clazz.cast(this.sparkGlueProperties()));
            }
        }
        return Optional.empty();
    }

    public static ConnectionPropertiesInput fromAthenaProperties(AthenaPropertiesInput athenaProperties) {
        return (ConnectionPropertiesInput)ConnectionPropertiesInput.builder().athenaProperties(athenaProperties).build();
    }

    public static ConnectionPropertiesInput fromAthenaProperties(Consumer<AthenaPropertiesInput.Builder> athenaProperties) {
        AthenaPropertiesInput.Builder builder = AthenaPropertiesInput.builder();
        athenaProperties.accept(builder);
        return ConnectionPropertiesInput.fromAthenaProperties((AthenaPropertiesInput)builder.build());
    }

    public static ConnectionPropertiesInput fromGlueProperties(GluePropertiesInput glueProperties) {
        return (ConnectionPropertiesInput)ConnectionPropertiesInput.builder().glueProperties(glueProperties).build();
    }

    public static ConnectionPropertiesInput fromGlueProperties(Consumer<GluePropertiesInput.Builder> glueProperties) {
        GluePropertiesInput.Builder builder = GluePropertiesInput.builder();
        glueProperties.accept(builder);
        return ConnectionPropertiesInput.fromGlueProperties((GluePropertiesInput)builder.build());
    }

    public static ConnectionPropertiesInput fromHyperPodProperties(HyperPodPropertiesInput hyperPodProperties) {
        return (ConnectionPropertiesInput)ConnectionPropertiesInput.builder().hyperPodProperties(hyperPodProperties).build();
    }

    public static ConnectionPropertiesInput fromHyperPodProperties(Consumer<HyperPodPropertiesInput.Builder> hyperPodProperties) {
        HyperPodPropertiesInput.Builder builder = HyperPodPropertiesInput.builder();
        hyperPodProperties.accept(builder);
        return ConnectionPropertiesInput.fromHyperPodProperties((HyperPodPropertiesInput)builder.build());
    }

    public static ConnectionPropertiesInput fromIamProperties(IamPropertiesInput iamProperties) {
        return (ConnectionPropertiesInput)ConnectionPropertiesInput.builder().iamProperties(iamProperties).build();
    }

    public static ConnectionPropertiesInput fromIamProperties(Consumer<IamPropertiesInput.Builder> iamProperties) {
        IamPropertiesInput.Builder builder = IamPropertiesInput.builder();
        iamProperties.accept(builder);
        return ConnectionPropertiesInput.fromIamProperties((IamPropertiesInput)builder.build());
    }

    public static ConnectionPropertiesInput fromRedshiftProperties(RedshiftPropertiesInput redshiftProperties) {
        return (ConnectionPropertiesInput)ConnectionPropertiesInput.builder().redshiftProperties(redshiftProperties).build();
    }

    public static ConnectionPropertiesInput fromRedshiftProperties(Consumer<RedshiftPropertiesInput.Builder> redshiftProperties) {
        RedshiftPropertiesInput.Builder builder = RedshiftPropertiesInput.builder();
        redshiftProperties.accept(builder);
        return ConnectionPropertiesInput.fromRedshiftProperties((RedshiftPropertiesInput)builder.build());
    }

    public static ConnectionPropertiesInput fromSparkEmrProperties(SparkEmrPropertiesInput sparkEmrProperties) {
        return (ConnectionPropertiesInput)ConnectionPropertiesInput.builder().sparkEmrProperties(sparkEmrProperties).build();
    }

    public static ConnectionPropertiesInput fromSparkEmrProperties(Consumer<SparkEmrPropertiesInput.Builder> sparkEmrProperties) {
        SparkEmrPropertiesInput.Builder builder = SparkEmrPropertiesInput.builder();
        sparkEmrProperties.accept(builder);
        return ConnectionPropertiesInput.fromSparkEmrProperties((SparkEmrPropertiesInput)builder.build());
    }

    public static ConnectionPropertiesInput fromSparkGlueProperties(SparkGluePropertiesInput sparkGlueProperties) {
        return (ConnectionPropertiesInput)ConnectionPropertiesInput.builder().sparkGlueProperties(sparkGlueProperties).build();
    }

    public static ConnectionPropertiesInput fromSparkGlueProperties(Consumer<SparkGluePropertiesInput.Builder> sparkGlueProperties) {
        SparkGluePropertiesInput.Builder builder = SparkGluePropertiesInput.builder();
        sparkGlueProperties.accept(builder);
        return ConnectionPropertiesInput.fromSparkGlueProperties((SparkGluePropertiesInput)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionPropertiesInput, T> g) {
        return obj -> g.apply((ConnectionPropertiesInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ATHENA_PROPERTIES,
        GLUE_PROPERTIES,
        HYPER_POD_PROPERTIES,
        IAM_PROPERTIES,
        REDSHIFT_PROPERTIES,
        SPARK_EMR_PROPERTIES,
        SPARK_GLUE_PROPERTIES,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AthenaPropertiesInput athenaProperties;
        private GluePropertiesInput glueProperties;
        private HyperPodPropertiesInput hyperPodProperties;
        private IamPropertiesInput iamProperties;
        private RedshiftPropertiesInput redshiftProperties;
        private SparkEmrPropertiesInput sparkEmrProperties;
        private SparkGluePropertiesInput sparkGlueProperties;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionPropertiesInput model) {
            this.athenaProperties(model.athenaProperties);
            this.glueProperties(model.glueProperties);
            this.hyperPodProperties(model.hyperPodProperties);
            this.iamProperties(model.iamProperties);
            this.redshiftProperties(model.redshiftProperties);
            this.sparkEmrProperties(model.sparkEmrProperties);
            this.sparkGlueProperties(model.sparkGlueProperties);
        }

        public final AthenaPropertiesInput.Builder getAthenaProperties() {
            return this.athenaProperties != null ? this.athenaProperties.toBuilder() : null;
        }

        public final void setAthenaProperties(AthenaPropertiesInput.BuilderImpl athenaProperties) {
            AthenaPropertiesInput oldValue = this.athenaProperties;
            this.athenaProperties = athenaProperties != null ? athenaProperties.build() : null;
            this.handleUnionValueChange(Type.ATHENA_PROPERTIES, oldValue, this.athenaProperties);
        }

        @Override
        public final Builder athenaProperties(AthenaPropertiesInput athenaProperties) {
            AthenaPropertiesInput oldValue = this.athenaProperties;
            this.athenaProperties = athenaProperties;
            this.handleUnionValueChange(Type.ATHENA_PROPERTIES, oldValue, this.athenaProperties);
            return this;
        }

        public final GluePropertiesInput.Builder getGlueProperties() {
            return this.glueProperties != null ? this.glueProperties.toBuilder() : null;
        }

        public final void setGlueProperties(GluePropertiesInput.BuilderImpl glueProperties) {
            GluePropertiesInput oldValue = this.glueProperties;
            this.glueProperties = glueProperties != null ? glueProperties.build() : null;
            this.handleUnionValueChange(Type.GLUE_PROPERTIES, oldValue, this.glueProperties);
        }

        @Override
        public final Builder glueProperties(GluePropertiesInput glueProperties) {
            GluePropertiesInput oldValue = this.glueProperties;
            this.glueProperties = glueProperties;
            this.handleUnionValueChange(Type.GLUE_PROPERTIES, oldValue, this.glueProperties);
            return this;
        }

        public final HyperPodPropertiesInput.Builder getHyperPodProperties() {
            return this.hyperPodProperties != null ? this.hyperPodProperties.toBuilder() : null;
        }

        public final void setHyperPodProperties(HyperPodPropertiesInput.BuilderImpl hyperPodProperties) {
            HyperPodPropertiesInput oldValue = this.hyperPodProperties;
            this.hyperPodProperties = hyperPodProperties != null ? hyperPodProperties.build() : null;
            this.handleUnionValueChange(Type.HYPER_POD_PROPERTIES, oldValue, this.hyperPodProperties);
        }

        @Override
        public final Builder hyperPodProperties(HyperPodPropertiesInput hyperPodProperties) {
            HyperPodPropertiesInput oldValue = this.hyperPodProperties;
            this.hyperPodProperties = hyperPodProperties;
            this.handleUnionValueChange(Type.HYPER_POD_PROPERTIES, oldValue, this.hyperPodProperties);
            return this;
        }

        public final IamPropertiesInput.Builder getIamProperties() {
            return this.iamProperties != null ? this.iamProperties.toBuilder() : null;
        }

        public final void setIamProperties(IamPropertiesInput.BuilderImpl iamProperties) {
            IamPropertiesInput oldValue = this.iamProperties;
            this.iamProperties = iamProperties != null ? iamProperties.build() : null;
            this.handleUnionValueChange(Type.IAM_PROPERTIES, oldValue, this.iamProperties);
        }

        @Override
        public final Builder iamProperties(IamPropertiesInput iamProperties) {
            IamPropertiesInput oldValue = this.iamProperties;
            this.iamProperties = iamProperties;
            this.handleUnionValueChange(Type.IAM_PROPERTIES, oldValue, this.iamProperties);
            return this;
        }

        public final RedshiftPropertiesInput.Builder getRedshiftProperties() {
            return this.redshiftProperties != null ? this.redshiftProperties.toBuilder() : null;
        }

        public final void setRedshiftProperties(RedshiftPropertiesInput.BuilderImpl redshiftProperties) {
            RedshiftPropertiesInput oldValue = this.redshiftProperties;
            this.redshiftProperties = redshiftProperties != null ? redshiftProperties.build() : null;
            this.handleUnionValueChange(Type.REDSHIFT_PROPERTIES, oldValue, this.redshiftProperties);
        }

        @Override
        public final Builder redshiftProperties(RedshiftPropertiesInput redshiftProperties) {
            RedshiftPropertiesInput oldValue = this.redshiftProperties;
            this.redshiftProperties = redshiftProperties;
            this.handleUnionValueChange(Type.REDSHIFT_PROPERTIES, oldValue, this.redshiftProperties);
            return this;
        }

        public final SparkEmrPropertiesInput.Builder getSparkEmrProperties() {
            return this.sparkEmrProperties != null ? this.sparkEmrProperties.toBuilder() : null;
        }

        public final void setSparkEmrProperties(SparkEmrPropertiesInput.BuilderImpl sparkEmrProperties) {
            SparkEmrPropertiesInput oldValue = this.sparkEmrProperties;
            this.sparkEmrProperties = sparkEmrProperties != null ? sparkEmrProperties.build() : null;
            this.handleUnionValueChange(Type.SPARK_EMR_PROPERTIES, oldValue, this.sparkEmrProperties);
        }

        @Override
        public final Builder sparkEmrProperties(SparkEmrPropertiesInput sparkEmrProperties) {
            SparkEmrPropertiesInput oldValue = this.sparkEmrProperties;
            this.sparkEmrProperties = sparkEmrProperties;
            this.handleUnionValueChange(Type.SPARK_EMR_PROPERTIES, oldValue, this.sparkEmrProperties);
            return this;
        }

        public final SparkGluePropertiesInput.Builder getSparkGlueProperties() {
            return this.sparkGlueProperties != null ? this.sparkGlueProperties.toBuilder() : null;
        }

        public final void setSparkGlueProperties(SparkGluePropertiesInput.BuilderImpl sparkGlueProperties) {
            SparkGluePropertiesInput oldValue = this.sparkGlueProperties;
            this.sparkGlueProperties = sparkGlueProperties != null ? sparkGlueProperties.build() : null;
            this.handleUnionValueChange(Type.SPARK_GLUE_PROPERTIES, oldValue, this.sparkGlueProperties);
        }

        @Override
        public final Builder sparkGlueProperties(SparkGluePropertiesInput sparkGlueProperties) {
            SparkGluePropertiesInput oldValue = this.sparkGlueProperties;
            this.sparkGlueProperties = sparkGlueProperties;
            this.handleUnionValueChange(Type.SPARK_GLUE_PROPERTIES, oldValue, this.sparkGlueProperties);
            return this;
        }

        public ConnectionPropertiesInput build() {
            return new ConnectionPropertiesInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionPropertiesInput> {
        public Builder athenaProperties(AthenaPropertiesInput var1);

        default public Builder athenaProperties(Consumer<AthenaPropertiesInput.Builder> athenaProperties) {
            return this.athenaProperties((AthenaPropertiesInput)((AthenaPropertiesInput.Builder)AthenaPropertiesInput.builder().applyMutation(athenaProperties)).build());
        }

        public Builder glueProperties(GluePropertiesInput var1);

        default public Builder glueProperties(Consumer<GluePropertiesInput.Builder> glueProperties) {
            return this.glueProperties((GluePropertiesInput)((GluePropertiesInput.Builder)GluePropertiesInput.builder().applyMutation(glueProperties)).build());
        }

        public Builder hyperPodProperties(HyperPodPropertiesInput var1);

        default public Builder hyperPodProperties(Consumer<HyperPodPropertiesInput.Builder> hyperPodProperties) {
            return this.hyperPodProperties((HyperPodPropertiesInput)((HyperPodPropertiesInput.Builder)HyperPodPropertiesInput.builder().applyMutation(hyperPodProperties)).build());
        }

        public Builder iamProperties(IamPropertiesInput var1);

        default public Builder iamProperties(Consumer<IamPropertiesInput.Builder> iamProperties) {
            return this.iamProperties((IamPropertiesInput)((IamPropertiesInput.Builder)IamPropertiesInput.builder().applyMutation(iamProperties)).build());
        }

        public Builder redshiftProperties(RedshiftPropertiesInput var1);

        default public Builder redshiftProperties(Consumer<RedshiftPropertiesInput.Builder> redshiftProperties) {
            return this.redshiftProperties((RedshiftPropertiesInput)((RedshiftPropertiesInput.Builder)RedshiftPropertiesInput.builder().applyMutation(redshiftProperties)).build());
        }

        public Builder sparkEmrProperties(SparkEmrPropertiesInput var1);

        default public Builder sparkEmrProperties(Consumer<SparkEmrPropertiesInput.Builder> sparkEmrProperties) {
            return this.sparkEmrProperties((SparkEmrPropertiesInput)((SparkEmrPropertiesInput.Builder)SparkEmrPropertiesInput.builder().applyMutation(sparkEmrProperties)).build());
        }

        public Builder sparkGlueProperties(SparkGluePropertiesInput var1);

        default public Builder sparkGlueProperties(Consumer<SparkGluePropertiesInput.Builder> sparkGlueProperties) {
            return this.sparkGlueProperties((SparkGluePropertiesInput)((SparkGluePropertiesInput.Builder)SparkGluePropertiesInput.builder().applyMutation(sparkGlueProperties)).build());
        }
    }
}

