/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.AthenaPropertiesPatch;
import software.amazon.awssdk.services.datazone.model.GluePropertiesPatch;
import software.amazon.awssdk.services.datazone.model.IamPropertiesPatch;
import software.amazon.awssdk.services.datazone.model.RedshiftPropertiesPatch;
import software.amazon.awssdk.services.datazone.model.SparkEmrPropertiesPatch;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionPropertiesPatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionPropertiesPatch> {
    private static final SdkField<AthenaPropertiesPatch> ATHENA_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("athenaProperties").getter(ConnectionPropertiesPatch.getter(ConnectionPropertiesPatch::athenaProperties)).setter(ConnectionPropertiesPatch.setter(Builder::athenaProperties)).constructor(AthenaPropertiesPatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("athenaProperties").build()}).build();
    private static final SdkField<GluePropertiesPatch> GLUE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("glueProperties").getter(ConnectionPropertiesPatch.getter(ConnectionPropertiesPatch::glueProperties)).setter(ConnectionPropertiesPatch.setter(Builder::glueProperties)).constructor(GluePropertiesPatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueProperties").build()}).build();
    private static final SdkField<IamPropertiesPatch> IAM_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iamProperties").getter(ConnectionPropertiesPatch.getter(ConnectionPropertiesPatch::iamProperties)).setter(ConnectionPropertiesPatch.setter(Builder::iamProperties)).constructor(IamPropertiesPatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamProperties").build()}).build();
    private static final SdkField<RedshiftPropertiesPatch> REDSHIFT_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("redshiftProperties").getter(ConnectionPropertiesPatch.getter(ConnectionPropertiesPatch::redshiftProperties)).setter(ConnectionPropertiesPatch.setter(Builder::redshiftProperties)).constructor(RedshiftPropertiesPatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftProperties").build()}).build();
    private static final SdkField<SparkEmrPropertiesPatch> SPARK_EMR_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sparkEmrProperties").getter(ConnectionPropertiesPatch.getter(ConnectionPropertiesPatch::sparkEmrProperties)).setter(ConnectionPropertiesPatch.setter(Builder::sparkEmrProperties)).constructor(SparkEmrPropertiesPatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkEmrProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATHENA_PROPERTIES_FIELD, GLUE_PROPERTIES_FIELD, IAM_PROPERTIES_FIELD, REDSHIFT_PROPERTIES_FIELD, SPARK_EMR_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("athenaProperties", ATHENA_PROPERTIES_FIELD);
            this.put("glueProperties", GLUE_PROPERTIES_FIELD);
            this.put("iamProperties", IAM_PROPERTIES_FIELD);
            this.put("redshiftProperties", REDSHIFT_PROPERTIES_FIELD);
            this.put("sparkEmrProperties", SPARK_EMR_PROPERTIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AthenaPropertiesPatch athenaProperties;
    private final GluePropertiesPatch glueProperties;
    private final IamPropertiesPatch iamProperties;
    private final RedshiftPropertiesPatch redshiftProperties;
    private final SparkEmrPropertiesPatch sparkEmrProperties;
    private final Type type;

    private ConnectionPropertiesPatch(BuilderImpl builder) {
        this.athenaProperties = builder.athenaProperties;
        this.glueProperties = builder.glueProperties;
        this.iamProperties = builder.iamProperties;
        this.redshiftProperties = builder.redshiftProperties;
        this.sparkEmrProperties = builder.sparkEmrProperties;
        this.type = builder.type;
    }

    public final AthenaPropertiesPatch athenaProperties() {
        return this.athenaProperties;
    }

    public final GluePropertiesPatch glueProperties() {
        return this.glueProperties;
    }

    public final IamPropertiesPatch iamProperties() {
        return this.iamProperties;
    }

    public final RedshiftPropertiesPatch redshiftProperties() {
        return this.redshiftProperties;
    }

    public final SparkEmrPropertiesPatch sparkEmrProperties() {
        return this.sparkEmrProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.athenaProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.sparkEmrProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionPropertiesPatch)) {
            return false;
        }
        ConnectionPropertiesPatch other = (ConnectionPropertiesPatch)obj;
        return Objects.equals(this.athenaProperties(), other.athenaProperties()) && Objects.equals(this.glueProperties(), other.glueProperties()) && Objects.equals(this.iamProperties(), other.iamProperties()) && Objects.equals(this.redshiftProperties(), other.redshiftProperties()) && Objects.equals(this.sparkEmrProperties(), other.sparkEmrProperties());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionPropertiesPatch").add("AthenaProperties", (Object)this.athenaProperties()).add("GlueProperties", (Object)this.glueProperties()).add("IamProperties", (Object)this.iamProperties()).add("RedshiftProperties", (Object)this.redshiftProperties()).add("SparkEmrProperties", (Object)this.sparkEmrProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "athenaProperties": {
                return Optional.ofNullable(clazz.cast(this.athenaProperties()));
            }
            case "glueProperties": {
                return Optional.ofNullable(clazz.cast(this.glueProperties()));
            }
            case "iamProperties": {
                return Optional.ofNullable(clazz.cast(this.iamProperties()));
            }
            case "redshiftProperties": {
                return Optional.ofNullable(clazz.cast(this.redshiftProperties()));
            }
            case "sparkEmrProperties": {
                return Optional.ofNullable(clazz.cast(this.sparkEmrProperties()));
            }
        }
        return Optional.empty();
    }

    public static ConnectionPropertiesPatch fromAthenaProperties(AthenaPropertiesPatch athenaProperties) {
        return (ConnectionPropertiesPatch)ConnectionPropertiesPatch.builder().athenaProperties(athenaProperties).build();
    }

    public static ConnectionPropertiesPatch fromAthenaProperties(Consumer<AthenaPropertiesPatch.Builder> athenaProperties) {
        AthenaPropertiesPatch.Builder builder = AthenaPropertiesPatch.builder();
        athenaProperties.accept(builder);
        return ConnectionPropertiesPatch.fromAthenaProperties((AthenaPropertiesPatch)builder.build());
    }

    public static ConnectionPropertiesPatch fromGlueProperties(GluePropertiesPatch glueProperties) {
        return (ConnectionPropertiesPatch)ConnectionPropertiesPatch.builder().glueProperties(glueProperties).build();
    }

    public static ConnectionPropertiesPatch fromGlueProperties(Consumer<GluePropertiesPatch.Builder> glueProperties) {
        GluePropertiesPatch.Builder builder = GluePropertiesPatch.builder();
        glueProperties.accept(builder);
        return ConnectionPropertiesPatch.fromGlueProperties((GluePropertiesPatch)builder.build());
    }

    public static ConnectionPropertiesPatch fromIamProperties(IamPropertiesPatch iamProperties) {
        return (ConnectionPropertiesPatch)ConnectionPropertiesPatch.builder().iamProperties(iamProperties).build();
    }

    public static ConnectionPropertiesPatch fromIamProperties(Consumer<IamPropertiesPatch.Builder> iamProperties) {
        IamPropertiesPatch.Builder builder = IamPropertiesPatch.builder();
        iamProperties.accept(builder);
        return ConnectionPropertiesPatch.fromIamProperties((IamPropertiesPatch)builder.build());
    }

    public static ConnectionPropertiesPatch fromRedshiftProperties(RedshiftPropertiesPatch redshiftProperties) {
        return (ConnectionPropertiesPatch)ConnectionPropertiesPatch.builder().redshiftProperties(redshiftProperties).build();
    }

    public static ConnectionPropertiesPatch fromRedshiftProperties(Consumer<RedshiftPropertiesPatch.Builder> redshiftProperties) {
        RedshiftPropertiesPatch.Builder builder = RedshiftPropertiesPatch.builder();
        redshiftProperties.accept(builder);
        return ConnectionPropertiesPatch.fromRedshiftProperties((RedshiftPropertiesPatch)builder.build());
    }

    public static ConnectionPropertiesPatch fromSparkEmrProperties(SparkEmrPropertiesPatch sparkEmrProperties) {
        return (ConnectionPropertiesPatch)ConnectionPropertiesPatch.builder().sparkEmrProperties(sparkEmrProperties).build();
    }

    public static ConnectionPropertiesPatch fromSparkEmrProperties(Consumer<SparkEmrPropertiesPatch.Builder> sparkEmrProperties) {
        SparkEmrPropertiesPatch.Builder builder = SparkEmrPropertiesPatch.builder();
        sparkEmrProperties.accept(builder);
        return ConnectionPropertiesPatch.fromSparkEmrProperties((SparkEmrPropertiesPatch)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionPropertiesPatch, T> g) {
        return obj -> g.apply((ConnectionPropertiesPatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ATHENA_PROPERTIES,
        GLUE_PROPERTIES,
        IAM_PROPERTIES,
        REDSHIFT_PROPERTIES,
        SPARK_EMR_PROPERTIES,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AthenaPropertiesPatch athenaProperties;
        private GluePropertiesPatch glueProperties;
        private IamPropertiesPatch iamProperties;
        private RedshiftPropertiesPatch redshiftProperties;
        private SparkEmrPropertiesPatch sparkEmrProperties;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionPropertiesPatch model) {
            this.athenaProperties(model.athenaProperties);
            this.glueProperties(model.glueProperties);
            this.iamProperties(model.iamProperties);
            this.redshiftProperties(model.redshiftProperties);
            this.sparkEmrProperties(model.sparkEmrProperties);
        }

        public final AthenaPropertiesPatch.Builder getAthenaProperties() {
            return this.athenaProperties != null ? this.athenaProperties.toBuilder() : null;
        }

        public final void setAthenaProperties(AthenaPropertiesPatch.BuilderImpl athenaProperties) {
            AthenaPropertiesPatch oldValue = this.athenaProperties;
            this.athenaProperties = athenaProperties != null ? athenaProperties.build() : null;
            this.handleUnionValueChange(Type.ATHENA_PROPERTIES, oldValue, this.athenaProperties);
        }

        @Override
        public final Builder athenaProperties(AthenaPropertiesPatch athenaProperties) {
            AthenaPropertiesPatch oldValue = this.athenaProperties;
            this.athenaProperties = athenaProperties;
            this.handleUnionValueChange(Type.ATHENA_PROPERTIES, oldValue, this.athenaProperties);
            return this;
        }

        public final GluePropertiesPatch.Builder getGlueProperties() {
            return this.glueProperties != null ? this.glueProperties.toBuilder() : null;
        }

        public final void setGlueProperties(GluePropertiesPatch.BuilderImpl glueProperties) {
            GluePropertiesPatch oldValue = this.glueProperties;
            this.glueProperties = glueProperties != null ? glueProperties.build() : null;
            this.handleUnionValueChange(Type.GLUE_PROPERTIES, oldValue, this.glueProperties);
        }

        @Override
        public final Builder glueProperties(GluePropertiesPatch glueProperties) {
            GluePropertiesPatch oldValue = this.glueProperties;
            this.glueProperties = glueProperties;
            this.handleUnionValueChange(Type.GLUE_PROPERTIES, oldValue, this.glueProperties);
            return this;
        }

        public final IamPropertiesPatch.Builder getIamProperties() {
            return this.iamProperties != null ? this.iamProperties.toBuilder() : null;
        }

        public final void setIamProperties(IamPropertiesPatch.BuilderImpl iamProperties) {
            IamPropertiesPatch oldValue = this.iamProperties;
            this.iamProperties = iamProperties != null ? iamProperties.build() : null;
            this.handleUnionValueChange(Type.IAM_PROPERTIES, oldValue, this.iamProperties);
        }

        @Override
        public final Builder iamProperties(IamPropertiesPatch iamProperties) {
            IamPropertiesPatch oldValue = this.iamProperties;
            this.iamProperties = iamProperties;
            this.handleUnionValueChange(Type.IAM_PROPERTIES, oldValue, this.iamProperties);
            return this;
        }

        public final RedshiftPropertiesPatch.Builder getRedshiftProperties() {
            return this.redshiftProperties != null ? this.redshiftProperties.toBuilder() : null;
        }

        public final void setRedshiftProperties(RedshiftPropertiesPatch.BuilderImpl redshiftProperties) {
            RedshiftPropertiesPatch oldValue = this.redshiftProperties;
            this.redshiftProperties = redshiftProperties != null ? redshiftProperties.build() : null;
            this.handleUnionValueChange(Type.REDSHIFT_PROPERTIES, oldValue, this.redshiftProperties);
        }

        @Override
        public final Builder redshiftProperties(RedshiftPropertiesPatch redshiftProperties) {
            RedshiftPropertiesPatch oldValue = this.redshiftProperties;
            this.redshiftProperties = redshiftProperties;
            this.handleUnionValueChange(Type.REDSHIFT_PROPERTIES, oldValue, this.redshiftProperties);
            return this;
        }

        public final SparkEmrPropertiesPatch.Builder getSparkEmrProperties() {
            return this.sparkEmrProperties != null ? this.sparkEmrProperties.toBuilder() : null;
        }

        public final void setSparkEmrProperties(SparkEmrPropertiesPatch.BuilderImpl sparkEmrProperties) {
            SparkEmrPropertiesPatch oldValue = this.sparkEmrProperties;
            this.sparkEmrProperties = sparkEmrProperties != null ? sparkEmrProperties.build() : null;
            this.handleUnionValueChange(Type.SPARK_EMR_PROPERTIES, oldValue, this.sparkEmrProperties);
        }

        @Override
        public final Builder sparkEmrProperties(SparkEmrPropertiesPatch sparkEmrProperties) {
            SparkEmrPropertiesPatch oldValue = this.sparkEmrProperties;
            this.sparkEmrProperties = sparkEmrProperties;
            this.handleUnionValueChange(Type.SPARK_EMR_PROPERTIES, oldValue, this.sparkEmrProperties);
            return this;
        }

        public ConnectionPropertiesPatch build() {
            return new ConnectionPropertiesPatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionPropertiesPatch> {
        public Builder athenaProperties(AthenaPropertiesPatch var1);

        default public Builder athenaProperties(Consumer<AthenaPropertiesPatch.Builder> athenaProperties) {
            return this.athenaProperties((AthenaPropertiesPatch)((AthenaPropertiesPatch.Builder)AthenaPropertiesPatch.builder().applyMutation(athenaProperties)).build());
        }

        public Builder glueProperties(GluePropertiesPatch var1);

        default public Builder glueProperties(Consumer<GluePropertiesPatch.Builder> glueProperties) {
            return this.glueProperties((GluePropertiesPatch)((GluePropertiesPatch.Builder)GluePropertiesPatch.builder().applyMutation(glueProperties)).build());
        }

        public Builder iamProperties(IamPropertiesPatch var1);

        default public Builder iamProperties(Consumer<IamPropertiesPatch.Builder> iamProperties) {
            return this.iamProperties((IamPropertiesPatch)((IamPropertiesPatch.Builder)IamPropertiesPatch.builder().applyMutation(iamProperties)).build());
        }

        public Builder redshiftProperties(RedshiftPropertiesPatch var1);

        default public Builder redshiftProperties(Consumer<RedshiftPropertiesPatch.Builder> redshiftProperties) {
            return this.redshiftProperties((RedshiftPropertiesPatch)((RedshiftPropertiesPatch.Builder)RedshiftPropertiesPatch.builder().applyMutation(redshiftProperties)).build());
        }

        public Builder sparkEmrProperties(SparkEmrPropertiesPatch var1);

        default public Builder sparkEmrProperties(Consumer<SparkEmrPropertiesPatch.Builder> sparkEmrProperties) {
            return this.sparkEmrProperties((SparkEmrPropertiesPatch)((SparkEmrPropertiesPatch.Builder)SparkEmrPropertiesPatch.builder().applyMutation(sparkEmrProperties)).build());
        }
    }
}

