/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Member
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Member> {
    private static final SdkField<String> GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupIdentifier").getter(Member.getter(Member::groupIdentifier)).setter(Member.setter(Builder::groupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupIdentifier").build()}).build();
    private static final SdkField<String> USER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userIdentifier").getter(Member.getter(Member::userIdentifier)).setter(Member.setter(Builder::userIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_IDENTIFIER_FIELD, USER_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("groupIdentifier", GROUP_IDENTIFIER_FIELD);
            this.put("userIdentifier", USER_IDENTIFIER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String groupIdentifier;
    private final String userIdentifier;
    private final Type type;

    private Member(BuilderImpl builder) {
        this.groupIdentifier = builder.groupIdentifier;
        this.userIdentifier = builder.userIdentifier;
        this.type = builder.type;
    }

    public final String groupIdentifier() {
        return this.groupIdentifier;
    }

    public final String userIdentifier() {
        return this.userIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.userIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Member)) {
            return false;
        }
        Member other = (Member)obj;
        return Objects.equals(this.groupIdentifier(), other.groupIdentifier()) && Objects.equals(this.userIdentifier(), other.userIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"Member").add("GroupIdentifier", (Object)this.groupIdentifier()).add("UserIdentifier", (Object)this.userIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "groupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.groupIdentifier()));
            }
            case "userIdentifier": {
                return Optional.ofNullable(clazz.cast(this.userIdentifier()));
            }
        }
        return Optional.empty();
    }

    public static Member fromGroupIdentifier(String groupIdentifier) {
        return (Member)Member.builder().groupIdentifier(groupIdentifier).build();
    }

    public static Member fromUserIdentifier(String userIdentifier) {
        return (Member)Member.builder().userIdentifier(userIdentifier).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Member, T> g) {
        return obj -> g.apply((Member)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        GROUP_IDENTIFIER,
        USER_IDENTIFIER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String groupIdentifier;
        private String userIdentifier;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Member model) {
            this.groupIdentifier(model.groupIdentifier);
            this.userIdentifier(model.userIdentifier);
        }

        public final String getGroupIdentifier() {
            return this.groupIdentifier;
        }

        public final void setGroupIdentifier(String groupIdentifier) {
            String oldValue = this.groupIdentifier;
            this.groupIdentifier = groupIdentifier;
            this.handleUnionValueChange(Type.GROUP_IDENTIFIER, oldValue, this.groupIdentifier);
        }

        @Override
        public final Builder groupIdentifier(String groupIdentifier) {
            String oldValue = this.groupIdentifier;
            this.groupIdentifier = groupIdentifier;
            this.handleUnionValueChange(Type.GROUP_IDENTIFIER, oldValue, this.groupIdentifier);
            return this;
        }

        public final String getUserIdentifier() {
            return this.userIdentifier;
        }

        public final void setUserIdentifier(String userIdentifier) {
            String oldValue = this.userIdentifier;
            this.userIdentifier = userIdentifier;
            this.handleUnionValueChange(Type.USER_IDENTIFIER, oldValue, this.userIdentifier);
        }

        @Override
        public final Builder userIdentifier(String userIdentifier) {
            String oldValue = this.userIdentifier;
            this.userIdentifier = userIdentifier;
            this.handleUnionValueChange(Type.USER_IDENTIFIER, oldValue, this.userIdentifier);
            return this;
        }

        public Member build() {
            return new Member(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Member> {
        public Builder groupIdentifier(String var1);

        public Builder userIdentifier(String var1);
    }
}

