/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.DomainUnitGroupProperties;
import software.amazon.awssdk.services.datazone.model.DomainUnitUserProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainUnitOwnerProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainUnitOwnerProperties> {
    private static final SdkField<DomainUnitGroupProperties> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("group").getter(DomainUnitOwnerProperties.getter(DomainUnitOwnerProperties::group)).setter(DomainUnitOwnerProperties.setter(Builder::group)).constructor(DomainUnitGroupProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()}).build();
    private static final SdkField<DomainUnitUserProperties> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("user").getter(DomainUnitOwnerProperties.getter(DomainUnitOwnerProperties::user)).setter(DomainUnitOwnerProperties.setter(Builder::user)).constructor(DomainUnitUserProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, USER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("group", GROUP_FIELD);
            this.put("user", USER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final DomainUnitGroupProperties group;
    private final DomainUnitUserProperties user;
    private final Type type;

    private DomainUnitOwnerProperties(BuilderImpl builder) {
        this.group = builder.group;
        this.user = builder.user;
        this.type = builder.type;
    }

    public final DomainUnitGroupProperties group() {
        return this.group;
    }

    public final DomainUnitUserProperties user() {
        return this.user;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainUnitOwnerProperties)) {
            return false;
        }
        DomainUnitOwnerProperties other = (DomainUnitOwnerProperties)obj;
        return Objects.equals(this.group(), other.group()) && Objects.equals(this.user(), other.user());
    }

    public final String toString() {
        return ToString.builder((String)"DomainUnitOwnerProperties").add("Group", (Object)this.group()).add("User", (Object)this.user()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "user": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
        }
        return Optional.empty();
    }

    public static DomainUnitOwnerProperties fromGroup(DomainUnitGroupProperties group) {
        return (DomainUnitOwnerProperties)DomainUnitOwnerProperties.builder().group(group).build();
    }

    public static DomainUnitOwnerProperties fromGroup(Consumer<DomainUnitGroupProperties.Builder> group) {
        DomainUnitGroupProperties.Builder builder = DomainUnitGroupProperties.builder();
        group.accept(builder);
        return DomainUnitOwnerProperties.fromGroup((DomainUnitGroupProperties)builder.build());
    }

    public static DomainUnitOwnerProperties fromUser(DomainUnitUserProperties user) {
        return (DomainUnitOwnerProperties)DomainUnitOwnerProperties.builder().user(user).build();
    }

    public static DomainUnitOwnerProperties fromUser(Consumer<DomainUnitUserProperties.Builder> user) {
        DomainUnitUserProperties.Builder builder = DomainUnitUserProperties.builder();
        user.accept(builder);
        return DomainUnitOwnerProperties.fromUser((DomainUnitUserProperties)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DomainUnitOwnerProperties, T> g) {
        return obj -> g.apply((DomainUnitOwnerProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        GROUP,
        USER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private DomainUnitGroupProperties group;
        private DomainUnitUserProperties user;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DomainUnitOwnerProperties model) {
            this.group(model.group);
            this.user(model.user);
        }

        public final DomainUnitGroupProperties.Builder getGroup() {
            return this.group != null ? this.group.toBuilder() : null;
        }

        public final void setGroup(DomainUnitGroupProperties.BuilderImpl group) {
            DomainUnitGroupProperties oldValue = this.group;
            this.group = group != null ? group.build() : null;
            this.handleUnionValueChange(Type.GROUP, oldValue, this.group);
        }

        @Override
        public final Builder group(DomainUnitGroupProperties group) {
            DomainUnitGroupProperties oldValue = this.group;
            this.group = group;
            this.handleUnionValueChange(Type.GROUP, oldValue, this.group);
            return this;
        }

        public final DomainUnitUserProperties.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        public final void setUser(DomainUnitUserProperties.BuilderImpl user) {
            DomainUnitUserProperties oldValue = this.user;
            this.user = user != null ? user.build() : null;
            this.handleUnionValueChange(Type.USER, oldValue, this.user);
        }

        @Override
        public final Builder user(DomainUnitUserProperties user) {
            DomainUnitUserProperties oldValue = this.user;
            this.user = user;
            this.handleUnionValueChange(Type.USER, oldValue, this.user);
            return this;
        }

        public DomainUnitOwnerProperties build() {
            return new DomainUnitOwnerProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainUnitOwnerProperties> {
        public Builder group(DomainUnitGroupProperties var1);

        default public Builder group(Consumer<DomainUnitGroupProperties.Builder> group) {
            return this.group((DomainUnitGroupProperties)((DomainUnitGroupProperties.Builder)DomainUnitGroupProperties.builder().applyMutation(group)).build());
        }

        public Builder user(DomainUnitUserProperties var1);

        default public Builder user(Consumer<DomainUnitUserProperties.Builder> user) {
            return this.user((DomainUnitUserProperties)((DomainUnitUserProperties.Builder)DomainUnitUserProperties.builder().applyMutation(user)).build());
        }
    }
}

