/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.FormOutput;
import software.amazon.awssdk.services.datazone.model.FormOutputListCopier;
import software.amazon.awssdk.services.datazone.model.LineageNodeReference;
import software.amazon.awssdk.services.datazone.model.LineageNodeReferenceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLineageNodeResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, GetLineageNodeResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetLineageNodeResponse.getter(GetLineageNodeResponse::createdAt)).setter(GetLineageNodeResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(GetLineageNodeResponse.getter(GetLineageNodeResponse::createdBy)).setter(GetLineageNodeResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetLineageNodeResponse.getter(GetLineageNodeResponse::description)).setter(GetLineageNodeResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(GetLineageNodeResponse.getter(GetLineageNodeResponse::domainId)).setter(GetLineageNodeResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<List<LineageNodeReference>> DOWNSTREAM_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("downstreamNodes").getter(GetLineageNodeResponse.getter(GetLineageNodeResponse::downstreamNodes)).setter(GetLineageNodeResponse.setter(Builder::downstreamNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downstreamNodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LineageNodeReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> EVENT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("eventTimestamp").getter(GetLineageNodeResponse.getter(GetLineageNodeResponse::eventTimestamp)).setter(GetLineageNodeResponse.setter(Builder::eventTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build()}).build();
    private static final SdkField<List<FormOutput>> FORMS_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("formsOutput").getter(GetLineageNodeResponse.getter(GetLineageNodeResponse::formsOutput)).setter(GetLineageNodeResponse.setter(Builder::formsOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formsOutput").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FormOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetLineageNodeResponse.getter(GetLineageNodeResponse::id)).setter(GetLineageNodeResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetLineageNodeResponse.getter(GetLineageNodeResponse::name)).setter(GetLineageNodeResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceIdentifier").getter(GetLineageNodeResponse.getter(GetLineageNodeResponse::sourceIdentifier)).setter(GetLineageNodeResponse.setter(Builder::sourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceIdentifier").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeName").getter(GetLineageNodeResponse.getter(GetLineageNodeResponse::typeName)).setter(GetLineageNodeResponse.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeName").build()}).build();
    private static final SdkField<String> TYPE_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeRevision").getter(GetLineageNodeResponse.getter(GetLineageNodeResponse::typeRevision)).setter(GetLineageNodeResponse.setter(Builder::typeRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeRevision").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetLineageNodeResponse.getter(GetLineageNodeResponse::updatedAt)).setter(GetLineageNodeResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(GetLineageNodeResponse.getter(GetLineageNodeResponse::updatedBy)).setter(GetLineageNodeResponse.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final SdkField<List<LineageNodeReference>> UPSTREAM_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("upstreamNodes").getter(GetLineageNodeResponse.getter(GetLineageNodeResponse::upstreamNodes)).setter(GetLineageNodeResponse.setter(Builder::upstreamNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamNodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LineageNodeReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, DOWNSTREAM_NODES_FIELD, EVENT_TIMESTAMP_FIELD, FORMS_OUTPUT_FIELD, ID_FIELD, NAME_FIELD, SOURCE_IDENTIFIER_FIELD, TYPE_NAME_FIELD, TYPE_REVISION_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, UPSTREAM_NODES_FIELD));
    private final Instant createdAt;
    private final String createdBy;
    private final String description;
    private final String domainId;
    private final List<LineageNodeReference> downstreamNodes;
    private final Instant eventTimestamp;
    private final List<FormOutput> formsOutput;
    private final String id;
    private final String name;
    private final String sourceIdentifier;
    private final String typeName;
    private final String typeRevision;
    private final Instant updatedAt;
    private final String updatedBy;
    private final List<LineageNodeReference> upstreamNodes;

    private GetLineageNodeResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.downstreamNodes = builder.downstreamNodes;
        this.eventTimestamp = builder.eventTimestamp;
        this.formsOutput = builder.formsOutput;
        this.id = builder.id;
        this.name = builder.name;
        this.sourceIdentifier = builder.sourceIdentifier;
        this.typeName = builder.typeName;
        this.typeRevision = builder.typeRevision;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.upstreamNodes = builder.upstreamNodes;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final boolean hasDownstreamNodes() {
        return this.downstreamNodes != null && !(this.downstreamNodes instanceof SdkAutoConstructList);
    }

    public final List<LineageNodeReference> downstreamNodes() {
        return this.downstreamNodes;
    }

    public final Instant eventTimestamp() {
        return this.eventTimestamp;
    }

    public final boolean hasFormsOutput() {
        return this.formsOutput != null && !(this.formsOutput instanceof SdkAutoConstructList);
    }

    public final List<FormOutput> formsOutput() {
        return this.formsOutput;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String sourceIdentifier() {
        return this.sourceIdentifier;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String typeRevision() {
        return this.typeRevision;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public final boolean hasUpstreamNodes() {
        return this.upstreamNodes != null && !(this.upstreamNodes instanceof SdkAutoConstructList);
    }

    public final List<LineageNodeReference> upstreamNodes() {
        return this.upstreamNodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDownstreamNodes() ? this.downstreamNodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormsOutput() ? this.formsOutput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpstreamNodes() ? this.upstreamNodes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLineageNodeResponse)) {
            return false;
        }
        GetLineageNodeResponse other = (GetLineageNodeResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && this.hasDownstreamNodes() == other.hasDownstreamNodes() && Objects.equals(this.downstreamNodes(), other.downstreamNodes()) && Objects.equals(this.eventTimestamp(), other.eventTimestamp()) && this.hasFormsOutput() == other.hasFormsOutput() && Objects.equals(this.formsOutput(), other.formsOutput()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.sourceIdentifier(), other.sourceIdentifier()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.typeRevision(), other.typeRevision()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy()) && this.hasUpstreamNodes() == other.hasUpstreamNodes() && Objects.equals(this.upstreamNodes(), other.upstreamNodes());
    }

    public final String toString() {
        return ToString.builder((String)"GetLineageNodeResponse").add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("Description", (Object)this.description()).add("DomainId", (Object)this.domainId()).add("DownstreamNodes", this.hasDownstreamNodes() ? this.downstreamNodes() : null).add("EventTimestamp", (Object)this.eventTimestamp()).add("FormsOutput", this.hasFormsOutput() ? this.formsOutput() : null).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("SourceIdentifier", (Object)this.sourceIdentifier()).add("TypeName", (Object)this.typeName()).add("TypeRevision", (Object)this.typeRevision()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).add("UpstreamNodes", this.hasUpstreamNodes() ? this.upstreamNodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "downstreamNodes": {
                return Optional.ofNullable(clazz.cast(this.downstreamNodes()));
            }
            case "eventTimestamp": {
                return Optional.ofNullable(clazz.cast(this.eventTimestamp()));
            }
            case "formsOutput": {
                return Optional.ofNullable(clazz.cast(this.formsOutput()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "sourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceIdentifier()));
            }
            case "typeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "typeRevision": {
                return Optional.ofNullable(clazz.cast(this.typeRevision()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
            case "upstreamNodes": {
                return Optional.ofNullable(clazz.cast(this.upstreamNodes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLineageNodeResponse, T> g) {
        return obj -> g.apply((GetLineageNodeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String createdBy;
        private String description;
        private String domainId;
        private List<LineageNodeReference> downstreamNodes = DefaultSdkAutoConstructList.getInstance();
        private Instant eventTimestamp;
        private List<FormOutput> formsOutput = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private String name;
        private String sourceIdentifier;
        private String typeName;
        private String typeRevision;
        private Instant updatedAt;
        private String updatedBy;
        private List<LineageNodeReference> upstreamNodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLineageNodeResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.description(model.description);
            this.domainId(model.domainId);
            this.downstreamNodes(model.downstreamNodes);
            this.eventTimestamp(model.eventTimestamp);
            this.formsOutput(model.formsOutput);
            this.id(model.id);
            this.name(model.name);
            this.sourceIdentifier(model.sourceIdentifier);
            this.typeName(model.typeName);
            this.typeRevision(model.typeRevision);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
            this.upstreamNodes(model.upstreamNodes);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final List<LineageNodeReference.Builder> getDownstreamNodes() {
            List<LineageNodeReference.Builder> result = LineageNodeReferenceListCopier.copyToBuilder(this.downstreamNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDownstreamNodes(Collection<LineageNodeReference.BuilderImpl> downstreamNodes) {
            this.downstreamNodes = LineageNodeReferenceListCopier.copyFromBuilder(downstreamNodes);
        }

        @Override
        public final Builder downstreamNodes(Collection<LineageNodeReference> downstreamNodes) {
            this.downstreamNodes = LineageNodeReferenceListCopier.copy(downstreamNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder downstreamNodes(LineageNodeReference ... downstreamNodes) {
            this.downstreamNodes(Arrays.asList(downstreamNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder downstreamNodes(Consumer<LineageNodeReference.Builder> ... downstreamNodes) {
            this.downstreamNodes(Stream.of(downstreamNodes).map(c -> (LineageNodeReference)((LineageNodeReference.Builder)LineageNodeReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getEventTimestamp() {
            return this.eventTimestamp;
        }

        public final void setEventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final List<FormOutput.Builder> getFormsOutput() {
            List<FormOutput.Builder> result = FormOutputListCopier.copyToBuilder(this.formsOutput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFormsOutput(Collection<FormOutput.BuilderImpl> formsOutput) {
            this.formsOutput = FormOutputListCopier.copyFromBuilder(formsOutput);
        }

        @Override
        public final Builder formsOutput(Collection<FormOutput> formsOutput) {
            this.formsOutput = FormOutputListCopier.copy(formsOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsOutput(FormOutput ... formsOutput) {
            this.formsOutput(Arrays.asList(formsOutput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsOutput(Consumer<FormOutput.Builder> ... formsOutput) {
            this.formsOutput(Stream.of(formsOutput).map(c -> (FormOutput)((FormOutput.Builder)FormOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSourceIdentifier() {
            return this.sourceIdentifier;
        }

        public final void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        @Override
        public final Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getTypeRevision() {
            return this.typeRevision;
        }

        public final void setTypeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
        }

        @Override
        public final Builder typeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final List<LineageNodeReference.Builder> getUpstreamNodes() {
            List<LineageNodeReference.Builder> result = LineageNodeReferenceListCopier.copyToBuilder(this.upstreamNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpstreamNodes(Collection<LineageNodeReference.BuilderImpl> upstreamNodes) {
            this.upstreamNodes = LineageNodeReferenceListCopier.copyFromBuilder(upstreamNodes);
        }

        @Override
        public final Builder upstreamNodes(Collection<LineageNodeReference> upstreamNodes) {
            this.upstreamNodes = LineageNodeReferenceListCopier.copy(upstreamNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upstreamNodes(LineageNodeReference ... upstreamNodes) {
            this.upstreamNodes(Arrays.asList(upstreamNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upstreamNodes(Consumer<LineageNodeReference.Builder> ... upstreamNodes) {
            this.upstreamNodes(Stream.of(upstreamNodes).map(c -> (LineageNodeReference)((LineageNodeReference.Builder)LineageNodeReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetLineageNodeResponse build() {
            return new GetLineageNodeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLineageNodeResponse> {
        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder downstreamNodes(Collection<LineageNodeReference> var1);

        public Builder downstreamNodes(LineageNodeReference ... var1);

        public Builder downstreamNodes(Consumer<LineageNodeReference.Builder> ... var1);

        public Builder eventTimestamp(Instant var1);

        public Builder formsOutput(Collection<FormOutput> var1);

        public Builder formsOutput(FormOutput ... var1);

        public Builder formsOutput(Consumer<FormOutput.Builder> ... var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder sourceIdentifier(String var1);

        public Builder typeName(String var1);

        public Builder typeRevision(String var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);

        public Builder upstreamNodes(Collection<LineageNodeReference> var1);

        public Builder upstreamNodes(LineageNodeReference ... var1);

        public Builder upstreamNodes(Consumer<LineageNodeReference.Builder> ... var1);
    }
}

