/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataProductItemType;
import software.amazon.awssdk.services.datazone.model.ItemGlossaryTermsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataProductItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataProductItem> {
    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("glossaryTerms").getter(DataProductItem.getter(DataProductItem::glossaryTerms)).setter(DataProductItem.setter(Builder::glossaryTerms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(DataProductItem.getter(DataProductItem::identifier)).setter(DataProductItem.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<String> ITEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("itemType").getter(DataProductItem.getter(DataProductItem::itemTypeAsString)).setter(DataProductItem.setter(Builder::itemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemType").build()}).build();
    private static final SdkField<String> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revision").getter(DataProductItem.getter(DataProductItem::revision)).setter(DataProductItem.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOSSARY_TERMS_FIELD, IDENTIFIER_FIELD, ITEM_TYPE_FIELD, REVISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
            this.put("identifier", IDENTIFIER_FIELD);
            this.put("itemType", ITEM_TYPE_FIELD);
            this.put("revision", REVISION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> glossaryTerms;
    private final String identifier;
    private final String itemType;
    private final String revision;

    private DataProductItem(BuilderImpl builder) {
        this.glossaryTerms = builder.glossaryTerms;
        this.identifier = builder.identifier;
        this.itemType = builder.itemType;
        this.revision = builder.revision;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<String> glossaryTerms() {
        return this.glossaryTerms;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final DataProductItemType itemType() {
        return DataProductItemType.fromValue(this.itemType);
    }

    public final String itemTypeAsString() {
        return this.itemType;
    }

    public final String revision() {
        return this.revision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProductItem)) {
            return false;
        }
        DataProductItem other = (DataProductItem)obj;
        return this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.itemTypeAsString(), other.itemTypeAsString()) && Objects.equals(this.revision(), other.revision());
    }

    public final String toString() {
        return ToString.builder((String)"DataProductItem").add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).add("Identifier", (Object)this.identifier()).add("ItemType", (Object)this.itemTypeAsString()).add("Revision", (Object)this.revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "itemType": {
                return Optional.ofNullable(clazz.cast(this.itemTypeAsString()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataProductItem, T> g) {
        return obj -> g.apply((DataProductItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();
        private String identifier;
        private String itemType;
        private String revision;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProductItem model) {
            this.glossaryTerms(model.glossaryTerms);
            this.identifier(model.identifier);
            this.itemType(model.itemType);
            this.revision(model.revision);
        }

        public final Collection<String> getGlossaryTerms() {
            if (this.glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = ItemGlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = ItemGlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getItemType() {
            return this.itemType;
        }

        public final void setItemType(String itemType) {
            this.itemType = itemType;
        }

        @Override
        public final Builder itemType(String itemType) {
            this.itemType = itemType;
            return this;
        }

        @Override
        public final Builder itemType(DataProductItemType itemType) {
            this.itemType(itemType == null ? null : itemType.toString());
            return this;
        }

        public final String getRevision() {
            return this.revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public DataProductItem build() {
            return new DataProductItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataProductItem> {
        public Builder glossaryTerms(Collection<String> var1);

        public Builder glossaryTerms(String ... var1);

        public Builder identifier(String var1);

        public Builder itemType(String var1);

        public Builder itemType(DataProductItemType var1);

        public Builder revision(String var1);
    }
}

