/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchSort
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchSort> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attribute").getter(SearchSort.getter(SearchSort::attribute)).setter(SearchSort.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attribute").build()}).build();
    private static final SdkField<String> ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("order").getter(SearchSort.getter(SearchSort::orderAsString)).setter(SearchSort.setter(Builder::order)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, ORDER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String attribute;
    private final String order;

    private SearchSort(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.order = builder.order;
    }

    public final String attribute() {
        return this.attribute;
    }

    public final SortOrder order() {
        return SortOrder.fromValue(this.order);
    }

    public final String orderAsString() {
        return this.order;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSort)) {
            return false;
        }
        SearchSort other = (SearchSort)obj;
        return Objects.equals(this.attribute(), other.attribute()) && Objects.equals(this.orderAsString(), other.orderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SearchSort").add("Attribute", (Object)this.attribute()).add("Order", (Object)this.orderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attribute": {
                return Optional.ofNullable(clazz.cast(this.attribute()));
            }
            case "order": {
                return Optional.ofNullable(clazz.cast(this.orderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchSort, T> g) {
        return obj -> g.apply((SearchSort)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attribute;
        private String order;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSort model) {
            this.attribute(model.attribute);
            this.order(model.order);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public final String getOrder() {
            return this.order;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(SortOrder order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        public SearchSort build() {
            return new SearchSort(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchSort> {
        public Builder attribute(String var1);

        public Builder order(String var1);

        public Builder order(SortOrder var1);
    }
}

