/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.ProvisioningProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentBlueprintSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentBlueprintSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(EnvironmentBlueprintSummary.getter(EnvironmentBlueprintSummary::createdAt)).setter(EnvironmentBlueprintSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(EnvironmentBlueprintSummary.getter(EnvironmentBlueprintSummary::description)).setter(EnvironmentBlueprintSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(EnvironmentBlueprintSummary.getter(EnvironmentBlueprintSummary::id)).setter(EnvironmentBlueprintSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(EnvironmentBlueprintSummary.getter(EnvironmentBlueprintSummary::name)).setter(EnvironmentBlueprintSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provider").getter(EnvironmentBlueprintSummary.getter(EnvironmentBlueprintSummary::provider)).setter(EnvironmentBlueprintSummary.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()}).build();
    private static final SdkField<ProvisioningProperties> PROVISIONING_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("provisioningProperties").getter(EnvironmentBlueprintSummary.getter(EnvironmentBlueprintSummary::provisioningProperties)).setter(EnvironmentBlueprintSummary.setter(Builder::provisioningProperties)).constructor(ProvisioningProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningProperties").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(EnvironmentBlueprintSummary.getter(EnvironmentBlueprintSummary::updatedAt)).setter(EnvironmentBlueprintSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD, PROVIDER_FIELD, PROVISIONING_PROPERTIES_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String description;
    private final String id;
    private final String name;
    private final String provider;
    private final ProvisioningProperties provisioningProperties;
    private final Instant updatedAt;

    private EnvironmentBlueprintSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.provider = builder.provider;
        this.provisioningProperties = builder.provisioningProperties;
        this.updatedAt = builder.updatedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String provider() {
        return this.provider;
    }

    public final ProvisioningProperties provisioningProperties() {
        return this.provisioningProperties;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentBlueprintSummary)) {
            return false;
        }
        EnvironmentBlueprintSummary other = (EnvironmentBlueprintSummary)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.provider(), other.provider()) && Objects.equals(this.provisioningProperties(), other.provisioningProperties()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentBlueprintSummary").add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Provider", (Object)this.provider()).add("ProvisioningProperties", (Object)this.provisioningProperties()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.provider()));
            }
            case "provisioningProperties": {
                return Optional.ofNullable(clazz.cast(this.provisioningProperties()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentBlueprintSummary, T> g) {
        return obj -> g.apply((EnvironmentBlueprintSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String description;
        private String id;
        private String name;
        private String provider;
        private ProvisioningProperties provisioningProperties;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentBlueprintSummary model) {
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.id(model.id);
            this.name(model.name);
            this.provider(model.provider);
            this.provisioningProperties(model.provisioningProperties);
            this.updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final ProvisioningProperties.Builder getProvisioningProperties() {
            return this.provisioningProperties != null ? this.provisioningProperties.toBuilder() : null;
        }

        public final void setProvisioningProperties(ProvisioningProperties.BuilderImpl provisioningProperties) {
            this.provisioningProperties = provisioningProperties != null ? provisioningProperties.build() : null;
        }

        @Override
        public final Builder provisioningProperties(ProvisioningProperties provisioningProperties) {
            this.provisioningProperties = provisioningProperties;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public EnvironmentBlueprintSummary build() {
            return new EnvironmentBlueprintSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentBlueprintSummary> {
        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder provider(String var1);

        public Builder provisioningProperties(ProvisioningProperties var1);

        default public Builder provisioningProperties(Consumer<ProvisioningProperties.Builder> provisioningProperties) {
            return this.provisioningProperties((ProvisioningProperties)((ProvisioningProperties.Builder)ProvisioningProperties.builder().applyMutation(provisioningProperties)).build());
        }

        public Builder updatedAt(Instant var1);
    }
}

