/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.AssetFilterSummary;
import software.amazon.awssdk.services.datazone.model.ListAssetFiltersRequest;
import software.amazon.awssdk.services.datazone.model.ListAssetFiltersResponse;

public class ListAssetFiltersIterable
implements SdkIterable<ListAssetFiltersResponse> {
    private final DataZoneClient client;
    private final ListAssetFiltersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssetFiltersIterable(DataZoneClient client, ListAssetFiltersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssetFiltersResponseFetcher();
    }

    public Iterator<ListAssetFiltersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssetFilterSummary> items() {
        Function<ListAssetFiltersResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssetFiltersResponseFetcher
    implements SyncPageFetcher<ListAssetFiltersResponse> {
        private ListAssetFiltersResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetFiltersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssetFiltersResponse nextPage(ListAssetFiltersResponse previousPage) {
            if (previousPage == null) {
                return ListAssetFiltersIterable.this.client.listAssetFilters(ListAssetFiltersIterable.this.firstRequest);
            }
            return ListAssetFiltersIterable.this.client.listAssetFilters((ListAssetFiltersRequest)((Object)ListAssetFiltersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

