/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.DataZoneClientBuilder;
import software.amazon.awssdk.services.datazone.DataZoneServiceClientConfiguration;
import software.amazon.awssdk.services.datazone.DefaultDataZoneBaseClientBuilder;
import software.amazon.awssdk.services.datazone.DefaultDataZoneClient;
import software.amazon.awssdk.services.datazone.endpoints.DataZoneEndpointProvider;

@SdkInternalApi
final class DefaultDataZoneClientBuilder
extends DefaultDataZoneBaseClientBuilder<DataZoneClientBuilder, DataZoneClient>
implements DataZoneClientBuilder {
    DefaultDataZoneClientBuilder() {
    }

    @Override
    public DefaultDataZoneClientBuilder endpointProvider(DataZoneEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DataZoneClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDataZoneClientBuilder.validateClientOptions(clientConfiguration);
        DataZoneServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDataZoneClient client = new DefaultDataZoneClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DataZoneServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DataZoneServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

