/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.GroupProfileSummary;
import software.amazon.awssdk.services.datazone.model.SearchGroupProfilesRequest;
import software.amazon.awssdk.services.datazone.model.SearchGroupProfilesResponse;

public class SearchGroupProfilesPublisher
implements SdkPublisher<SearchGroupProfilesResponse> {
    private final DataZoneAsyncClient client;
    private final SearchGroupProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchGroupProfilesPublisher(DataZoneAsyncClient client, SearchGroupProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchGroupProfilesPublisher(DataZoneAsyncClient client, SearchGroupProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchGroupProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchGroupProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GroupProfileSummary> items() {
        Function<SearchGroupProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchGroupProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchGroupProfilesResponseFetcher
    implements AsyncPageFetcher<SearchGroupProfilesResponse> {
        private SearchGroupProfilesResponseFetcher() {
        }

        public boolean hasNextPage(SearchGroupProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchGroupProfilesResponse> nextPage(SearchGroupProfilesResponse previousPage) {
            if (previousPage == null) {
                return SearchGroupProfilesPublisher.this.client.searchGroupProfiles(SearchGroupProfilesPublisher.this.firstRequest);
            }
            return SearchGroupProfilesPublisher.this.client.searchGroupProfiles((SearchGroupProfilesRequest)((Object)SearchGroupProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

