/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NotificationRole {
    PROJECT_OWNER("PROJECT_OWNER"),
    PROJECT_CONTRIBUTOR("PROJECT_CONTRIBUTOR"),
    PROJECT_VIEWER("PROJECT_VIEWER"),
    DOMAIN_OWNER("DOMAIN_OWNER"),
    PROJECT_SUBSCRIBER("PROJECT_SUBSCRIBER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NotificationRole> VALUE_MAP;
    private final String value;

    private NotificationRole(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NotificationRole fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NotificationRole> knownValues() {
        EnumSet<NotificationRole> knownValues = EnumSet.allOf(NotificationRole.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NotificationRole.class, NotificationRole::toString);
    }
}

