/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLocationFsxWindowsRequest extends DataSyncRequest implements
        ToCopyableBuilder<UpdateLocationFsxWindowsRequest.Builder, UpdateLocationFsxWindowsRequest> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationArn").getter(getter(UpdateLocationFsxWindowsRequest::locationArn))
            .setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Subdirectory").getter(getter(UpdateLocationFsxWindowsRequest::subdirectory))
            .setter(setter(Builder::subdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(UpdateLocationFsxWindowsRequest::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("User")
            .getter(getter(UpdateLocationFsxWindowsRequest::user)).setter(setter(Builder::user))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(UpdateLocationFsxWindowsRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD,
            SUBDIRECTORY_FIELD, DOMAIN_FIELD, USER_FIELD, PASSWORD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String locationArn;

    private final String subdirectory;

    private final String domain;

    private final String user;

    private final String password;

    private UpdateLocationFsxWindowsRequest(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.subdirectory = builder.subdirectory;
        this.domain = builder.domain;
        this.user = builder.user;
        this.password = builder.password;
    }

    /**
     * <p>
     * Specifies the ARN of the FSx for Windows File Server transfer location that you're updating.
     * </p>
     * 
     * @return Specifies the ARN of the FSx for Windows File Server transfer location that you're updating.
     */
    public final String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * Specifies a mount path for your file system using forward slashes. DataSync uses this subdirectory to read or
     * write data (depending on whether the file system is a source or destination location).
     * </p>
     * 
     * @return Specifies a mount path for your file system using forward slashes. DataSync uses this subdirectory to
     *         read or write data (depending on whether the file system is a source or destination location).
     */
    public final String subdirectory() {
        return subdirectory;
    }

    /**
     * <p>
     * Specifies the name of the Windows domain that your FSx for Windows File Server file system belongs to.
     * </p>
     * <p>
     * If you have multiple Active Directory domains in your environment, configuring this parameter makes sure that
     * DataSync connects to the right file system.
     * </p>
     * 
     * @return Specifies the name of the Windows domain that your FSx for Windows File Server file system belongs
     *         to.</p>
     *         <p>
     *         If you have multiple Active Directory domains in your environment, configuring this parameter makes sure
     *         that DataSync connects to the right file system.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * Specifies the user with the permissions to mount and access the files, folders, and file metadata in your FSx for
     * Windows File Server file system.
     * </p>
     * <p>
     * For information about choosing a user with the right level of access for your transfer, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-windows-location-permissions"
     * >required permissions</a> for FSx for Windows File Server locations.
     * </p>
     * 
     * @return Specifies the user with the permissions to mount and access the files, folders, and file metadata in your
     *         FSx for Windows File Server file system.</p>
     *         <p>
     *         For information about choosing a user with the right level of access for your transfer, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-windows-location-permissions"
     *         >required permissions</a> for FSx for Windows File Server locations.
     */
    public final String user() {
        return user;
    }

    /**
     * <p>
     * Specifies the password of the user with the permissions to mount and access the files, folders, and file metadata
     * in your FSx for Windows File Server file system.
     * </p>
     * 
     * @return Specifies the password of the user with the permissions to mount and access the files, folders, and file
     *         metadata in your FSx for Windows File Server file system.
     */
    public final String password() {
        return password;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLocationFsxWindowsRequest)) {
            return false;
        }
        UpdateLocationFsxWindowsRequest other = (UpdateLocationFsxWindowsRequest) obj;
        return Objects.equals(locationArn(), other.locationArn()) && Objects.equals(subdirectory(), other.subdirectory())
                && Objects.equals(domain(), other.domain()) && Objects.equals(user(), other.user())
                && Objects.equals(password(), other.password());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLocationFsxWindowsRequest").add("LocationArn", locationArn())
                .add("Subdirectory", subdirectory()).add("Domain", domain()).add("User", user())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "Subdirectory":
            return Optional.ofNullable(clazz.cast(subdirectory()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LocationArn", LOCATION_ARN_FIELD);
        map.put("Subdirectory", SUBDIRECTORY_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("User", USER_FIELD);
        map.put("Password", PASSWORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLocationFsxWindowsRequest, T> g) {
        return obj -> g.apply((UpdateLocationFsxWindowsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLocationFsxWindowsRequest> {
        /**
         * <p>
         * Specifies the ARN of the FSx for Windows File Server transfer location that you're updating.
         * </p>
         * 
         * @param locationArn
         *        Specifies the ARN of the FSx for Windows File Server transfer location that you're updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * Specifies a mount path for your file system using forward slashes. DataSync uses this subdirectory to read or
         * write data (depending on whether the file system is a source or destination location).
         * </p>
         * 
         * @param subdirectory
         *        Specifies a mount path for your file system using forward slashes. DataSync uses this subdirectory to
         *        read or write data (depending on whether the file system is a source or destination location).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdirectory(String subdirectory);

        /**
         * <p>
         * Specifies the name of the Windows domain that your FSx for Windows File Server file system belongs to.
         * </p>
         * <p>
         * If you have multiple Active Directory domains in your environment, configuring this parameter makes sure that
         * DataSync connects to the right file system.
         * </p>
         * 
         * @param domain
         *        Specifies the name of the Windows domain that your FSx for Windows File Server file system belongs
         *        to.</p>
         *        <p>
         *        If you have multiple Active Directory domains in your environment, configuring this parameter makes
         *        sure that DataSync connects to the right file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * Specifies the user with the permissions to mount and access the files, folders, and file metadata in your FSx
         * for Windows File Server file system.
         * </p>
         * <p>
         * For information about choosing a user with the right level of access for your transfer, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-windows-location-permissions"
         * >required permissions</a> for FSx for Windows File Server locations.
         * </p>
         * 
         * @param user
         *        Specifies the user with the permissions to mount and access the files, folders, and file metadata in
         *        your FSx for Windows File Server file system.</p>
         *        <p>
         *        For information about choosing a user with the right level of access for your transfer, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-windows-location-permissions"
         *        >required permissions</a> for FSx for Windows File Server locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(String user);

        /**
         * <p>
         * Specifies the password of the user with the permissions to mount and access the files, folders, and file
         * metadata in your FSx for Windows File Server file system.
         * </p>
         * 
         * @param password
         *        Specifies the password of the user with the permissions to mount and access the files, folders, and
         *        file metadata in your FSx for Windows File Server file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String locationArn;

        private String subdirectory;

        private String domain;

        private String user;

        private String password;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLocationFsxWindowsRequest model) {
            super(model);
            locationArn(model.locationArn);
            subdirectory(model.subdirectory);
            domain(model.domain);
            user(model.user);
            password(model.password);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getSubdirectory() {
            return subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getUser() {
            return user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLocationFsxWindowsRequest build() {
            return new UpdateLocationFsxWindowsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
