/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CreateLocationEfsRequest
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLocationEfsRequest extends DataSyncRequest implements
        ToCopyableBuilder<CreateLocationEfsRequest.Builder, CreateLocationEfsRequest> {
    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Subdirectory").getter(getter(CreateLocationEfsRequest::subdirectory))
            .setter(setter(Builder::subdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()).build();

    private static final SdkField<String> EFS_FILESYSTEM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EfsFilesystemArn").getter(getter(CreateLocationEfsRequest::efsFilesystemArn))
            .setter(setter(Builder::efsFilesystemArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EfsFilesystemArn").build()).build();

    private static final SdkField<Ec2Config> EC2_CONFIG_FIELD = SdkField.<Ec2Config> builder(MarshallingType.SDK_POJO)
            .memberName("Ec2Config").getter(getter(CreateLocationEfsRequest::ec2Config)).setter(setter(Builder::ec2Config))
            .constructor(Ec2Config::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2Config").build()).build();

    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField
            .<List<TagListEntry>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateLocationEfsRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ACCESS_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessPointArn").getter(getter(CreateLocationEfsRequest::accessPointArn))
            .setter(setter(Builder::accessPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointArn").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemAccessRoleArn").getter(getter(CreateLocationEfsRequest::fileSystemAccessRoleArn))
            .setter(setter(Builder::fileSystemAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAccessRoleArn").build())
            .build();

    private static final SdkField<String> IN_TRANSIT_ENCRYPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InTransitEncryption").getter(getter(CreateLocationEfsRequest::inTransitEncryptionAsString))
            .setter(setter(Builder::inTransitEncryption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InTransitEncryption").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBDIRECTORY_FIELD,
            EFS_FILESYSTEM_ARN_FIELD, EC2_CONFIG_FIELD, TAGS_FIELD, ACCESS_POINT_ARN_FIELD, FILE_SYSTEM_ACCESS_ROLE_ARN_FIELD,
            IN_TRANSIT_ENCRYPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String subdirectory;

    private final String efsFilesystemArn;

    private final Ec2Config ec2Config;

    private final List<TagListEntry> tags;

    private final String accessPointArn;

    private final String fileSystemAccessRoleArn;

    private final String inTransitEncryption;

    private CreateLocationEfsRequest(BuilderImpl builder) {
        super(builder);
        this.subdirectory = builder.subdirectory;
        this.efsFilesystemArn = builder.efsFilesystemArn;
        this.ec2Config = builder.ec2Config;
        this.tags = builder.tags;
        this.accessPointArn = builder.accessPointArn;
        this.fileSystemAccessRoleArn = builder.fileSystemAccessRoleArn;
        this.inTransitEncryption = builder.inTransitEncryption;
    }

    /**
     * <p>
     * Specifies a mount path for your Amazon EFS file system. This is where DataSync reads or writes data on your file
     * system (depending on if this is a source or destination location).
     * </p>
     * <p>
     * By default, DataSync uses the root directory (or <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">access point</a> if you provide one by
     * using <code>AccessPointArn</code>). You can also include subdirectories using forward slashes (for example,
     * <code>/path/to/folder</code>).
     * </p>
     * 
     * @return Specifies a mount path for your Amazon EFS file system. This is where DataSync reads or writes data on
     *         your file system (depending on if this is a source or destination location).</p>
     *         <p>
     *         By default, DataSync uses the root directory (or <a
     *         href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">access point</a> if you provide
     *         one by using <code>AccessPointArn</code>). You can also include subdirectories using forward slashes (for
     *         example, <code>/path/to/folder</code>).
     */
    public final String subdirectory() {
        return subdirectory;
    }

    /**
     * <p>
     * Specifies the ARN for your Amazon EFS file system.
     * </p>
     * 
     * @return Specifies the ARN for your Amazon EFS file system.
     */
    public final String efsFilesystemArn() {
        return efsFilesystemArn;
    }

    /**
     * <p>
     * Specifies the subnet and security groups DataSync uses to connect to one of your Amazon EFS file system's <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/accessing-fs.html">mount targets</a>.
     * </p>
     * 
     * @return Specifies the subnet and security groups DataSync uses to connect to one of your Amazon EFS file system's
     *         <a href="https://docs.aws.amazon.com/efs/latest/ug/accessing-fs.html">mount targets</a>.
     */
    public final Ec2Config ec2Config() {
        return ec2Config;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the key-value pair that represents a tag that you want to add to the resource. The value can be an
     * empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a
     * name tag for your location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Specifies the key-value pair that represents a tag that you want to add to the resource. The value can be
     *         an empty string. This value helps you manage, filter, and search for your resources. We recommend that
     *         you create a name tag for your location.
     */
    public final List<TagListEntry> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to mount your Amazon EFS file
     * system.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-iam"
     * >Accessing restricted file systems</a>.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to mount your Amazon EFS
     *         file system.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-iam"
     *         >Accessing restricted file systems</a>.
     */
    public final String accessPointArn() {
        return accessPointArn;
    }

    /**
     * <p>
     * Specifies an Identity and Access Management (IAM) role that allows DataSync to access your Amazon EFS file
     * system.
     * </p>
     * <p>
     * For information on creating this role, see <a href=
     * "https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-iam-role"
     * >Creating a DataSync IAM role for file system access</a>.
     * </p>
     * 
     * @return Specifies an Identity and Access Management (IAM) role that allows DataSync to access your Amazon EFS
     *         file system.</p>
     *         <p>
     *         For information on creating this role, see <a href=
     *         "https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-iam-role"
     *         >Creating a DataSync IAM role for file system access</a>.
     */
    public final String fileSystemAccessRoleArn() {
        return fileSystemAccessRoleArn;
    }

    /**
     * <p>
     * Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it transfers data
     * to or from your Amazon EFS file system.
     * </p>
     * <p>
     * If you specify an access point using <code>AccessPointArn</code> or an IAM role using
     * <code>FileSystemAccessRoleArn</code>, you must set this parameter to <code>TLS1_2</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inTransitEncryption} will return {@link EfsInTransitEncryption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inTransitEncryptionAsString}.
     * </p>
     * 
     * @return Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it
     *         transfers data to or from your Amazon EFS file system.</p>
     *         <p>
     *         If you specify an access point using <code>AccessPointArn</code> or an IAM role using
     *         <code>FileSystemAccessRoleArn</code>, you must set this parameter to <code>TLS1_2</code>.
     * @see EfsInTransitEncryption
     */
    public final EfsInTransitEncryption inTransitEncryption() {
        return EfsInTransitEncryption.fromValue(inTransitEncryption);
    }

    /**
     * <p>
     * Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it transfers data
     * to or from your Amazon EFS file system.
     * </p>
     * <p>
     * If you specify an access point using <code>AccessPointArn</code> or an IAM role using
     * <code>FileSystemAccessRoleArn</code>, you must set this parameter to <code>TLS1_2</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inTransitEncryption} will return {@link EfsInTransitEncryption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inTransitEncryptionAsString}.
     * </p>
     * 
     * @return Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it
     *         transfers data to or from your Amazon EFS file system.</p>
     *         <p>
     *         If you specify an access point using <code>AccessPointArn</code> or an IAM role using
     *         <code>FileSystemAccessRoleArn</code>, you must set this parameter to <code>TLS1_2</code>.
     * @see EfsInTransitEncryption
     */
    public final String inTransitEncryptionAsString() {
        return inTransitEncryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(efsFilesystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(ec2Config());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(accessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(inTransitEncryptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationEfsRequest)) {
            return false;
        }
        CreateLocationEfsRequest other = (CreateLocationEfsRequest) obj;
        return Objects.equals(subdirectory(), other.subdirectory())
                && Objects.equals(efsFilesystemArn(), other.efsFilesystemArn()) && Objects.equals(ec2Config(), other.ec2Config())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(accessPointArn(), other.accessPointArn())
                && Objects.equals(fileSystemAccessRoleArn(), other.fileSystemAccessRoleArn())
                && Objects.equals(inTransitEncryptionAsString(), other.inTransitEncryptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLocationEfsRequest").add("Subdirectory", subdirectory())
                .add("EfsFilesystemArn", efsFilesystemArn()).add("Ec2Config", ec2Config()).add("Tags", hasTags() ? tags() : null)
                .add("AccessPointArn", accessPointArn()).add("FileSystemAccessRoleArn", fileSystemAccessRoleArn())
                .add("InTransitEncryption", inTransitEncryptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subdirectory":
            return Optional.ofNullable(clazz.cast(subdirectory()));
        case "EfsFilesystemArn":
            return Optional.ofNullable(clazz.cast(efsFilesystemArn()));
        case "Ec2Config":
            return Optional.ofNullable(clazz.cast(ec2Config()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "AccessPointArn":
            return Optional.ofNullable(clazz.cast(accessPointArn()));
        case "FileSystemAccessRoleArn":
            return Optional.ofNullable(clazz.cast(fileSystemAccessRoleArn()));
        case "InTransitEncryption":
            return Optional.ofNullable(clazz.cast(inTransitEncryptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Subdirectory", SUBDIRECTORY_FIELD);
        map.put("EfsFilesystemArn", EFS_FILESYSTEM_ARN_FIELD);
        map.put("Ec2Config", EC2_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("AccessPointArn", ACCESS_POINT_ARN_FIELD);
        map.put("FileSystemAccessRoleArn", FILE_SYSTEM_ACCESS_ROLE_ARN_FIELD);
        map.put("InTransitEncryption", IN_TRANSIT_ENCRYPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLocationEfsRequest, T> g) {
        return obj -> g.apply((CreateLocationEfsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLocationEfsRequest> {
        /**
         * <p>
         * Specifies a mount path for your Amazon EFS file system. This is where DataSync reads or writes data on your
         * file system (depending on if this is a source or destination location).
         * </p>
         * <p>
         * By default, DataSync uses the root directory (or <a
         * href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">access point</a> if you provide one
         * by using <code>AccessPointArn</code>). You can also include subdirectories using forward slashes (for
         * example, <code>/path/to/folder</code>).
         * </p>
         * 
         * @param subdirectory
         *        Specifies a mount path for your Amazon EFS file system. This is where DataSync reads or writes data on
         *        your file system (depending on if this is a source or destination location).</p>
         *        <p>
         *        By default, DataSync uses the root directory (or <a
         *        href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">access point</a> if you
         *        provide one by using <code>AccessPointArn</code>). You can also include subdirectories using forward
         *        slashes (for example, <code>/path/to/folder</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdirectory(String subdirectory);

        /**
         * <p>
         * Specifies the ARN for your Amazon EFS file system.
         * </p>
         * 
         * @param efsFilesystemArn
         *        Specifies the ARN for your Amazon EFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder efsFilesystemArn(String efsFilesystemArn);

        /**
         * <p>
         * Specifies the subnet and security groups DataSync uses to connect to one of your Amazon EFS file system's <a
         * href="https://docs.aws.amazon.com/efs/latest/ug/accessing-fs.html">mount targets</a>.
         * </p>
         * 
         * @param ec2Config
         *        Specifies the subnet and security groups DataSync uses to connect to one of your Amazon EFS file
         *        system's <a href="https://docs.aws.amazon.com/efs/latest/ug/accessing-fs.html">mount targets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2Config(Ec2Config ec2Config);

        /**
         * <p>
         * Specifies the subnet and security groups DataSync uses to connect to one of your Amazon EFS file system's <a
         * href="https://docs.aws.amazon.com/efs/latest/ug/accessing-fs.html">mount targets</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ec2Config.Builder} avoiding the need to
         * create one manually via {@link Ec2Config#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ec2Config.Builder#build()} is called immediately and its result
         * is passed to {@link #ec2Config(Ec2Config)}.
         * 
         * @param ec2Config
         *        a consumer that will call methods on {@link Ec2Config.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2Config(Ec2Config)
         */
        default Builder ec2Config(Consumer<Ec2Config.Builder> ec2Config) {
            return ec2Config(Ec2Config.builder().applyMutation(ec2Config).build());
        }

        /**
         * <p>
         * Specifies the key-value pair that represents a tag that you want to add to the resource. The value can be an
         * empty string. This value helps you manage, filter, and search for your resources. We recommend that you
         * create a name tag for your location.
         * </p>
         * 
         * @param tags
         *        Specifies the key-value pair that represents a tag that you want to add to the resource. The value can
         *        be an empty string. This value helps you manage, filter, and search for your resources. We recommend
         *        that you create a name tag for your location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagListEntry> tags);

        /**
         * <p>
         * Specifies the key-value pair that represents a tag that you want to add to the resource. The value can be an
         * empty string. This value helps you manage, filter, and search for your resources. We recommend that you
         * create a name tag for your location.
         * </p>
         * 
         * @param tags
         *        Specifies the key-value pair that represents a tag that you want to add to the resource. The value can
         *        be an empty string. This value helps you manage, filter, and search for your resources. We recommend
         *        that you create a name tag for your location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagListEntry... tags);

        /**
         * <p>
         * Specifies the key-value pair that represents a tag that you want to add to the resource. The value can be an
         * empty string. This value helps you manage, filter, and search for your resources. We recommend that you
         * create a name tag for your location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datasync.model.TagListEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<TagListEntry>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<TagListEntry>)
         */
        Builder tags(Consumer<TagListEntry.Builder>... tags);

        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to mount your Amazon EFS file
         * system.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-iam"
         * >Accessing restricted file systems</a>.
         * </p>
         * 
         * @param accessPointArn
         *        Specifies the Amazon Resource Name (ARN) of the access point that DataSync uses to mount your Amazon
         *        EFS file system.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-iam"
         *        >Accessing restricted file systems</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointArn(String accessPointArn);

        /**
         * <p>
         * Specifies an Identity and Access Management (IAM) role that allows DataSync to access your Amazon EFS file
         * system.
         * </p>
         * <p>
         * For information on creating this role, see <a href=
         * "https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-iam-role"
         * >Creating a DataSync IAM role for file system access</a>.
         * </p>
         * 
         * @param fileSystemAccessRoleArn
         *        Specifies an Identity and Access Management (IAM) role that allows DataSync to access your Amazon EFS
         *        file system.</p>
         *        <p>
         *        For information on creating this role, see <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/create-efs-location.html#create-efs-location-iam-role"
         *        >Creating a DataSync IAM role for file system access</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemAccessRoleArn(String fileSystemAccessRoleArn);

        /**
         * <p>
         * Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it transfers
         * data to or from your Amazon EFS file system.
         * </p>
         * <p>
         * If you specify an access point using <code>AccessPointArn</code> or an IAM role using
         * <code>FileSystemAccessRoleArn</code>, you must set this parameter to <code>TLS1_2</code>.
         * </p>
         * 
         * @param inTransitEncryption
         *        Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it
         *        transfers data to or from your Amazon EFS file system.</p>
         *        <p>
         *        If you specify an access point using <code>AccessPointArn</code> or an IAM role using
         *        <code>FileSystemAccessRoleArn</code>, you must set this parameter to <code>TLS1_2</code>.
         * @see EfsInTransitEncryption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EfsInTransitEncryption
         */
        Builder inTransitEncryption(String inTransitEncryption);

        /**
         * <p>
         * Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it transfers
         * data to or from your Amazon EFS file system.
         * </p>
         * <p>
         * If you specify an access point using <code>AccessPointArn</code> or an IAM role using
         * <code>FileSystemAccessRoleArn</code>, you must set this parameter to <code>TLS1_2</code>.
         * </p>
         * 
         * @param inTransitEncryption
         *        Specifies whether you want DataSync to use Transport Layer Security (TLS) 1.2 encryption when it
         *        transfers data to or from your Amazon EFS file system.</p>
         *        <p>
         *        If you specify an access point using <code>AccessPointArn</code> or an IAM role using
         *        <code>FileSystemAccessRoleArn</code>, you must set this parameter to <code>TLS1_2</code>.
         * @see EfsInTransitEncryption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EfsInTransitEncryption
         */
        Builder inTransitEncryption(EfsInTransitEncryption inTransitEncryption);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String subdirectory;

        private String efsFilesystemArn;

        private Ec2Config ec2Config;

        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private String accessPointArn;

        private String fileSystemAccessRoleArn;

        private String inTransitEncryption;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocationEfsRequest model) {
            super(model);
            subdirectory(model.subdirectory);
            efsFilesystemArn(model.efsFilesystemArn);
            ec2Config(model.ec2Config);
            tags(model.tags);
            accessPointArn(model.accessPointArn);
            fileSystemAccessRoleArn(model.fileSystemAccessRoleArn);
            inTransitEncryption(model.inTransitEncryption);
        }

        public final String getSubdirectory() {
            return subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final String getEfsFilesystemArn() {
            return efsFilesystemArn;
        }

        public final void setEfsFilesystemArn(String efsFilesystemArn) {
            this.efsFilesystemArn = efsFilesystemArn;
        }

        @Override
        public final Builder efsFilesystemArn(String efsFilesystemArn) {
            this.efsFilesystemArn = efsFilesystemArn;
            return this;
        }

        public final Ec2Config.Builder getEc2Config() {
            return ec2Config != null ? ec2Config.toBuilder() : null;
        }

        public final void setEc2Config(Ec2Config.BuilderImpl ec2Config) {
            this.ec2Config = ec2Config != null ? ec2Config.build() : null;
        }

        @Override
        public final Builder ec2Config(Ec2Config ec2Config) {
            this.ec2Config = ec2Config;
            return this;
        }

        public final List<TagListEntry.Builder> getTags() {
            List<TagListEntry.Builder> result = InputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagListEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAccessPointArn() {
            return accessPointArn;
        }

        public final void setAccessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
        }

        @Override
        public final Builder accessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
            return this;
        }

        public final String getFileSystemAccessRoleArn() {
            return fileSystemAccessRoleArn;
        }

        public final void setFileSystemAccessRoleArn(String fileSystemAccessRoleArn) {
            this.fileSystemAccessRoleArn = fileSystemAccessRoleArn;
        }

        @Override
        public final Builder fileSystemAccessRoleArn(String fileSystemAccessRoleArn) {
            this.fileSystemAccessRoleArn = fileSystemAccessRoleArn;
            return this;
        }

        public final String getInTransitEncryption() {
            return inTransitEncryption;
        }

        public final void setInTransitEncryption(String inTransitEncryption) {
            this.inTransitEncryption = inTransitEncryption;
        }

        @Override
        public final Builder inTransitEncryption(String inTransitEncryption) {
            this.inTransitEncryption = inTransitEncryption;
            return this;
        }

        @Override
        public final Builder inTransitEncryption(EfsInTransitEncryption inTransitEncryption) {
            this.inTransitEncryption(inTransitEncryption == null ? null : inTransitEncryption.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLocationEfsRequest build() {
            return new CreateLocationEfsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
