/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.ObjectVersionIds;
import software.amazon.awssdk.services.datasync.model.ReportDestination;
import software.amazon.awssdk.services.datasync.model.ReportLevel;
import software.amazon.awssdk.services.datasync.model.ReportOutputType;
import software.amazon.awssdk.services.datasync.model.ReportOverrides;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskReportConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskReportConfig> {
    private static final SdkField<ReportDestination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(TaskReportConfig.getter(TaskReportConfig::destination)).setter(TaskReportConfig.setter(Builder::destination)).constructor(ReportDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<String> OUTPUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputType").getter(TaskReportConfig.getter(TaskReportConfig::outputTypeAsString)).setter(TaskReportConfig.setter(Builder::outputType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputType").build()}).build();
    private static final SdkField<String> REPORT_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportLevel").getter(TaskReportConfig.getter(TaskReportConfig::reportLevelAsString)).setter(TaskReportConfig.setter(Builder::reportLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportLevel").build()}).build();
    private static final SdkField<String> OBJECT_VERSION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectVersionIds").getter(TaskReportConfig.getter(TaskReportConfig::objectVersionIdsAsString)).setter(TaskReportConfig.setter(Builder::objectVersionIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectVersionIds").build()}).build();
    private static final SdkField<ReportOverrides> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Overrides").getter(TaskReportConfig.getter(TaskReportConfig::overrides)).setter(TaskReportConfig.setter(Builder::overrides)).constructor(ReportOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overrides").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD, OUTPUT_TYPE_FIELD, REPORT_LEVEL_FIELD, OBJECT_VERSION_IDS_FIELD, OVERRIDES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TaskReportConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ReportDestination destination;
    private final String outputType;
    private final String reportLevel;
    private final String objectVersionIds;
    private final ReportOverrides overrides;

    private TaskReportConfig(BuilderImpl builder) {
        this.destination = builder.destination;
        this.outputType = builder.outputType;
        this.reportLevel = builder.reportLevel;
        this.objectVersionIds = builder.objectVersionIds;
        this.overrides = builder.overrides;
    }

    public final ReportDestination destination() {
        return this.destination;
    }

    public final ReportOutputType outputType() {
        return ReportOutputType.fromValue(this.outputType);
    }

    public final String outputTypeAsString() {
        return this.outputType;
    }

    public final ReportLevel reportLevel() {
        return ReportLevel.fromValue(this.reportLevel);
    }

    public final String reportLevelAsString() {
        return this.reportLevel;
    }

    public final ObjectVersionIds objectVersionIds() {
        return ObjectVersionIds.fromValue(this.objectVersionIds);
    }

    public final String objectVersionIdsAsString() {
        return this.objectVersionIds;
    }

    public final ReportOverrides overrides() {
        return this.overrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectVersionIdsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrides());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskReportConfig)) {
            return false;
        }
        TaskReportConfig other = (TaskReportConfig)obj;
        return Objects.equals(this.destination(), other.destination()) && Objects.equals(this.outputTypeAsString(), other.outputTypeAsString()) && Objects.equals(this.reportLevelAsString(), other.reportLevelAsString()) && Objects.equals(this.objectVersionIdsAsString(), other.objectVersionIdsAsString()) && Objects.equals(this.overrides(), other.overrides());
    }

    public final String toString() {
        return ToString.builder((String)"TaskReportConfig").add("Destination", (Object)this.destination()).add("OutputType", (Object)this.outputTypeAsString()).add("ReportLevel", (Object)this.reportLevelAsString()).add("ObjectVersionIds", (Object)this.objectVersionIdsAsString()).add("Overrides", (Object)this.overrides()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "OutputType": {
                return Optional.ofNullable(clazz.cast(this.outputTypeAsString()));
            }
            case "ReportLevel": {
                return Optional.ofNullable(clazz.cast(this.reportLevelAsString()));
            }
            case "ObjectVersionIds": {
                return Optional.ofNullable(clazz.cast(this.objectVersionIdsAsString()));
            }
            case "Overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Destination", DESTINATION_FIELD);
        map.put("OutputType", OUTPUT_TYPE_FIELD);
        map.put("ReportLevel", REPORT_LEVEL_FIELD);
        map.put("ObjectVersionIds", OBJECT_VERSION_IDS_FIELD);
        map.put("Overrides", OVERRIDES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskReportConfig, T> g) {
        return obj -> g.apply((TaskReportConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ReportDestination destination;
        private String outputType;
        private String reportLevel;
        private String objectVersionIds;
        private ReportOverrides overrides;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskReportConfig model) {
            this.destination(model.destination);
            this.outputType(model.outputType);
            this.reportLevel(model.reportLevel);
            this.objectVersionIds(model.objectVersionIds);
            this.overrides(model.overrides);
        }

        public final ReportDestination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(ReportDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(ReportDestination destination) {
            this.destination = destination;
            return this;
        }

        public final String getOutputType() {
            return this.outputType;
        }

        public final void setOutputType(String outputType) {
            this.outputType = outputType;
        }

        @Override
        public final Builder outputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        @Override
        public final Builder outputType(ReportOutputType outputType) {
            this.outputType(outputType == null ? null : outputType.toString());
            return this;
        }

        public final String getReportLevel() {
            return this.reportLevel;
        }

        public final void setReportLevel(String reportLevel) {
            this.reportLevel = reportLevel;
        }

        @Override
        public final Builder reportLevel(String reportLevel) {
            this.reportLevel = reportLevel;
            return this;
        }

        @Override
        public final Builder reportLevel(ReportLevel reportLevel) {
            this.reportLevel(reportLevel == null ? null : reportLevel.toString());
            return this;
        }

        public final String getObjectVersionIds() {
            return this.objectVersionIds;
        }

        public final void setObjectVersionIds(String objectVersionIds) {
            this.objectVersionIds = objectVersionIds;
        }

        @Override
        public final Builder objectVersionIds(String objectVersionIds) {
            this.objectVersionIds = objectVersionIds;
            return this;
        }

        @Override
        public final Builder objectVersionIds(ObjectVersionIds objectVersionIds) {
            this.objectVersionIds(objectVersionIds == null ? null : objectVersionIds.toString());
            return this;
        }

        public final ReportOverrides.Builder getOverrides() {
            return this.overrides != null ? this.overrides.toBuilder() : null;
        }

        public final void setOverrides(ReportOverrides.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        @Override
        public final Builder overrides(ReportOverrides overrides) {
            this.overrides = overrides;
            return this;
        }

        public TaskReportConfig build() {
            return new TaskReportConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskReportConfig> {
        public Builder destination(ReportDestination var1);

        default public Builder destination(Consumer<ReportDestination.Builder> destination) {
            return this.destination((ReportDestination)((ReportDestination.Builder)ReportDestination.builder().applyMutation(destination)).build());
        }

        public Builder outputType(String var1);

        public Builder outputType(ReportOutputType var1);

        public Builder reportLevel(String var1);

        public Builder reportLevel(ReportLevel var1);

        public Builder objectVersionIds(String var1);

        public Builder objectVersionIds(ObjectVersionIds var1);

        public Builder overrides(ReportOverrides var1);

        default public Builder overrides(Consumer<ReportOverrides.Builder> overrides) {
            return this.overrides((ReportOverrides)((ReportOverrides.Builder)ReportOverrides.builder().applyMutation(overrides)).build());
        }
    }
}

