/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.FsxProtocolNfs;
import software.amazon.awssdk.services.datasync.model.FsxUpdateProtocolSmb;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FsxUpdateProtocol
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FsxUpdateProtocol> {
    private static final SdkField<FsxProtocolNfs> NFS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NFS").getter(FsxUpdateProtocol.getter(FsxUpdateProtocol::nfs)).setter(FsxUpdateProtocol.setter(Builder::nfs)).constructor(FsxProtocolNfs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NFS").build()}).build();
    private static final SdkField<FsxUpdateProtocolSmb> SMB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SMB").getter(FsxUpdateProtocol.getter(FsxUpdateProtocol::smb)).setter(FsxUpdateProtocol.setter(Builder::smb)).constructor(FsxUpdateProtocolSmb::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMB").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NFS_FIELD, SMB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FsxUpdateProtocol.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final FsxProtocolNfs nfs;
    private final FsxUpdateProtocolSmb smb;

    private FsxUpdateProtocol(BuilderImpl builder) {
        this.nfs = builder.nfs;
        this.smb = builder.smb;
    }

    public final FsxProtocolNfs nfs() {
        return this.nfs;
    }

    public final FsxUpdateProtocolSmb smb() {
        return this.smb;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nfs());
        hashCode = 31 * hashCode + Objects.hashCode(this.smb());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FsxUpdateProtocol)) {
            return false;
        }
        FsxUpdateProtocol other = (FsxUpdateProtocol)obj;
        return Objects.equals(this.nfs(), other.nfs()) && Objects.equals(this.smb(), other.smb());
    }

    public final String toString() {
        return ToString.builder((String)"FsxUpdateProtocol").add("NFS", (Object)this.nfs()).add("SMB", (Object)this.smb()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NFS": {
                return Optional.ofNullable(clazz.cast(this.nfs()));
            }
            case "SMB": {
                return Optional.ofNullable(clazz.cast(this.smb()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NFS", NFS_FIELD);
        map.put("SMB", SMB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FsxUpdateProtocol, T> g) {
        return obj -> g.apply((FsxUpdateProtocol)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FsxProtocolNfs nfs;
        private FsxUpdateProtocolSmb smb;

        private BuilderImpl() {
        }

        private BuilderImpl(FsxUpdateProtocol model) {
            this.nfs(model.nfs);
            this.smb(model.smb);
        }

        public final FsxProtocolNfs.Builder getNfs() {
            return this.nfs != null ? this.nfs.toBuilder() : null;
        }

        public final void setNfs(FsxProtocolNfs.BuilderImpl nfs) {
            this.nfs = nfs != null ? nfs.build() : null;
        }

        @Override
        public final Builder nfs(FsxProtocolNfs nfs) {
            this.nfs = nfs;
            return this;
        }

        public final FsxUpdateProtocolSmb.Builder getSmb() {
            return this.smb != null ? this.smb.toBuilder() : null;
        }

        public final void setSmb(FsxUpdateProtocolSmb.BuilderImpl smb) {
            this.smb = smb != null ? smb.build() : null;
        }

        @Override
        public final Builder smb(FsxUpdateProtocolSmb smb) {
            this.smb = smb;
            return this;
        }

        public FsxUpdateProtocol build() {
            return new FsxUpdateProtocol(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FsxUpdateProtocol> {
        public Builder nfs(FsxProtocolNfs var1);

        default public Builder nfs(Consumer<FsxProtocolNfs.Builder> nfs) {
            return this.nfs((FsxProtocolNfs)((FsxProtocolNfs.Builder)FsxProtocolNfs.builder().applyMutation(nfs)).build());
        }

        public Builder smb(FsxUpdateProtocolSmb var1);

        default public Builder smb(Consumer<FsxUpdateProtocolSmb.Builder> smb) {
            return this.smb((FsxUpdateProtocolSmb)((FsxUpdateProtocolSmb.Builder)FsxUpdateProtocolSmb.builder().applyMutation(smb)).build());
        }
    }
}

