/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.NfsMountOptions;
import software.amazon.awssdk.services.datasync.model.OnPremConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLocationNfsResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, DescribeLocationNfsResponse> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationArn").getter(DescribeLocationNfsResponse.getter(DescribeLocationNfsResponse::locationArn)).setter(DescribeLocationNfsResponse.setter(Builder::locationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()}).build();
    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationUri").getter(DescribeLocationNfsResponse.getter(DescribeLocationNfsResponse::locationUri)).setter(DescribeLocationNfsResponse.setter(Builder::locationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()}).build();
    private static final SdkField<OnPremConfig> ON_PREM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnPremConfig").getter(DescribeLocationNfsResponse.getter(DescribeLocationNfsResponse::onPremConfig)).setter(DescribeLocationNfsResponse.setter(Builder::onPremConfig)).constructor(OnPremConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnPremConfig").build()}).build();
    private static final SdkField<NfsMountOptions> MOUNT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MountOptions").getter(DescribeLocationNfsResponse.getter(DescribeLocationNfsResponse::mountOptions)).setter(DescribeLocationNfsResponse.setter(Builder::mountOptions)).constructor(NfsMountOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountOptions").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeLocationNfsResponse.getter(DescribeLocationNfsResponse::creationTime)).setter(DescribeLocationNfsResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD, LOCATION_URI_FIELD, ON_PREM_CONFIG_FIELD, MOUNT_OPTIONS_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeLocationNfsResponse.memberNameToFieldInitializer();
    private final String locationArn;
    private final String locationUri;
    private final OnPremConfig onPremConfig;
    private final NfsMountOptions mountOptions;
    private final Instant creationTime;

    private DescribeLocationNfsResponse(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
        this.onPremConfig = builder.onPremConfig;
        this.mountOptions = builder.mountOptions;
        this.creationTime = builder.creationTime;
    }

    public final String locationArn() {
        return this.locationArn;
    }

    public final String locationUri() {
        return this.locationUri;
    }

    public final OnPremConfig onPremConfig() {
        return this.onPremConfig;
    }

    public final NfsMountOptions mountOptions() {
        return this.mountOptions;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.onPremConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationNfsResponse)) {
            return false;
        }
        DescribeLocationNfsResponse other = (DescribeLocationNfsResponse)((Object)obj);
        return Objects.equals(this.locationArn(), other.locationArn()) && Objects.equals(this.locationUri(), other.locationUri()) && Objects.equals(this.onPremConfig(), other.onPremConfig()) && Objects.equals(this.mountOptions(), other.mountOptions()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLocationNfsResponse").add("LocationArn", (Object)this.locationArn()).add("LocationUri", (Object)this.locationUri()).add("OnPremConfig", (Object)this.onPremConfig()).add("MountOptions", (Object)this.mountOptions()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocationArn": {
                return Optional.ofNullable(clazz.cast(this.locationArn()));
            }
            case "LocationUri": {
                return Optional.ofNullable(clazz.cast(this.locationUri()));
            }
            case "OnPremConfig": {
                return Optional.ofNullable(clazz.cast(this.onPremConfig()));
            }
            case "MountOptions": {
                return Optional.ofNullable(clazz.cast(this.mountOptions()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LocationArn", LOCATION_ARN_FIELD);
        map.put("LocationUri", LOCATION_URI_FIELD);
        map.put("OnPremConfig", ON_PREM_CONFIG_FIELD);
        map.put("MountOptions", MOUNT_OPTIONS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationNfsResponse, T> g) {
        return obj -> g.apply((DescribeLocationNfsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private String locationArn;
        private String locationUri;
        private OnPremConfig onPremConfig;
        private NfsMountOptions mountOptions;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationNfsResponse model) {
            super(model);
            this.locationArn(model.locationArn);
            this.locationUri(model.locationUri);
            this.onPremConfig(model.onPremConfig);
            this.mountOptions(model.mountOptions);
            this.creationTime(model.creationTime);
        }

        public final String getLocationArn() {
            return this.locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getLocationUri() {
            return this.locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final OnPremConfig.Builder getOnPremConfig() {
            return this.onPremConfig != null ? this.onPremConfig.toBuilder() : null;
        }

        public final void setOnPremConfig(OnPremConfig.BuilderImpl onPremConfig) {
            this.onPremConfig = onPremConfig != null ? onPremConfig.build() : null;
        }

        @Override
        public final Builder onPremConfig(OnPremConfig onPremConfig) {
            this.onPremConfig = onPremConfig;
            return this;
        }

        public final NfsMountOptions.Builder getMountOptions() {
            return this.mountOptions != null ? this.mountOptions.toBuilder() : null;
        }

        public final void setMountOptions(NfsMountOptions.BuilderImpl mountOptions) {
            this.mountOptions = mountOptions != null ? mountOptions.build() : null;
        }

        @Override
        public final Builder mountOptions(NfsMountOptions mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public DescribeLocationNfsResponse build() {
            return new DescribeLocationNfsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLocationNfsResponse> {
        public Builder locationArn(String var1);

        public Builder locationUri(String var1);

        public Builder onPremConfig(OnPremConfig var1);

        default public Builder onPremConfig(Consumer<OnPremConfig.Builder> onPremConfig) {
            return this.onPremConfig((OnPremConfig)((OnPremConfig.Builder)OnPremConfig.builder().applyMutation(onPremConfig)).build());
        }

        public Builder mountOptions(NfsMountOptions var1);

        default public Builder mountOptions(Consumer<NfsMountOptions.Builder> mountOptions) {
            return this.mountOptions((NfsMountOptions)((NfsMountOptions.Builder)NfsMountOptions.builder().applyMutation(mountOptions)).build());
        }

        public Builder creationTime(Instant var1);
    }
}

