/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.MaxP95Performance;
import software.amazon.awssdk.services.datasync.model.Recommendation;
import software.amazon.awssdk.services.datasync.model.RecommendationStatus;
import software.amazon.awssdk.services.datasync.model.RecommendationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetAppONTAPVolume
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetAppONTAPVolume> {
    private static final SdkField<String> VOLUME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeName").getter(NetAppONTAPVolume.getter(NetAppONTAPVolume::volumeName)).setter(NetAppONTAPVolume.setter(Builder::volumeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeName").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(NetAppONTAPVolume.getter(NetAppONTAPVolume::resourceId)).setter(NetAppONTAPVolume.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<Long> CIFS_SHARE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CifsShareCount").getter(NetAppONTAPVolume.getter(NetAppONTAPVolume::cifsShareCount)).setter(NetAppONTAPVolume.setter(Builder::cifsShareCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CifsShareCount").build()}).build();
    private static final SdkField<String> SECURITY_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityStyle").getter(NetAppONTAPVolume.getter(NetAppONTAPVolume::securityStyle)).setter(NetAppONTAPVolume.setter(Builder::securityStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityStyle").build()}).build();
    private static final SdkField<String> SVM_UUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SvmUuid").getter(NetAppONTAPVolume.getter(NetAppONTAPVolume::svmUuid)).setter(NetAppONTAPVolume.setter(Builder::svmUuid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SvmUuid").build()}).build();
    private static final SdkField<String> SVM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SvmName").getter(NetAppONTAPVolume.getter(NetAppONTAPVolume::svmName)).setter(NetAppONTAPVolume.setter(Builder::svmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SvmName").build()}).build();
    private static final SdkField<Long> CAPACITY_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CapacityUsed").getter(NetAppONTAPVolume.getter(NetAppONTAPVolume::capacityUsed)).setter(NetAppONTAPVolume.setter(Builder::capacityUsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityUsed").build()}).build();
    private static final SdkField<Long> CAPACITY_PROVISIONED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CapacityProvisioned").getter(NetAppONTAPVolume.getter(NetAppONTAPVolume::capacityProvisioned)).setter(NetAppONTAPVolume.setter(Builder::capacityProvisioned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProvisioned").build()}).build();
    private static final SdkField<Long> LOGICAL_CAPACITY_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LogicalCapacityUsed").getter(NetAppONTAPVolume.getter(NetAppONTAPVolume::logicalCapacityUsed)).setter(NetAppONTAPVolume.setter(Builder::logicalCapacityUsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalCapacityUsed").build()}).build();
    private static final SdkField<Boolean> NFS_EXPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NfsExported").getter(NetAppONTAPVolume.getter(NetAppONTAPVolume::nfsExported)).setter(NetAppONTAPVolume.setter(Builder::nfsExported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NfsExported").build()}).build();
    private static final SdkField<Long> SNAPSHOT_CAPACITY_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SnapshotCapacityUsed").getter(NetAppONTAPVolume.getter(NetAppONTAPVolume::snapshotCapacityUsed)).setter(NetAppONTAPVolume.setter(Builder::snapshotCapacityUsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCapacityUsed").build()}).build();
    private static final SdkField<MaxP95Performance> MAX_P95_PERFORMANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaxP95Performance").getter(NetAppONTAPVolume.getter(NetAppONTAPVolume::maxP95Performance)).setter(NetAppONTAPVolume.setter(Builder::maxP95Performance)).constructor(MaxP95Performance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxP95Performance").build()}).build();
    private static final SdkField<List<Recommendation>> RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Recommendations").getter(NetAppONTAPVolume.getter(NetAppONTAPVolume::recommendations)).setter(NetAppONTAPVolume.setter(Builder::recommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Recommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECOMMENDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationStatus").getter(NetAppONTAPVolume.getter(NetAppONTAPVolume::recommendationStatusAsString)).setter(NetAppONTAPVolume.setter(Builder::recommendationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationStatus").build()}).build();
    private static final SdkField<Long> LUN_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LunCount").getter(NetAppONTAPVolume.getter(NetAppONTAPVolume::lunCount)).setter(NetAppONTAPVolume.setter(Builder::lunCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LunCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_NAME_FIELD, RESOURCE_ID_FIELD, CIFS_SHARE_COUNT_FIELD, SECURITY_STYLE_FIELD, SVM_UUID_FIELD, SVM_NAME_FIELD, CAPACITY_USED_FIELD, CAPACITY_PROVISIONED_FIELD, LOGICAL_CAPACITY_USED_FIELD, NFS_EXPORTED_FIELD, SNAPSHOT_CAPACITY_USED_FIELD, MAX_P95_PERFORMANCE_FIELD, RECOMMENDATIONS_FIELD, RECOMMENDATION_STATUS_FIELD, LUN_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetAppONTAPVolume.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String volumeName;
    private final String resourceId;
    private final Long cifsShareCount;
    private final String securityStyle;
    private final String svmUuid;
    private final String svmName;
    private final Long capacityUsed;
    private final Long capacityProvisioned;
    private final Long logicalCapacityUsed;
    private final Boolean nfsExported;
    private final Long snapshotCapacityUsed;
    private final MaxP95Performance maxP95Performance;
    private final List<Recommendation> recommendations;
    private final String recommendationStatus;
    private final Long lunCount;

    private NetAppONTAPVolume(BuilderImpl builder) {
        this.volumeName = builder.volumeName;
        this.resourceId = builder.resourceId;
        this.cifsShareCount = builder.cifsShareCount;
        this.securityStyle = builder.securityStyle;
        this.svmUuid = builder.svmUuid;
        this.svmName = builder.svmName;
        this.capacityUsed = builder.capacityUsed;
        this.capacityProvisioned = builder.capacityProvisioned;
        this.logicalCapacityUsed = builder.logicalCapacityUsed;
        this.nfsExported = builder.nfsExported;
        this.snapshotCapacityUsed = builder.snapshotCapacityUsed;
        this.maxP95Performance = builder.maxP95Performance;
        this.recommendations = builder.recommendations;
        this.recommendationStatus = builder.recommendationStatus;
        this.lunCount = builder.lunCount;
    }

    public final String volumeName() {
        return this.volumeName;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final Long cifsShareCount() {
        return this.cifsShareCount;
    }

    public final String securityStyle() {
        return this.securityStyle;
    }

    public final String svmUuid() {
        return this.svmUuid;
    }

    public final String svmName() {
        return this.svmName;
    }

    public final Long capacityUsed() {
        return this.capacityUsed;
    }

    public final Long capacityProvisioned() {
        return this.capacityProvisioned;
    }

    public final Long logicalCapacityUsed() {
        return this.logicalCapacityUsed;
    }

    public final Boolean nfsExported() {
        return this.nfsExported;
    }

    public final Long snapshotCapacityUsed() {
        return this.snapshotCapacityUsed;
    }

    public final MaxP95Performance maxP95Performance() {
        return this.maxP95Performance;
    }

    public final boolean hasRecommendations() {
        return this.recommendations != null && !(this.recommendations instanceof SdkAutoConstructList);
    }

    public final List<Recommendation> recommendations() {
        return this.recommendations;
    }

    public final RecommendationStatus recommendationStatus() {
        return RecommendationStatus.fromValue(this.recommendationStatus);
    }

    public final String recommendationStatusAsString() {
        return this.recommendationStatus;
    }

    public final Long lunCount() {
        return this.lunCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cifsShareCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.svmUuid());
        hashCode = 31 * hashCode + Objects.hashCode(this.svmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityUsed());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityProvisioned());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalCapacityUsed());
        hashCode = 31 * hashCode + Objects.hashCode(this.nfsExported());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCapacityUsed());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxP95Performance());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendations() ? this.recommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lunCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetAppONTAPVolume)) {
            return false;
        }
        NetAppONTAPVolume other = (NetAppONTAPVolume)obj;
        return Objects.equals(this.volumeName(), other.volumeName()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.cifsShareCount(), other.cifsShareCount()) && Objects.equals(this.securityStyle(), other.securityStyle()) && Objects.equals(this.svmUuid(), other.svmUuid()) && Objects.equals(this.svmName(), other.svmName()) && Objects.equals(this.capacityUsed(), other.capacityUsed()) && Objects.equals(this.capacityProvisioned(), other.capacityProvisioned()) && Objects.equals(this.logicalCapacityUsed(), other.logicalCapacityUsed()) && Objects.equals(this.nfsExported(), other.nfsExported()) && Objects.equals(this.snapshotCapacityUsed(), other.snapshotCapacityUsed()) && Objects.equals(this.maxP95Performance(), other.maxP95Performance()) && this.hasRecommendations() == other.hasRecommendations() && Objects.equals(this.recommendations(), other.recommendations()) && Objects.equals(this.recommendationStatusAsString(), other.recommendationStatusAsString()) && Objects.equals(this.lunCount(), other.lunCount());
    }

    public final String toString() {
        return ToString.builder((String)"NetAppONTAPVolume").add("VolumeName", (Object)this.volumeName()).add("ResourceId", (Object)this.resourceId()).add("CifsShareCount", (Object)this.cifsShareCount()).add("SecurityStyle", (Object)this.securityStyle()).add("SvmUuid", (Object)this.svmUuid()).add("SvmName", (Object)this.svmName()).add("CapacityUsed", (Object)this.capacityUsed()).add("CapacityProvisioned", (Object)this.capacityProvisioned()).add("LogicalCapacityUsed", (Object)this.logicalCapacityUsed()).add("NfsExported", (Object)this.nfsExported()).add("SnapshotCapacityUsed", (Object)this.snapshotCapacityUsed()).add("MaxP95Performance", (Object)this.maxP95Performance()).add("Recommendations", this.hasRecommendations() ? this.recommendations() : null).add("RecommendationStatus", (Object)this.recommendationStatusAsString()).add("LunCount", (Object)this.lunCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeName": {
                return Optional.ofNullable(clazz.cast(this.volumeName()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "CifsShareCount": {
                return Optional.ofNullable(clazz.cast(this.cifsShareCount()));
            }
            case "SecurityStyle": {
                return Optional.ofNullable(clazz.cast(this.securityStyle()));
            }
            case "SvmUuid": {
                return Optional.ofNullable(clazz.cast(this.svmUuid()));
            }
            case "SvmName": {
                return Optional.ofNullable(clazz.cast(this.svmName()));
            }
            case "CapacityUsed": {
                return Optional.ofNullable(clazz.cast(this.capacityUsed()));
            }
            case "CapacityProvisioned": {
                return Optional.ofNullable(clazz.cast(this.capacityProvisioned()));
            }
            case "LogicalCapacityUsed": {
                return Optional.ofNullable(clazz.cast(this.logicalCapacityUsed()));
            }
            case "NfsExported": {
                return Optional.ofNullable(clazz.cast(this.nfsExported()));
            }
            case "SnapshotCapacityUsed": {
                return Optional.ofNullable(clazz.cast(this.snapshotCapacityUsed()));
            }
            case "MaxP95Performance": {
                return Optional.ofNullable(clazz.cast(this.maxP95Performance()));
            }
            case "Recommendations": {
                return Optional.ofNullable(clazz.cast(this.recommendations()));
            }
            case "RecommendationStatus": {
                return Optional.ofNullable(clazz.cast(this.recommendationStatusAsString()));
            }
            case "LunCount": {
                return Optional.ofNullable(clazz.cast(this.lunCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VolumeName", VOLUME_NAME_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("CifsShareCount", CIFS_SHARE_COUNT_FIELD);
        map.put("SecurityStyle", SECURITY_STYLE_FIELD);
        map.put("SvmUuid", SVM_UUID_FIELD);
        map.put("SvmName", SVM_NAME_FIELD);
        map.put("CapacityUsed", CAPACITY_USED_FIELD);
        map.put("CapacityProvisioned", CAPACITY_PROVISIONED_FIELD);
        map.put("LogicalCapacityUsed", LOGICAL_CAPACITY_USED_FIELD);
        map.put("NfsExported", NFS_EXPORTED_FIELD);
        map.put("SnapshotCapacityUsed", SNAPSHOT_CAPACITY_USED_FIELD);
        map.put("MaxP95Performance", MAX_P95_PERFORMANCE_FIELD);
        map.put("Recommendations", RECOMMENDATIONS_FIELD);
        map.put("RecommendationStatus", RECOMMENDATION_STATUS_FIELD);
        map.put("LunCount", LUN_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetAppONTAPVolume, T> g) {
        return obj -> g.apply((NetAppONTAPVolume)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String volumeName;
        private String resourceId;
        private Long cifsShareCount;
        private String securityStyle;
        private String svmUuid;
        private String svmName;
        private Long capacityUsed;
        private Long capacityProvisioned;
        private Long logicalCapacityUsed;
        private Boolean nfsExported;
        private Long snapshotCapacityUsed;
        private MaxP95Performance maxP95Performance;
        private List<Recommendation> recommendations = DefaultSdkAutoConstructList.getInstance();
        private String recommendationStatus;
        private Long lunCount;

        private BuilderImpl() {
        }

        private BuilderImpl(NetAppONTAPVolume model) {
            this.volumeName(model.volumeName);
            this.resourceId(model.resourceId);
            this.cifsShareCount(model.cifsShareCount);
            this.securityStyle(model.securityStyle);
            this.svmUuid(model.svmUuid);
            this.svmName(model.svmName);
            this.capacityUsed(model.capacityUsed);
            this.capacityProvisioned(model.capacityProvisioned);
            this.logicalCapacityUsed(model.logicalCapacityUsed);
            this.nfsExported(model.nfsExported);
            this.snapshotCapacityUsed(model.snapshotCapacityUsed);
            this.maxP95Performance(model.maxP95Performance);
            this.recommendations(model.recommendations);
            this.recommendationStatus(model.recommendationStatus);
            this.lunCount(model.lunCount);
        }

        public final String getVolumeName() {
            return this.volumeName;
        }

        public final void setVolumeName(String volumeName) {
            this.volumeName = volumeName;
        }

        @Override
        public final Builder volumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final Long getCifsShareCount() {
            return this.cifsShareCount;
        }

        public final void setCifsShareCount(Long cifsShareCount) {
            this.cifsShareCount = cifsShareCount;
        }

        @Override
        public final Builder cifsShareCount(Long cifsShareCount) {
            this.cifsShareCount = cifsShareCount;
            return this;
        }

        public final String getSecurityStyle() {
            return this.securityStyle;
        }

        public final void setSecurityStyle(String securityStyle) {
            this.securityStyle = securityStyle;
        }

        @Override
        public final Builder securityStyle(String securityStyle) {
            this.securityStyle = securityStyle;
            return this;
        }

        public final String getSvmUuid() {
            return this.svmUuid;
        }

        public final void setSvmUuid(String svmUuid) {
            this.svmUuid = svmUuid;
        }

        @Override
        public final Builder svmUuid(String svmUuid) {
            this.svmUuid = svmUuid;
            return this;
        }

        public final String getSvmName() {
            return this.svmName;
        }

        public final void setSvmName(String svmName) {
            this.svmName = svmName;
        }

        @Override
        public final Builder svmName(String svmName) {
            this.svmName = svmName;
            return this;
        }

        public final Long getCapacityUsed() {
            return this.capacityUsed;
        }

        public final void setCapacityUsed(Long capacityUsed) {
            this.capacityUsed = capacityUsed;
        }

        @Override
        public final Builder capacityUsed(Long capacityUsed) {
            this.capacityUsed = capacityUsed;
            return this;
        }

        public final Long getCapacityProvisioned() {
            return this.capacityProvisioned;
        }

        public final void setCapacityProvisioned(Long capacityProvisioned) {
            this.capacityProvisioned = capacityProvisioned;
        }

        @Override
        public final Builder capacityProvisioned(Long capacityProvisioned) {
            this.capacityProvisioned = capacityProvisioned;
            return this;
        }

        public final Long getLogicalCapacityUsed() {
            return this.logicalCapacityUsed;
        }

        public final void setLogicalCapacityUsed(Long logicalCapacityUsed) {
            this.logicalCapacityUsed = logicalCapacityUsed;
        }

        @Override
        public final Builder logicalCapacityUsed(Long logicalCapacityUsed) {
            this.logicalCapacityUsed = logicalCapacityUsed;
            return this;
        }

        public final Boolean getNfsExported() {
            return this.nfsExported;
        }

        public final void setNfsExported(Boolean nfsExported) {
            this.nfsExported = nfsExported;
        }

        @Override
        public final Builder nfsExported(Boolean nfsExported) {
            this.nfsExported = nfsExported;
            return this;
        }

        public final Long getSnapshotCapacityUsed() {
            return this.snapshotCapacityUsed;
        }

        public final void setSnapshotCapacityUsed(Long snapshotCapacityUsed) {
            this.snapshotCapacityUsed = snapshotCapacityUsed;
        }

        @Override
        public final Builder snapshotCapacityUsed(Long snapshotCapacityUsed) {
            this.snapshotCapacityUsed = snapshotCapacityUsed;
            return this;
        }

        public final MaxP95Performance.Builder getMaxP95Performance() {
            return this.maxP95Performance != null ? this.maxP95Performance.toBuilder() : null;
        }

        public final void setMaxP95Performance(MaxP95Performance.BuilderImpl maxP95Performance) {
            this.maxP95Performance = maxP95Performance != null ? maxP95Performance.build() : null;
        }

        @Override
        public final Builder maxP95Performance(MaxP95Performance maxP95Performance) {
            this.maxP95Performance = maxP95Performance;
            return this;
        }

        public final List<Recommendation.Builder> getRecommendations() {
            List<Recommendation.Builder> result = RecommendationsCopier.copyToBuilder(this.recommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendations(Collection<Recommendation.BuilderImpl> recommendations) {
            this.recommendations = RecommendationsCopier.copyFromBuilder(recommendations);
        }

        @Override
        public final Builder recommendations(Collection<Recommendation> recommendations) {
            this.recommendations = RecommendationsCopier.copy(recommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(Recommendation ... recommendations) {
            this.recommendations(Arrays.asList(recommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(Consumer<Recommendation.Builder> ... recommendations) {
            this.recommendations(Stream.of(recommendations).map(c -> (Recommendation)((Recommendation.Builder)Recommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRecommendationStatus() {
            return this.recommendationStatus;
        }

        public final void setRecommendationStatus(String recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
        }

        @Override
        public final Builder recommendationStatus(String recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
            return this;
        }

        @Override
        public final Builder recommendationStatus(RecommendationStatus recommendationStatus) {
            this.recommendationStatus(recommendationStatus == null ? null : recommendationStatus.toString());
            return this;
        }

        public final Long getLunCount() {
            return this.lunCount;
        }

        public final void setLunCount(Long lunCount) {
            this.lunCount = lunCount;
        }

        @Override
        public final Builder lunCount(Long lunCount) {
            this.lunCount = lunCount;
            return this;
        }

        public NetAppONTAPVolume build() {
            return new NetAppONTAPVolume(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetAppONTAPVolume> {
        public Builder volumeName(String var1);

        public Builder resourceId(String var1);

        public Builder cifsShareCount(Long var1);

        public Builder securityStyle(String var1);

        public Builder svmUuid(String var1);

        public Builder svmName(String var1);

        public Builder capacityUsed(Long var1);

        public Builder capacityProvisioned(Long var1);

        public Builder logicalCapacityUsed(Long var1);

        public Builder nfsExported(Boolean var1);

        public Builder snapshotCapacityUsed(Long var1);

        public Builder maxP95Performance(MaxP95Performance var1);

        default public Builder maxP95Performance(Consumer<MaxP95Performance.Builder> maxP95Performance) {
            return this.maxP95Performance((MaxP95Performance)((MaxP95Performance.Builder)MaxP95Performance.builder().applyMutation(maxP95Performance)).build());
        }

        public Builder recommendations(Collection<Recommendation> var1);

        public Builder recommendations(Recommendation ... var1);

        public Builder recommendations(Consumer<Recommendation.Builder> ... var1);

        public Builder recommendationStatus(String var1);

        public Builder recommendationStatus(RecommendationStatus var1);

        public Builder lunCount(Long var1);
    }
}

