/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.ResourceDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStorageSystemResourcesResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, DescribeStorageSystemResourcesResponse> {
    private static final SdkField<ResourceDetails> RESOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceDetails").getter(DescribeStorageSystemResourcesResponse.getter(DescribeStorageSystemResourcesResponse::resourceDetails)).setter(DescribeStorageSystemResourcesResponse.setter(Builder::resourceDetails)).constructor(ResourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDetails").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeStorageSystemResourcesResponse.getter(DescribeStorageSystemResourcesResponse::nextToken)).setter(DescribeStorageSystemResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_DETAILS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeStorageSystemResourcesResponse.memberNameToFieldInitializer();
    private final ResourceDetails resourceDetails;
    private final String nextToken;

    private DescribeStorageSystemResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceDetails = builder.resourceDetails;
        this.nextToken = builder.nextToken;
    }

    public final ResourceDetails resourceDetails() {
        return this.resourceDetails;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorageSystemResourcesResponse)) {
            return false;
        }
        DescribeStorageSystemResourcesResponse other = (DescribeStorageSystemResourcesResponse)((Object)obj);
        return Objects.equals(this.resourceDetails(), other.resourceDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStorageSystemResourcesResponse").add("ResourceDetails", (Object)this.resourceDetails()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceDetails": {
                return Optional.ofNullable(clazz.cast(this.resourceDetails()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceDetails", RESOURCE_DETAILS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorageSystemResourcesResponse, T> g) {
        return obj -> g.apply((DescribeStorageSystemResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private ResourceDetails resourceDetails;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorageSystemResourcesResponse model) {
            super(model);
            this.resourceDetails(model.resourceDetails);
            this.nextToken(model.nextToken);
        }

        public final ResourceDetails.Builder getResourceDetails() {
            return this.resourceDetails != null ? this.resourceDetails.toBuilder() : null;
        }

        public final void setResourceDetails(ResourceDetails.BuilderImpl resourceDetails) {
            this.resourceDetails = resourceDetails != null ? resourceDetails.build() : null;
        }

        @Override
        public final Builder resourceDetails(ResourceDetails resourceDetails) {
            this.resourceDetails = resourceDetails;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeStorageSystemResourcesResponse build() {
            return new DescribeStorageSystemResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStorageSystemResourcesResponse> {
        public Builder resourceDetails(ResourceDetails var1);

        default public Builder resourceDetails(Consumer<ResourceDetails.Builder> resourceDetails) {
            return this.resourceDetails((ResourceDetails)((ResourceDetails.Builder)ResourceDetails.builder().applyMutation(resourceDetails)).build());
        }

        public Builder nextToken(String var1);
    }
}

