/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncClient;
import software.amazon.awssdk.services.datasync.internal.UserAgentUtils;
import software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesRequest;
import software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesResponse;

public class DescribeStorageSystemResourcesIterable
implements SdkIterable<DescribeStorageSystemResourcesResponse> {
    private final DataSyncClient client;
    private final DescribeStorageSystemResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeStorageSystemResourcesIterable(DataSyncClient client, DescribeStorageSystemResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeStorageSystemResourcesResponseFetcher();
    }

    public Iterator<DescribeStorageSystemResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeStorageSystemResourcesResponseFetcher
    implements SyncPageFetcher<DescribeStorageSystemResourcesResponse> {
        private DescribeStorageSystemResourcesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStorageSystemResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeStorageSystemResourcesResponse nextPage(DescribeStorageSystemResourcesResponse previousPage) {
            if (previousPage == null) {
                return DescribeStorageSystemResourcesIterable.this.client.describeStorageSystemResources(DescribeStorageSystemResourcesIterable.this.firstRequest);
            }
            return DescribeStorageSystemResourcesIterable.this.client.describeStorageSystemResources((DescribeStorageSystemResourcesRequest)((Object)DescribeStorageSystemResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

