/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.services.datasync.DataSyncBaseClientBuilder;
import software.amazon.awssdk.services.datasync.endpoints.DataSyncEndpointProvider;
import software.amazon.awssdk.services.datasync.endpoints.internal.DataSyncEndpointAuthSchemeInterceptor;
import software.amazon.awssdk.services.datasync.endpoints.internal.DataSyncRequestSetEndpointInterceptor;
import software.amazon.awssdk.services.datasync.endpoints.internal.DataSyncResolveEndpointInterceptor;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
abstract class DefaultDataSyncBaseClientBuilder<B extends DataSyncBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultDataSyncBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "datasync";
    }

    protected final String serviceName() {
        return "DataSync";
    }

    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)this.defaultEndpointProvider()).option((ClientOption)SdkAdvancedClientOption.SIGNER, (Object)this.defaultSigner()).option((ClientOption)SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, (Object)false));
    }

    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ArrayList<Object> endpointInterceptors = new ArrayList<Object>();
        endpointInterceptors.add(new DataSyncResolveEndpointInterceptor());
        endpointInterceptors.add(new DataSyncEndpointAuthSchemeInterceptor());
        endpointInterceptors.add(new DataSyncRequestSetEndpointInterceptor());
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/datasync/execution.interceptors");
        ArrayList additionalInterceptors = new ArrayList();
        interceptors = CollectionUtils.mergeLists(endpointInterceptors, (List)interceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, additionalInterceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        return config.toBuilder().option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors).build();
    }

    private Signer defaultSigner() {
        return Aws4Signer.create();
    }

    protected final String signingName() {
        return "datasync";
    }

    private DataSyncEndpointProvider defaultEndpointProvider() {
        return DataSyncEndpointProvider.defaultProvider();
    }
}

