/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the mount options that are available for DataSync to access an NFS location.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NfsMountOptions implements SdkPojo, Serializable, ToCopyableBuilder<NfsMountOptions.Builder, NfsMountOptions> {
    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NfsMountOptions::versionAsString)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String version;

    private NfsMountOptions(BuilderImpl builder) {
        this.version = builder.version;
    }

    /**
     * <p>
     * The specific NFS version that you want DataSync to use to mount your NFS share. If the server refuses to use the
     * version specified, the sync will fail. If you don't specify a version, DataSync defaults to
     * <code>AUTOMATIC</code>. That is, DataSync automatically selects a version based on negotiation with the NFS
     * server.
     * </p>
     * <p>
     * You can specify the following NFS versions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <a href="https://tools.ietf.org/html/rfc1813">NFSv3</a> </b> - stateless protocol version that allows for
     * asynchronous writes on the server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <a href="https://tools.ietf.org/html/rfc3530">NFSv4.0</a> </b> - stateful, firewall-friendly protocol version
     * that supports delegations and pseudo filesystems.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <a href="https://tools.ietf.org/html/rfc5661">NFSv4.1</a> </b> - stateful protocol version that supports
     * sessions, directory delegations, and parallel data processing. Version 4.1 also includes all features available
     * in version 4.0.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #version} will
     * return {@link NfsVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #versionAsString}.
     * </p>
     * 
     * @return The specific NFS version that you want DataSync to use to mount your NFS share. If the server refuses to
     *         use the version specified, the sync will fail. If you don't specify a version, DataSync defaults to
     *         <code>AUTOMATIC</code>. That is, DataSync automatically selects a version based on negotiation with the
     *         NFS server.</p>
     *         <p>
     *         You can specify the following NFS versions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <a href="https://tools.ietf.org/html/rfc1813">NFSv3</a> </b> - stateless protocol version that allows
     *         for asynchronous writes on the server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <a href="https://tools.ietf.org/html/rfc3530">NFSv4.0</a> </b> - stateful, firewall-friendly protocol
     *         version that supports delegations and pseudo filesystems.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <a href="https://tools.ietf.org/html/rfc5661">NFSv4.1</a> </b> - stateful protocol version that
     *         supports sessions, directory delegations, and parallel data processing. Version 4.1 also includes all
     *         features available in version 4.0.
     *         </p>
     *         </li>
     * @see NfsVersion
     */
    public NfsVersion version() {
        return NfsVersion.fromValue(version);
    }

    /**
     * <p>
     * The specific NFS version that you want DataSync to use to mount your NFS share. If the server refuses to use the
     * version specified, the sync will fail. If you don't specify a version, DataSync defaults to
     * <code>AUTOMATIC</code>. That is, DataSync automatically selects a version based on negotiation with the NFS
     * server.
     * </p>
     * <p>
     * You can specify the following NFS versions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <a href="https://tools.ietf.org/html/rfc1813">NFSv3</a> </b> - stateless protocol version that allows for
     * asynchronous writes on the server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <a href="https://tools.ietf.org/html/rfc3530">NFSv4.0</a> </b> - stateful, firewall-friendly protocol version
     * that supports delegations and pseudo filesystems.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <a href="https://tools.ietf.org/html/rfc5661">NFSv4.1</a> </b> - stateful protocol version that supports
     * sessions, directory delegations, and parallel data processing. Version 4.1 also includes all features available
     * in version 4.0.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #version} will
     * return {@link NfsVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #versionAsString}.
     * </p>
     * 
     * @return The specific NFS version that you want DataSync to use to mount your NFS share. If the server refuses to
     *         use the version specified, the sync will fail. If you don't specify a version, DataSync defaults to
     *         <code>AUTOMATIC</code>. That is, DataSync automatically selects a version based on negotiation with the
     *         NFS server.</p>
     *         <p>
     *         You can specify the following NFS versions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <a href="https://tools.ietf.org/html/rfc1813">NFSv3</a> </b> - stateless protocol version that allows
     *         for asynchronous writes on the server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <a href="https://tools.ietf.org/html/rfc3530">NFSv4.0</a> </b> - stateful, firewall-friendly protocol
     *         version that supports delegations and pseudo filesystems.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <a href="https://tools.ietf.org/html/rfc5661">NFSv4.1</a> </b> - stateful protocol version that
     *         supports sessions, directory delegations, and parallel data processing. Version 4.1 also includes all
     *         features available in version 4.0.
     *         </p>
     *         </li>
     * @see NfsVersion
     */
    public String versionAsString() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(versionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NfsMountOptions)) {
            return false;
        }
        NfsMountOptions other = (NfsMountOptions) obj;
        return Objects.equals(versionAsString(), other.versionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NfsMountOptions").add("Version", versionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Version":
            return Optional.ofNullable(clazz.cast(versionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NfsMountOptions, T> g) {
        return obj -> g.apply((NfsMountOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NfsMountOptions> {
        /**
         * <p>
         * The specific NFS version that you want DataSync to use to mount your NFS share. If the server refuses to use
         * the version specified, the sync will fail. If you don't specify a version, DataSync defaults to
         * <code>AUTOMATIC</code>. That is, DataSync automatically selects a version based on negotiation with the NFS
         * server.
         * </p>
         * <p>
         * You can specify the following NFS versions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <a href="https://tools.ietf.org/html/rfc1813">NFSv3</a> </b> - stateless protocol version that allows for
         * asynchronous writes on the server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <a href="https://tools.ietf.org/html/rfc3530">NFSv4.0</a> </b> - stateful, firewall-friendly protocol
         * version that supports delegations and pseudo filesystems.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <a href="https://tools.ietf.org/html/rfc5661">NFSv4.1</a> </b> - stateful protocol version that supports
         * sessions, directory delegations, and parallel data processing. Version 4.1 also includes all features
         * available in version 4.0.
         * </p>
         * </li>
         * </ul>
         * 
         * @param version
         *        The specific NFS version that you want DataSync to use to mount your NFS share. If the server refuses
         *        to use the version specified, the sync will fail. If you don't specify a version, DataSync defaults to
         *        <code>AUTOMATIC</code>. That is, DataSync automatically selects a version based on negotiation with
         *        the NFS server.</p>
         *        <p>
         *        You can specify the following NFS versions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <a href="https://tools.ietf.org/html/rfc1813">NFSv3</a> </b> - stateless protocol version that
         *        allows for asynchronous writes on the server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <a href="https://tools.ietf.org/html/rfc3530">NFSv4.0</a> </b> - stateful, firewall-friendly
         *        protocol version that supports delegations and pseudo filesystems.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <a href="https://tools.ietf.org/html/rfc5661">NFSv4.1</a> </b> - stateful protocol version that
         *        supports sessions, directory delegations, and parallel data processing. Version 4.1 also includes all
         *        features available in version 4.0.
         *        </p>
         *        </li>
         * @see NfsVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NfsVersion
         */
        Builder version(String version);

        /**
         * <p>
         * The specific NFS version that you want DataSync to use to mount your NFS share. If the server refuses to use
         * the version specified, the sync will fail. If you don't specify a version, DataSync defaults to
         * <code>AUTOMATIC</code>. That is, DataSync automatically selects a version based on negotiation with the NFS
         * server.
         * </p>
         * <p>
         * You can specify the following NFS versions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <a href="https://tools.ietf.org/html/rfc1813">NFSv3</a> </b> - stateless protocol version that allows for
         * asynchronous writes on the server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <a href="https://tools.ietf.org/html/rfc3530">NFSv4.0</a> </b> - stateful, firewall-friendly protocol
         * version that supports delegations and pseudo filesystems.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <a href="https://tools.ietf.org/html/rfc5661">NFSv4.1</a> </b> - stateful protocol version that supports
         * sessions, directory delegations, and parallel data processing. Version 4.1 also includes all features
         * available in version 4.0.
         * </p>
         * </li>
         * </ul>
         * 
         * @param version
         *        The specific NFS version that you want DataSync to use to mount your NFS share. If the server refuses
         *        to use the version specified, the sync will fail. If you don't specify a version, DataSync defaults to
         *        <code>AUTOMATIC</code>. That is, DataSync automatically selects a version based on negotiation with
         *        the NFS server.</p>
         *        <p>
         *        You can specify the following NFS versions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <a href="https://tools.ietf.org/html/rfc1813">NFSv3</a> </b> - stateless protocol version that
         *        allows for asynchronous writes on the server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <a href="https://tools.ietf.org/html/rfc3530">NFSv4.0</a> </b> - stateful, firewall-friendly
         *        protocol version that supports delegations and pseudo filesystems.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <a href="https://tools.ietf.org/html/rfc5661">NFSv4.1</a> </b> - stateful protocol version that
         *        supports sessions, directory delegations, and parallel data processing. Version 4.1 also includes all
         *        features available in version 4.0.
         *        </p>
         *        </li>
         * @see NfsVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NfsVersion
         */
        Builder version(NfsVersion version);
    }

    static final class BuilderImpl implements Builder {
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(NfsMountOptions model) {
            version(model.version);
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public final Builder version(NfsVersion version) {
            this.version(version == null ? null : version.toString());
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public NfsMountOptions build() {
            return new NfsMountOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
