/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncClient;
import software.amazon.awssdk.services.datasync.model.ListLocationsRequest;
import software.amazon.awssdk.services.datasync.model.ListLocationsResponse;

public class ListLocationsIterable
implements SdkIterable<ListLocationsResponse> {
    private final DataSyncClient client;
    private final ListLocationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLocationsIterable(DataSyncClient client, ListLocationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLocationsResponseFetcher();
    }

    public Iterator<ListLocationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListLocationsIterable resume(ListLocationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListLocationsIterable(this.client, (ListLocationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListLocationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListLocationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListLocationsResponseFetcher
    implements SyncPageFetcher<ListLocationsResponse> {
        private ListLocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListLocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLocationsResponse nextPage(ListLocationsResponse previousPage) {
            if (previousPage == null) {
                return ListLocationsIterable.this.client.listLocations(ListLocationsIterable.this.firstRequest);
            }
            return ListLocationsIterable.this.client.listLocations((ListLocationsRequest)((Object)ListLocationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

