/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.datapipeline.DataPipelineClient;
import software.amazon.awssdk.services.datapipeline.model.ActivatePipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.ActivatePipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.AddTagsRequest;
import software.amazon.awssdk.services.datapipeline.model.AddTagsResponse;
import software.amazon.awssdk.services.datapipeline.model.CreatePipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.CreatePipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineException;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.DeactivatePipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.DeactivatePipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.DeletePipelineRequest;
import software.amazon.awssdk.services.datapipeline.model.DeletePipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.DescribeObjectsRequest;
import software.amazon.awssdk.services.datapipeline.model.DescribeObjectsResponse;
import software.amazon.awssdk.services.datapipeline.model.DescribePipelinesRequest;
import software.amazon.awssdk.services.datapipeline.model.DescribePipelinesResponse;
import software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionRequest;
import software.amazon.awssdk.services.datapipeline.model.EvaluateExpressionResponse;
import software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionRequest;
import software.amazon.awssdk.services.datapipeline.model.GetPipelineDefinitionResponse;
import software.amazon.awssdk.services.datapipeline.model.InternalServiceErrorException;
import software.amazon.awssdk.services.datapipeline.model.InvalidRequestException;
import software.amazon.awssdk.services.datapipeline.model.ListPipelinesRequest;
import software.amazon.awssdk.services.datapipeline.model.ListPipelinesResponse;
import software.amazon.awssdk.services.datapipeline.model.PipelineDeletedException;
import software.amazon.awssdk.services.datapipeline.model.PipelineNotFoundException;
import software.amazon.awssdk.services.datapipeline.model.PollForTaskRequest;
import software.amazon.awssdk.services.datapipeline.model.PollForTaskResponse;
import software.amazon.awssdk.services.datapipeline.model.PutPipelineDefinitionRequest;
import software.amazon.awssdk.services.datapipeline.model.PutPipelineDefinitionResponse;
import software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest;
import software.amazon.awssdk.services.datapipeline.model.QueryObjectsResponse;
import software.amazon.awssdk.services.datapipeline.model.RemoveTagsRequest;
import software.amazon.awssdk.services.datapipeline.model.RemoveTagsResponse;
import software.amazon.awssdk.services.datapipeline.model.ReportTaskProgressRequest;
import software.amazon.awssdk.services.datapipeline.model.ReportTaskProgressResponse;
import software.amazon.awssdk.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest;
import software.amazon.awssdk.services.datapipeline.model.ReportTaskRunnerHeartbeatResponse;
import software.amazon.awssdk.services.datapipeline.model.SetStatusRequest;
import software.amazon.awssdk.services.datapipeline.model.SetStatusResponse;
import software.amazon.awssdk.services.datapipeline.model.SetTaskStatusRequest;
import software.amazon.awssdk.services.datapipeline.model.SetTaskStatusResponse;
import software.amazon.awssdk.services.datapipeline.model.TaskNotFoundException;
import software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionRequest;
import software.amazon.awssdk.services.datapipeline.model.ValidatePipelineDefinitionResponse;
import software.amazon.awssdk.services.datapipeline.paginators.DescribeObjectsIterable;
import software.amazon.awssdk.services.datapipeline.paginators.ListPipelinesIterable;
import software.amazon.awssdk.services.datapipeline.paginators.QueryObjectsIterable;
import software.amazon.awssdk.services.datapipeline.transform.ActivatePipelineRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.CreatePipelineRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DeactivatePipelineRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DeletePipelineRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DescribeObjectsRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.DescribePipelinesRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.EvaluateExpressionRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.GetPipelineDefinitionRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ListPipelinesRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.PollForTaskRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.PutPipelineDefinitionRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.QueryObjectsRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ReportTaskProgressRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ReportTaskRunnerHeartbeatRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.SetStatusRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.SetTaskStatusRequestMarshaller;
import software.amazon.awssdk.services.datapipeline.transform.ValidatePipelineDefinitionRequestMarshaller;

@SdkInternalApi
final class DefaultDataPipelineClient
implements DataPipelineClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDataPipelineClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "datapipeline";
    }

    @Override
    public ActivatePipelineResponse activatePipeline(ActivatePipelineRequest activatePipelineRequest) throws PipelineNotFoundException, PipelineDeletedException, InternalServiceErrorException, InvalidRequestException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ActivatePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ActivatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ActivatePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)activatePipelineRequest).withMarshaller((Marshaller)new ActivatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AddTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsRequest).withMarshaller((Marshaller)new AddTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreatePipelineResponse createPipeline(CreatePipelineRequest createPipelineRequest) throws InternalServiceErrorException, InvalidRequestException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPipelineRequest).withMarshaller((Marshaller)new CreatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeactivatePipelineResponse deactivatePipeline(DeactivatePipelineRequest deactivatePipelineRequest) throws PipelineNotFoundException, PipelineDeletedException, InternalServiceErrorException, InvalidRequestException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeactivatePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeactivatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeactivatePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deactivatePipelineRequest).withMarshaller((Marshaller)new DeactivatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeletePipelineResponse deletePipeline(DeletePipelineRequest deletePipelineRequest) throws PipelineNotFoundException, InternalServiceErrorException, InvalidRequestException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeletePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePipelineRequest).withMarshaller((Marshaller)new DeletePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeObjectsResponse describeObjects(DescribeObjectsRequest describeObjectsRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeObjectsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeObjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeObjects").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeObjectsRequest).withMarshaller((Marshaller)new DescribeObjectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeObjectsIterable describeObjectsPaginator(DescribeObjectsRequest describeObjectsRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, AwsServiceException, SdkClientException, DataPipelineException {
        return new DescribeObjectsIterable(this, this.applyPaginatorUserAgent(describeObjectsRequest));
    }

    @Override
    public DescribePipelinesResponse describePipelines(DescribePipelinesRequest describePipelinesRequest) throws PipelineNotFoundException, PipelineDeletedException, InternalServiceErrorException, InvalidRequestException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePipelinesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribePipelinesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePipelines").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePipelinesRequest).withMarshaller((Marshaller)new DescribePipelinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public EvaluateExpressionResponse evaluateExpression(EvaluateExpressionRequest evaluateExpressionRequest) throws InternalServiceErrorException, TaskNotFoundException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EvaluateExpressionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (EvaluateExpressionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EvaluateExpression").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)evaluateExpressionRequest).withMarshaller((Marshaller)new EvaluateExpressionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetPipelineDefinitionResponse getPipelineDefinition(GetPipelineDefinitionRequest getPipelineDefinitionRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineDefinitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetPipelineDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipelineDefinition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPipelineDefinitionRequest).withMarshaller((Marshaller)new GetPipelineDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPipelinesResponse listPipelines(ListPipelinesRequest listPipelinesRequest) throws InternalServiceErrorException, InvalidRequestException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipelinesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListPipelinesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipelines").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPipelinesRequest).withMarshaller((Marshaller)new ListPipelinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPipelinesIterable listPipelinesPaginator(ListPipelinesRequest listPipelinesRequest) throws InternalServiceErrorException, InvalidRequestException, AwsServiceException, SdkClientException, DataPipelineException {
        return new ListPipelinesIterable(this, this.applyPaginatorUserAgent(listPipelinesRequest));
    }

    @Override
    public PollForTaskResponse pollForTask(PollForTaskRequest pollForTaskRequest) throws InternalServiceErrorException, InvalidRequestException, TaskNotFoundException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PollForTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PollForTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PollForTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)pollForTaskRequest).withMarshaller((Marshaller)new PollForTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutPipelineDefinitionResponse putPipelineDefinition(PutPipelineDefinitionRequest putPipelineDefinitionRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutPipelineDefinitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutPipelineDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPipelineDefinition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putPipelineDefinitionRequest).withMarshaller((Marshaller)new PutPipelineDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public QueryObjectsResponse queryObjects(QueryObjectsRequest queryObjectsRequest) throws PipelineNotFoundException, PipelineDeletedException, InternalServiceErrorException, InvalidRequestException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, QueryObjectsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (QueryObjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("QueryObjects").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)queryObjectsRequest).withMarshaller((Marshaller)new QueryObjectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public QueryObjectsIterable queryObjectsPaginator(QueryObjectsRequest queryObjectsRequest) throws PipelineNotFoundException, PipelineDeletedException, InternalServiceErrorException, InvalidRequestException, AwsServiceException, SdkClientException, DataPipelineException {
        return new QueryObjectsIterable(this, this.applyPaginatorUserAgent(queryObjectsRequest));
    }

    @Override
    public RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RemoveTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsRequest).withMarshaller((Marshaller)new RemoveTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ReportTaskProgressResponse reportTaskProgress(ReportTaskProgressRequest reportTaskProgressRequest) throws InternalServiceErrorException, InvalidRequestException, TaskNotFoundException, PipelineNotFoundException, PipelineDeletedException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReportTaskProgressResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ReportTaskProgressResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReportTaskProgress").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)reportTaskProgressRequest).withMarshaller((Marshaller)new ReportTaskProgressRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ReportTaskRunnerHeartbeatResponse reportTaskRunnerHeartbeat(ReportTaskRunnerHeartbeatRequest reportTaskRunnerHeartbeatRequest) throws InternalServiceErrorException, InvalidRequestException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReportTaskRunnerHeartbeatResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ReportTaskRunnerHeartbeatResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReportTaskRunnerHeartbeat").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)reportTaskRunnerHeartbeatRequest).withMarshaller((Marshaller)new ReportTaskRunnerHeartbeatRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SetStatusResponse setStatus(SetStatusRequest setStatusRequest) throws PipelineNotFoundException, PipelineDeletedException, InternalServiceErrorException, InvalidRequestException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SetStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setStatusRequest).withMarshaller((Marshaller)new SetStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SetTaskStatusResponse setTaskStatus(SetTaskStatusRequest setTaskStatusRequest) throws InternalServiceErrorException, TaskNotFoundException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetTaskStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SetTaskStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetTaskStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setTaskStatusRequest).withMarshaller((Marshaller)new SetTaskStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ValidatePipelineDefinitionResponse validatePipelineDefinition(ValidatePipelineDefinitionRequest validatePipelineDefinitionRequest) throws InternalServiceErrorException, InvalidRequestException, PipelineNotFoundException, PipelineDeletedException, AwsServiceException, SdkClientException, DataPipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ValidatePipelineDefinitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ValidatePipelineDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ValidatePipelineDefinition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)validatePipelineDefinitionRequest).withMarshaller((Marshaller)new ValidatePipelineDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DataPipelineException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TaskNotFoundException").exceptionBuilderSupplier(TaskNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PipelineDeletedException").exceptionBuilderSupplier(PipelineDeletedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").exceptionBuilderSupplier(PipelineNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceError").exceptionBuilderSupplier(InternalServiceErrorException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends DataPipelineRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.5.66").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DataPipelineRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

