/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the query to run against an object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Query implements SdkPojo, Serializable, ToCopyableBuilder<Query.Builder, Query> {
    private static final SdkField<List<Selector>> SELECTORS_FIELD = SdkField
            .<List<Selector>> builder(MarshallingType.LIST)
            .memberName("selectors")
            .getter(getter(Query::selectors))
            .setter(setter(Builder::selectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Selector> builder(MarshallingType.SDK_POJO)
                                            .constructor(Selector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Selector> selectors;

    private Query(BuilderImpl builder) {
        this.selectors = builder.selectors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Selectors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSelectors() {
        return selectors != null && !(selectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of selectors that define the query. An object must satisfy all of the selectors to match the query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectors} method.
     * </p>
     * 
     * @return List of selectors that define the query. An object must satisfy all of the selectors to match the query.
     */
    public final List<Selector> selectors() {
        return selectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectors() ? selectors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Query)) {
            return false;
        }
        Query other = (Query) obj;
        return hasSelectors() == other.hasSelectors() && Objects.equals(selectors(), other.selectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Query").add("Selectors", hasSelectors() ? selectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "selectors":
            return Optional.ofNullable(clazz.cast(selectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("selectors", SELECTORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Query, T> g) {
        return obj -> g.apply((Query) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Query> {
        /**
         * <p>
         * List of selectors that define the query. An object must satisfy all of the selectors to match the query.
         * </p>
         * 
         * @param selectors
         *        List of selectors that define the query. An object must satisfy all of the selectors to match the
         *        query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectors(Collection<Selector> selectors);

        /**
         * <p>
         * List of selectors that define the query. An object must satisfy all of the selectors to match the query.
         * </p>
         * 
         * @param selectors
         *        List of selectors that define the query. An object must satisfy all of the selectors to match the
         *        query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectors(Selector... selectors);

        /**
         * <p>
         * List of selectors that define the query. An object must satisfy all of the selectors to match the query.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datapipeline.model.Selector.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datapipeline.model.Selector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datapipeline.model.Selector.Builder#build()} is called immediately and
         * its result is passed to {@link #selectors(List<Selector>)}.
         * 
         * @param selectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datapipeline.model.Selector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectors(java.util.Collection<Selector>)
         */
        Builder selectors(Consumer<Selector.Builder>... selectors);
    }

    static final class BuilderImpl implements Builder {
        private List<Selector> selectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Query model) {
            selectors(model.selectors);
        }

        public final List<Selector.Builder> getSelectors() {
            List<Selector.Builder> result = SelectorListCopier.copyToBuilder(this.selectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelectors(Collection<Selector.BuilderImpl> selectors) {
            this.selectors = SelectorListCopier.copyFromBuilder(selectors);
        }

        @Override
        public final Builder selectors(Collection<Selector> selectors) {
            this.selectors = SelectorListCopier.copy(selectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(Selector... selectors) {
            selectors(Arrays.asList(selectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(Consumer<Selector.Builder>... selectors) {
            selectors(Stream.of(selectors).map(c -> Selector.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Query build() {
            return new Query(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
