/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineRequest;
import software.amazon.awssdk.services.datapipeline.model._idListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeObjectsRequest
extends DataPipelineRequest
implements ToCopyableBuilder<Builder, DescribeObjectsRequest> {
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeObjectsRequest.getter(DescribeObjectsRequest::pipelineId)).setter(DescribeObjectsRequest.setter(Builder::pipelineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineId").build()}).build();
    private static final SdkField<List<String>> OBJECT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeObjectsRequest.getter(DescribeObjectsRequest::objectIds)).setter(DescribeObjectsRequest.setter(Builder::objectIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> EVALUATE_EXPRESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeObjectsRequest.getter(DescribeObjectsRequest::evaluateExpressions)).setter(DescribeObjectsRequest.setter(Builder::evaluateExpressions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluateExpressions").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeObjectsRequest.getter(DescribeObjectsRequest::marker)).setter(DescribeObjectsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ID_FIELD, OBJECT_IDS_FIELD, EVALUATE_EXPRESSIONS_FIELD, MARKER_FIELD));
    private final String pipelineId;
    private final List<String> objectIds;
    private final Boolean evaluateExpressions;
    private final String marker;

    private DescribeObjectsRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.objectIds = builder.objectIds;
        this.evaluateExpressions = builder.evaluateExpressions;
        this.marker = builder.marker;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public List<String> objectIds() {
        return this.objectIds;
    }

    public Boolean evaluateExpressions() {
        return this.evaluateExpressions;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluateExpressions());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeObjectsRequest)) {
            return false;
        }
        DescribeObjectsRequest other = (DescribeObjectsRequest)((Object)obj);
        return Objects.equals(this.pipelineId(), other.pipelineId()) && Objects.equals(this.objectIds(), other.objectIds()) && Objects.equals(this.evaluateExpressions(), other.evaluateExpressions()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeObjectsRequest").add("PipelineId", (Object)this.pipelineId()).add("ObjectIds", this.objectIds()).add("EvaluateExpressions", (Object)this.evaluateExpressions()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineId": {
                return Optional.ofNullable(clazz.cast(this.pipelineId()));
            }
            case "objectIds": {
                return Optional.ofNullable(clazz.cast(this.objectIds()));
            }
            case "evaluateExpressions": {
                return Optional.ofNullable(clazz.cast(this.evaluateExpressions()));
            }
            case "marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeObjectsRequest, T> g) {
        return obj -> g.apply((DescribeObjectsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataPipelineRequest.BuilderImpl
    implements Builder {
        private String pipelineId;
        private List<String> objectIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean evaluateExpressions;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeObjectsRequest model) {
            super(model);
            this.pipelineId(model.pipelineId);
            this.objectIds(model.objectIds);
            this.evaluateExpressions(model.evaluateExpressions);
            this.marker(model.marker);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final Collection<String> getObjectIds() {
            return this.objectIds;
        }

        @Override
        public final Builder objectIds(Collection<String> objectIds) {
            this.objectIds = _idListCopier.copy(objectIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectIds(String ... objectIds) {
            this.objectIds(Arrays.asList(objectIds));
            return this;
        }

        public final void setObjectIds(Collection<String> objectIds) {
            this.objectIds = _idListCopier.copy(objectIds);
        }

        public final Boolean getEvaluateExpressions() {
            return this.evaluateExpressions;
        }

        @Override
        public final Builder evaluateExpressions(Boolean evaluateExpressions) {
            this.evaluateExpressions = evaluateExpressions;
            return this;
        }

        public final void setEvaluateExpressions(Boolean evaluateExpressions) {
            this.evaluateExpressions = evaluateExpressions;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeObjectsRequest build() {
            return new DescribeObjectsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataPipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeObjectsRequest> {
        public Builder pipelineId(String var1);

        public Builder objectIds(Collection<String> var1);

        public Builder objectIds(String ... var1);

        public Builder evaluateExpressions(Boolean var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

