/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.datapipeline.DataPipelineClient;
import software.amazon.awssdk.services.datapipeline.internal.UserAgentUtils;
import software.amazon.awssdk.services.datapipeline.model.QueryObjectsRequest;
import software.amazon.awssdk.services.datapipeline.model.QueryObjectsResponse;

public class QueryObjectsIterable
implements SdkIterable<QueryObjectsResponse> {
    private final DataPipelineClient client;
    private final QueryObjectsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public QueryObjectsIterable(DataPipelineClient client, QueryObjectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new QueryObjectsResponseFetcher();
    }

    public Iterator<QueryObjectsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> ids() {
        Function<QueryObjectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ids() != null) {
                return response.ids().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class QueryObjectsResponseFetcher
    implements SyncPageFetcher<QueryObjectsResponse> {
        private QueryObjectsResponseFetcher() {
        }

        public boolean hasNextPage(QueryObjectsResponse previousPage) {
            return previousPage.hasMoreResults() != null && previousPage.hasMoreResults() != false;
        }

        public QueryObjectsResponse nextPage(QueryObjectsResponse previousPage) {
            if (previousPage == null) {
                return QueryObjectsIterable.this.client.queryObjects(QueryObjectsIterable.this.firstRequest);
            }
            return QueryObjectsIterable.this.client.queryObjects((QueryObjectsRequest)((Object)QueryObjectsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

