/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.ParameterObject;
import software.amazon.awssdk.services.datapipeline.model.ParameterObjectListCopier;
import software.amazon.awssdk.services.datapipeline.model.ParameterValue;
import software.amazon.awssdk.services.datapipeline.model.ParameterValueListCopier;
import software.amazon.awssdk.services.datapipeline.model.PipelineObject;
import software.amazon.awssdk.services.datapipeline.model.PipelineObjectListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPipelineDefinitionResponse
extends DataPipelineResponse
implements ToCopyableBuilder<Builder, GetPipelineDefinitionResponse> {
    private static final SdkField<List<PipelineObject>> PIPELINE_OBJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pipelineObjects").getter(GetPipelineDefinitionResponse.getter(GetPipelineDefinitionResponse::pipelineObjects)).setter(GetPipelineDefinitionResponse.setter(Builder::pipelineObjects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineObjects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ParameterObject>> PARAMETER_OBJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameterObjects").getter(GetPipelineDefinitionResponse.getter(GetPipelineDefinitionResponse::parameterObjects)).setter(GetPipelineDefinitionResponse.setter(Builder::parameterObjects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterObjects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ParameterValue>> PARAMETER_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameterValues").getter(GetPipelineDefinitionResponse.getter(GetPipelineDefinitionResponse::parameterValues)).setter(GetPipelineDefinitionResponse.setter(Builder::parameterValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_OBJECTS_FIELD, PARAMETER_OBJECTS_FIELD, PARAMETER_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPipelineDefinitionResponse.memberNameToFieldInitializer();
    private final List<PipelineObject> pipelineObjects;
    private final List<ParameterObject> parameterObjects;
    private final List<ParameterValue> parameterValues;

    private GetPipelineDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineObjects = builder.pipelineObjects;
        this.parameterObjects = builder.parameterObjects;
        this.parameterValues = builder.parameterValues;
    }

    public final boolean hasPipelineObjects() {
        return this.pipelineObjects != null && !(this.pipelineObjects instanceof SdkAutoConstructList);
    }

    public final List<PipelineObject> pipelineObjects() {
        return this.pipelineObjects;
    }

    public final boolean hasParameterObjects() {
        return this.parameterObjects != null && !(this.parameterObjects instanceof SdkAutoConstructList);
    }

    public final List<ParameterObject> parameterObjects() {
        return this.parameterObjects;
    }

    public final boolean hasParameterValues() {
        return this.parameterValues != null && !(this.parameterValues instanceof SdkAutoConstructList);
    }

    public final List<ParameterValue> parameterValues() {
        return this.parameterValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipelineObjects() ? this.pipelineObjects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterObjects() ? this.parameterObjects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterValues() ? this.parameterValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineDefinitionResponse)) {
            return false;
        }
        GetPipelineDefinitionResponse other = (GetPipelineDefinitionResponse)((Object)obj);
        return this.hasPipelineObjects() == other.hasPipelineObjects() && Objects.equals(this.pipelineObjects(), other.pipelineObjects()) && this.hasParameterObjects() == other.hasParameterObjects() && Objects.equals(this.parameterObjects(), other.parameterObjects()) && this.hasParameterValues() == other.hasParameterValues() && Objects.equals(this.parameterValues(), other.parameterValues());
    }

    public final String toString() {
        return ToString.builder((String)"GetPipelineDefinitionResponse").add("PipelineObjects", this.hasPipelineObjects() ? this.pipelineObjects() : null).add("ParameterObjects", this.hasParameterObjects() ? this.parameterObjects() : null).add("ParameterValues", this.hasParameterValues() ? this.parameterValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineObjects": {
                return Optional.ofNullable(clazz.cast(this.pipelineObjects()));
            }
            case "parameterObjects": {
                return Optional.ofNullable(clazz.cast(this.parameterObjects()));
            }
            case "parameterValues": {
                return Optional.ofNullable(clazz.cast(this.parameterValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pipelineObjects", PIPELINE_OBJECTS_FIELD);
        map.put("parameterObjects", PARAMETER_OBJECTS_FIELD);
        map.put("parameterValues", PARAMETER_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPipelineDefinitionResponse, T> g) {
        return obj -> g.apply((GetPipelineDefinitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataPipelineResponse.BuilderImpl
    implements Builder {
        private List<PipelineObject> pipelineObjects = DefaultSdkAutoConstructList.getInstance();
        private List<ParameterObject> parameterObjects = DefaultSdkAutoConstructList.getInstance();
        private List<ParameterValue> parameterValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPipelineDefinitionResponse model) {
            super(model);
            this.pipelineObjects(model.pipelineObjects);
            this.parameterObjects(model.parameterObjects);
            this.parameterValues(model.parameterValues);
        }

        public final List<PipelineObject.Builder> getPipelineObjects() {
            List<PipelineObject.Builder> result = PipelineObjectListCopier.copyToBuilder(this.pipelineObjects);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelineObjects(Collection<PipelineObject.BuilderImpl> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copyFromBuilder(pipelineObjects);
        }

        @Override
        public final Builder pipelineObjects(Collection<PipelineObject> pipelineObjects) {
            this.pipelineObjects = PipelineObjectListCopier.copy(pipelineObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineObjects(PipelineObject ... pipelineObjects) {
            this.pipelineObjects(Arrays.asList(pipelineObjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineObjects(Consumer<PipelineObject.Builder> ... pipelineObjects) {
            this.pipelineObjects(Stream.of(pipelineObjects).map(c -> (PipelineObject)((PipelineObject.Builder)PipelineObject.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ParameterObject.Builder> getParameterObjects() {
            List<ParameterObject.Builder> result = ParameterObjectListCopier.copyToBuilder(this.parameterObjects);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterObjects(Collection<ParameterObject.BuilderImpl> parameterObjects) {
            this.parameterObjects = ParameterObjectListCopier.copyFromBuilder(parameterObjects);
        }

        @Override
        public final Builder parameterObjects(Collection<ParameterObject> parameterObjects) {
            this.parameterObjects = ParameterObjectListCopier.copy(parameterObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterObjects(ParameterObject ... parameterObjects) {
            this.parameterObjects(Arrays.asList(parameterObjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterObjects(Consumer<ParameterObject.Builder> ... parameterObjects) {
            this.parameterObjects(Stream.of(parameterObjects).map(c -> (ParameterObject)((ParameterObject.Builder)ParameterObject.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ParameterValue.Builder> getParameterValues() {
            List<ParameterValue.Builder> result = ParameterValueListCopier.copyToBuilder(this.parameterValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterValues(Collection<ParameterValue.BuilderImpl> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copyFromBuilder(parameterValues);
        }

        @Override
        public final Builder parameterValues(Collection<ParameterValue> parameterValues) {
            this.parameterValues = ParameterValueListCopier.copy(parameterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterValues(ParameterValue ... parameterValues) {
            this.parameterValues(Arrays.asList(parameterValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterValues(Consumer<ParameterValue.Builder> ... parameterValues) {
            this.parameterValues(Stream.of(parameterValues).map(c -> (ParameterValue)((ParameterValue.Builder)ParameterValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetPipelineDefinitionResponse build() {
            return new GetPipelineDefinitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataPipelineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPipelineDefinitionResponse> {
        public Builder pipelineObjects(Collection<PipelineObject> var1);

        public Builder pipelineObjects(PipelineObject ... var1);

        public Builder pipelineObjects(Consumer<PipelineObject.Builder> ... var1);

        public Builder parameterObjects(Collection<ParameterObject> var1);

        public Builder parameterObjects(ParameterObject ... var1);

        public Builder parameterObjects(Consumer<ParameterObject.Builder> ... var1);

        public Builder parameterValues(Collection<ParameterValue> var1);

        public Builder parameterValues(ParameterValue ... var1);

        public Builder parameterValues(Consumer<ParameterValue.Builder> ... var1);
    }
}

