/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for SetTaskStatus.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetTaskStatusRequest extends DataPipelineRequest implements
        ToCopyableBuilder<SetTaskStatusRequest.Builder, SetTaskStatusRequest> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(SetTaskStatusRequest::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskStatus").getter(getter(SetTaskStatusRequest::taskStatusAsString))
            .setter(setter(Builder::taskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStatus").build()).build();

    private static final SdkField<String> ERROR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorId").getter(getter(SetTaskStatusRequest::errorId)).setter(setter(Builder::errorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorId").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(SetTaskStatusRequest::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> ERROR_STACK_TRACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorStackTrace").getter(getter(SetTaskStatusRequest::errorStackTrace))
            .setter(setter(Builder::errorStackTrace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorStackTrace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD,
            TASK_STATUS_FIELD, ERROR_ID_FIELD, ERROR_MESSAGE_FIELD, ERROR_STACK_TRACE_FIELD));

    private final String taskId;

    private final String taskStatus;

    private final String errorId;

    private final String errorMessage;

    private final String errorStackTrace;

    private SetTaskStatusRequest(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.taskStatus = builder.taskStatus;
        this.errorId = builder.errorId;
        this.errorMessage = builder.errorMessage;
        this.errorStackTrace = builder.errorStackTrace;
    }

    /**
     * <p>
     * The ID of the task assigned to the task runner. This value is provided in the response for <a>PollForTask</a>.
     * </p>
     * 
     * @return The ID of the task assigned to the task runner. This value is provided in the response for
     *         <a>PollForTask</a>.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * If <code>FINISHED</code>, the task successfully completed. If <code>FAILED</code>, the task ended unsuccessfully.
     * Preconditions use false.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link TaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return If <code>FINISHED</code>, the task successfully completed. If <code>FAILED</code>, the task ended
     *         unsuccessfully. Preconditions use false.
     * @see TaskStatus
     */
    public final TaskStatus taskStatus() {
        return TaskStatus.fromValue(taskStatus);
    }

    /**
     * <p>
     * If <code>FINISHED</code>, the task successfully completed. If <code>FAILED</code>, the task ended unsuccessfully.
     * Preconditions use false.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link TaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return If <code>FINISHED</code>, the task successfully completed. If <code>FAILED</code>, the task ended
     *         unsuccessfully. Preconditions use false.
     * @see TaskStatus
     */
    public final String taskStatusAsString() {
        return taskStatus;
    }

    /**
     * <p>
     * If an error occurred during the task, this value specifies the error code. This value is set on the physical
     * attempt object. It is used to display error information to the user. It should not start with string "Service_"
     * which is reserved by the system.
     * </p>
     * 
     * @return If an error occurred during the task, this value specifies the error code. This value is set on the
     *         physical attempt object. It is used to display error information to the user. It should not start with
     *         string "Service_" which is reserved by the system.
     */
    public final String errorId() {
        return errorId;
    }

    /**
     * <p>
     * If an error occurred during the task, this value specifies a text description of the error. This value is set on
     * the physical attempt object. It is used to display error information to the user. The web service does not parse
     * this value.
     * </p>
     * 
     * @return If an error occurred during the task, this value specifies a text description of the error. This value is
     *         set on the physical attempt object. It is used to display error information to the user. The web service
     *         does not parse this value.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * If an error occurred during the task, this value specifies the stack trace associated with the error. This value
     * is set on the physical attempt object. It is used to display error information to the user. The web service does
     * not parse this value.
     * </p>
     * 
     * @return If an error occurred during the task, this value specifies the stack trace associated with the error.
     *         This value is set on the physical attempt object. It is used to display error information to the user.
     *         The web service does not parse this value.
     */
    public final String errorStackTrace() {
        return errorStackTrace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorId());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(errorStackTrace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetTaskStatusRequest)) {
            return false;
        }
        SetTaskStatusRequest other = (SetTaskStatusRequest) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(taskStatusAsString(), other.taskStatusAsString())
                && Objects.equals(errorId(), other.errorId()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(errorStackTrace(), other.errorStackTrace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetTaskStatusRequest").add("TaskId", taskId()).add("TaskStatus", taskStatusAsString())
                .add("ErrorId", errorId()).add("ErrorMessage", errorMessage()).add("ErrorStackTrace", errorStackTrace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "taskStatus":
            return Optional.ofNullable(clazz.cast(taskStatusAsString()));
        case "errorId":
            return Optional.ofNullable(clazz.cast(errorId()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "errorStackTrace":
            return Optional.ofNullable(clazz.cast(errorStackTrace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetTaskStatusRequest, T> g) {
        return obj -> g.apply((SetTaskStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataPipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetTaskStatusRequest> {
        /**
         * <p>
         * The ID of the task assigned to the task runner. This value is provided in the response for
         * <a>PollForTask</a>.
         * </p>
         * 
         * @param taskId
         *        The ID of the task assigned to the task runner. This value is provided in the response for
         *        <a>PollForTask</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * If <code>FINISHED</code>, the task successfully completed. If <code>FAILED</code>, the task ended
         * unsuccessfully. Preconditions use false.
         * </p>
         * 
         * @param taskStatus
         *        If <code>FINISHED</code>, the task successfully completed. If <code>FAILED</code>, the task ended
         *        unsuccessfully. Preconditions use false.
         * @see TaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatus
         */
        Builder taskStatus(String taskStatus);

        /**
         * <p>
         * If <code>FINISHED</code>, the task successfully completed. If <code>FAILED</code>, the task ended
         * unsuccessfully. Preconditions use false.
         * </p>
         * 
         * @param taskStatus
         *        If <code>FINISHED</code>, the task successfully completed. If <code>FAILED</code>, the task ended
         *        unsuccessfully. Preconditions use false.
         * @see TaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatus
         */
        Builder taskStatus(TaskStatus taskStatus);

        /**
         * <p>
         * If an error occurred during the task, this value specifies the error code. This value is set on the physical
         * attempt object. It is used to display error information to the user. It should not start with string
         * "Service_" which is reserved by the system.
         * </p>
         * 
         * @param errorId
         *        If an error occurred during the task, this value specifies the error code. This value is set on the
         *        physical attempt object. It is used to display error information to the user. It should not start with
         *        string "Service_" which is reserved by the system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorId(String errorId);

        /**
         * <p>
         * If an error occurred during the task, this value specifies a text description of the error. This value is set
         * on the physical attempt object. It is used to display error information to the user. The web service does not
         * parse this value.
         * </p>
         * 
         * @param errorMessage
         *        If an error occurred during the task, this value specifies a text description of the error. This value
         *        is set on the physical attempt object. It is used to display error information to the user. The web
         *        service does not parse this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * If an error occurred during the task, this value specifies the stack trace associated with the error. This
         * value is set on the physical attempt object. It is used to display error information to the user. The web
         * service does not parse this value.
         * </p>
         * 
         * @param errorStackTrace
         *        If an error occurred during the task, this value specifies the stack trace associated with the error.
         *        This value is set on the physical attempt object. It is used to display error information to the user.
         *        The web service does not parse this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorStackTrace(String errorStackTrace);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataPipelineRequest.BuilderImpl implements Builder {
        private String taskId;

        private String taskStatus;

        private String errorId;

        private String errorMessage;

        private String errorStackTrace;

        private BuilderImpl() {
        }

        private BuilderImpl(SetTaskStatusRequest model) {
            super(model);
            taskId(model.taskId);
            taskStatus(model.taskStatus);
            errorId(model.errorId);
            errorMessage(model.errorMessage);
            errorStackTrace(model.errorStackTrace);
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getTaskStatus() {
            return taskStatus;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(TaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final String getErrorId() {
            return errorId;
        }

        public final void setErrorId(String errorId) {
            this.errorId = errorId;
        }

        @Override
        public final Builder errorId(String errorId) {
            this.errorId = errorId;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getErrorStackTrace() {
            return errorStackTrace;
        }

        public final void setErrorStackTrace(String errorStackTrace) {
            this.errorStackTrace = errorStackTrace;
        }

        @Override
        public final Builder errorStackTrace(String errorStackTrace) {
            this.errorStackTrace = errorStackTrace;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetTaskStatusRequest build() {
            return new SetTaskStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
