/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPipelineDefinitionRequest
extends DataPipelineRequest
implements ToCopyableBuilder<Builder, GetPipelineDefinitionRequest> {
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineId").getter(GetPipelineDefinitionRequest.getter(GetPipelineDefinitionRequest::pipelineId)).setter(GetPipelineDefinitionRequest.setter(Builder::pipelineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineId").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(GetPipelineDefinitionRequest.getter(GetPipelineDefinitionRequest::version)).setter(GetPipelineDefinitionRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ID_FIELD, VERSION_FIELD));
    private final String pipelineId;
    private final String version;

    private GetPipelineDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineId = builder.pipelineId;
        this.version = builder.version;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public String version() {
        return this.version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineDefinitionRequest)) {
            return false;
        }
        GetPipelineDefinitionRequest other = (GetPipelineDefinitionRequest)((Object)obj);
        return Objects.equals(this.pipelineId(), other.pipelineId()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        return ToString.builder((String)"GetPipelineDefinitionRequest").add("PipelineId", (Object)this.pipelineId()).add("Version", (Object)this.version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineId": {
                return Optional.ofNullable(clazz.cast(this.pipelineId()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPipelineDefinitionRequest, T> g) {
        return obj -> g.apply((GetPipelineDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataPipelineRequest.BuilderImpl
    implements Builder {
        private String pipelineId;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPipelineDefinitionRequest model) {
            super(model);
            this.pipelineId(model.pipelineId);
            this.version(model.version);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPipelineDefinitionRequest build() {
            return new GetPipelineDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataPipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPipelineDefinitionRequest> {
        public Builder pipelineId(String var1);

        public Builder version(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

