/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datapipeline.model.Operator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Selector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Selector> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldName").getter(Selector.getter(Selector::fieldName)).setter(Selector.setter(Builder::fieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldName").build()}).build();
    private static final SdkField<Operator> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("operator").getter(Selector.getter(Selector::operator)).setter(Selector.setter(Builder::operator)).constructor(Operator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD, OPERATOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fieldName;
    private final Operator operator;

    private Selector(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.operator = builder.operator;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Operator operator() {
        return this.operator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operator());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Selector)) {
            return false;
        }
        Selector other = (Selector)obj;
        return Objects.equals(this.fieldName(), other.fieldName()) && Objects.equals(this.operator(), other.operator());
    }

    public String toString() {
        return ToString.builder((String)"Selector").add("FieldName", (Object)this.fieldName()).add("Operator", (Object)this.operator()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fieldName": {
                return Optional.ofNullable(clazz.cast(this.fieldName()));
            }
            case "operator": {
                return Optional.ofNullable(clazz.cast(this.operator()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Selector, T> g) {
        return obj -> g.apply((Selector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldName;
        private Operator operator;

        private BuilderImpl() {
        }

        private BuilderImpl(Selector model) {
            this.fieldName(model.fieldName);
            this.operator(model.operator);
        }

        public final String getFieldName() {
            return this.fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public final Operator.Builder getOperator() {
            return this.operator != null ? this.operator.toBuilder() : null;
        }

        @Override
        public final Builder operator(Operator operator) {
            this.operator = operator;
            return this;
        }

        public final void setOperator(Operator.BuilderImpl operator) {
            this.operator = operator != null ? operator.build() : null;
        }

        public Selector build() {
            return new Selector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Selector> {
        public Builder fieldName(String var1);

        public Builder operator(Operator var1);

        default public Builder operator(Consumer<Operator.Builder> operator) {
            return this.operator((Operator)((Operator.Builder)Operator.builder().applyMutation(operator)).build());
        }
    }
}

