/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.datapipeline.model.Field;

@SdkInternalApi
public class FieldMarshaller {
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("key").build();
    private static final MarshallingInfo<String> STRINGVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stringValue").build();
    private static final MarshallingInfo<String> REFVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("refValue").build();
    private static final FieldMarshaller instance = new FieldMarshaller();

    public static FieldMarshaller getInstance() {
        return instance;
    }

    public void marshall(Field field, ProtocolMarshaller protocolMarshaller) {
        if (field == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)field.key(), KEY_BINDING);
            protocolMarshaller.marshall((Object)field.stringValue(), STRINGVALUE_BINDING);
            protocolMarshaller.marshall((Object)field.refValue(), REFVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

