/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.datapipeline.model.Field;
import software.amazon.awssdk.services.datapipeline.model._fieldListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReportTaskProgressRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ReportTaskProgressRequest> {
    private final String taskId;
    private final List<Field> fields;

    private ReportTaskProgressRequest(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.fields = builder.fields;
    }

    public String taskId() {
        return this.taskId;
    }

    public List<Field> fields() {
        return this.fields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.taskId() == null ? 0 : this.taskId().hashCode());
        hashCode = 31 * hashCode + (this.fields() == null ? 0 : this.fields().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportTaskProgressRequest)) {
            return false;
        }
        ReportTaskProgressRequest other = (ReportTaskProgressRequest)((Object)obj);
        if (other.taskId() == null ^ this.taskId() == null) {
            return false;
        }
        if (other.taskId() != null && !other.taskId().equals(this.taskId())) {
            return false;
        }
        if (other.fields() == null ^ this.fields() == null) {
            return false;
        }
        return other.fields() == null || other.fields().equals(this.fields());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.taskId() != null) {
            sb.append("TaskId: ").append(this.taskId()).append(",");
        }
        if (this.fields() != null) {
            sb.append("Fields: ").append(this.fields()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String taskId;
        private List<Field> fields;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportTaskProgressRequest model) {
            this.setTaskId(model.taskId);
            this.setFields(model.fields);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final Collection<Field> getFields() {
            return this.fields;
        }

        @Override
        public final Builder fields(Collection<Field> fields) {
            this.fields = _fieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Field ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        public final void setFields(Collection<Field> fields) {
            this.fields = _fieldListCopier.copy(fields);
        }

        @SafeVarargs
        public final void setFields(Field ... fields) {
            this.fields(Arrays.asList(fields));
        }

        public ReportTaskProgressRequest build() {
            return new ReportTaskProgressRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReportTaskProgressRequest> {
        public Builder taskId(String var1);

        public Builder fields(Collection<Field> var1);

        public Builder fields(Field ... var1);
    }
}

