/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.datapipeline.model.Selector;
import software.amazon.awssdk.services.datapipeline.model.SelectorListCopier;
import software.amazon.awssdk.services.datapipeline.transform.QueryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Query
implements StructuredPojo,
ToCopyableBuilder<Builder, Query> {
    private final List<Selector> selectors;

    private Query(BuilderImpl builder) {
        this.selectors = builder.selectors;
    }

    public List<Selector> selectors() {
        return this.selectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.selectors() == null ? 0 : this.selectors().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Query)) {
            return false;
        }
        Query other = (Query)obj;
        if (other.selectors() == null ^ this.selectors() == null) {
            return false;
        }
        return other.selectors() == null || other.selectors().equals(this.selectors());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.selectors() != null) {
            sb.append("Selectors: ").append(this.selectors()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QueryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Selector> selectors;

        private BuilderImpl() {
        }

        private BuilderImpl(Query model) {
            this.setSelectors(model.selectors);
        }

        public final Collection<Selector> getSelectors() {
            return this.selectors;
        }

        @Override
        public final Builder selectors(Collection<Selector> selectors) {
            this.selectors = SelectorListCopier.copy(selectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectors(Selector ... selectors) {
            this.selectors(Arrays.asList(selectors));
            return this;
        }

        public final void setSelectors(Collection<Selector> selectors) {
            this.selectors = SelectorListCopier.copy(selectors);
        }

        @SafeVarargs
        public final void setSelectors(Selector ... selectors) {
            this.selectors(Arrays.asList(selectors));
        }

        public Query build() {
            return new Query(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Query> {
        public Builder selectors(Collection<Selector> var1);

        public Builder selectors(Selector ... var1);
    }
}

