/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dataexchange.model.AssetType;
import software.amazon.awssdk.services.dataexchange.model.Origin;
import software.amazon.awssdk.services.dataexchange.model.OriginDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSetEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSetEntry> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DataSetEntry.getter(DataSetEntry::arn)).setter(DataSetEntry.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ASSET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssetType").getter(DataSetEntry.getter(DataSetEntry::assetTypeAsString)).setter(DataSetEntry.setter(Builder::assetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetType").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DataSetEntry.getter(DataSetEntry::createdAt)).setter(DataSetEntry.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DataSetEntry.getter(DataSetEntry::description)).setter(DataSetEntry.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DataSetEntry.getter(DataSetEntry::id)).setter(DataSetEntry.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DataSetEntry.getter(DataSetEntry::name)).setter(DataSetEntry.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Origin").getter(DataSetEntry.getter(DataSetEntry::originAsString)).setter(DataSetEntry.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build()}).build();
    private static final SdkField<OriginDetails> ORIGIN_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginDetails").getter(DataSetEntry.getter(DataSetEntry::originDetails)).setter(DataSetEntry.setter(Builder::originDetails)).constructor(OriginDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginDetails").build()}).build();
    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceId").getter(DataSetEntry.getter(DataSetEntry::sourceId)).setter(DataSetEntry.setter(Builder::sourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(DataSetEntry.getter(DataSetEntry::updatedAt)).setter(DataSetEntry.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ASSET_TYPE_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD, ORIGIN_FIELD, ORIGIN_DETAILS_FIELD, SOURCE_ID_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSetEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String assetType;
    private final Instant createdAt;
    private final String description;
    private final String id;
    private final String name;
    private final String origin;
    private final OriginDetails originDetails;
    private final String sourceId;
    private final Instant updatedAt;

    private DataSetEntry(BuilderImpl builder) {
        this.arn = builder.arn;
        this.assetType = builder.assetType;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.origin = builder.origin;
        this.originDetails = builder.originDetails;
        this.sourceId = builder.sourceId;
        this.updatedAt = builder.updatedAt;
    }

    public final String arn() {
        return this.arn;
    }

    public final AssetType assetType() {
        return AssetType.fromValue(this.assetType);
    }

    public final String assetTypeAsString() {
        return this.assetType;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final Origin origin() {
        return Origin.fromValue(this.origin);
    }

    public final String originAsString() {
        return this.origin;
    }

    public final OriginDetails originDetails() {
        return this.originDetails;
    }

    public final String sourceId() {
        return this.sourceId;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.originDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetEntry)) {
            return false;
        }
        DataSetEntry other = (DataSetEntry)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.assetTypeAsString(), other.assetTypeAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.originAsString(), other.originAsString()) && Objects.equals(this.originDetails(), other.originDetails()) && Objects.equals(this.sourceId(), other.sourceId()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"DataSetEntry").add("Arn", (Object)this.arn()).add("AssetType", (Object)this.assetTypeAsString()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Origin", (Object)this.originAsString()).add("OriginDetails", (Object)this.originDetails()).add("SourceId", (Object)this.sourceId()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AssetType": {
                return Optional.ofNullable(clazz.cast(this.assetTypeAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Origin": {
                return Optional.ofNullable(clazz.cast(this.originAsString()));
            }
            case "OriginDetails": {
                return Optional.ofNullable(clazz.cast(this.originDetails()));
            }
            case "SourceId": {
                return Optional.ofNullable(clazz.cast(this.sourceId()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("AssetType", ASSET_TYPE_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Origin", ORIGIN_FIELD);
        map.put("OriginDetails", ORIGIN_DETAILS_FIELD);
        map.put("SourceId", SOURCE_ID_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSetEntry, T> g) {
        return obj -> g.apply((DataSetEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String assetType;
        private Instant createdAt;
        private String description;
        private String id;
        private String name;
        private String origin;
        private OriginDetails originDetails;
        private String sourceId;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetEntry model) {
            this.arn(model.arn);
            this.assetType(model.assetType);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.id(model.id);
            this.name(model.name);
            this.origin(model.origin);
            this.originDetails(model.originDetails);
            this.sourceId(model.sourceId);
            this.updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAssetType() {
            return this.assetType;
        }

        public final void setAssetType(String assetType) {
            this.assetType = assetType;
        }

        @Override
        public final Builder assetType(String assetType) {
            this.assetType = assetType;
            return this;
        }

        @Override
        public final Builder assetType(AssetType assetType) {
            this.assetType(assetType == null ? null : assetType.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOrigin() {
            return this.origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(Origin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final OriginDetails.Builder getOriginDetails() {
            return this.originDetails != null ? this.originDetails.toBuilder() : null;
        }

        public final void setOriginDetails(OriginDetails.BuilderImpl originDetails) {
            this.originDetails = originDetails != null ? originDetails.build() : null;
        }

        @Override
        public final Builder originDetails(OriginDetails originDetails) {
            this.originDetails = originDetails;
            return this;
        }

        public final String getSourceId() {
            return this.sourceId;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public DataSetEntry build() {
            return new DataSetEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSetEntry> {
        public Builder arn(String var1);

        public Builder assetType(String var1);

        public Builder assetType(AssetType var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder origin(String var1);

        public Builder origin(Origin var1);

        public Builder originDetails(OriginDetails var1);

        default public Builder originDetails(Consumer<OriginDetails.Builder> originDetails) {
            return this.originDetails((OriginDetails)((OriginDetails.Builder)OriginDetails.builder().applyMutation(originDetails)).build());
        }

        public Builder sourceId(String var1);

        public Builder updatedAt(Instant var1);
    }
}

