/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dataexchange.model.DataGrantAcceptanceState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataGrantSummaryEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataGrantSummaryEntry> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DataGrantSummaryEntry.getter(DataGrantSummaryEntry::name)).setter(DataGrantSummaryEntry.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SENDER_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SenderPrincipal").getter(DataGrantSummaryEntry.getter(DataGrantSummaryEntry::senderPrincipal)).setter(DataGrantSummaryEntry.setter(Builder::senderPrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderPrincipal").build()}).build();
    private static final SdkField<String> RECEIVER_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReceiverPrincipal").getter(DataGrantSummaryEntry.getter(DataGrantSummaryEntry::receiverPrincipal)).setter(DataGrantSummaryEntry.setter(Builder::receiverPrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiverPrincipal").build()}).build();
    private static final SdkField<String> ACCEPTANCE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptanceState").getter(DataGrantSummaryEntry.getter(DataGrantSummaryEntry::acceptanceStateAsString)).setter(DataGrantSummaryEntry.setter(Builder::acceptanceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceState").build()}).build();
    private static final SdkField<Instant> ACCEPTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AcceptedAt").getter(DataGrantSummaryEntry.getter(DataGrantSummaryEntry::acceptedAt)).setter(DataGrantSummaryEntry.setter(Builder::acceptedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ENDS_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndsAt").getter(DataGrantSummaryEntry.getter(DataGrantSummaryEntry::endsAt)).setter(DataGrantSummaryEntry.setter(Builder::endsAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndsAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetId").getter(DataGrantSummaryEntry.getter(DataGrantSummaryEntry::dataSetId)).setter(DataGrantSummaryEntry.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()}).build();
    private static final SdkField<String> SOURCE_DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDataSetId").getter(DataGrantSummaryEntry.getter(DataGrantSummaryEntry::sourceDataSetId)).setter(DataGrantSummaryEntry.setter(Builder::sourceDataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDataSetId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DataGrantSummaryEntry.getter(DataGrantSummaryEntry::id)).setter(DataGrantSummaryEntry.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DataGrantSummaryEntry.getter(DataGrantSummaryEntry::arn)).setter(DataGrantSummaryEntry.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DataGrantSummaryEntry.getter(DataGrantSummaryEntry::createdAt)).setter(DataGrantSummaryEntry.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(DataGrantSummaryEntry.getter(DataGrantSummaryEntry::updatedAt)).setter(DataGrantSummaryEntry.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SENDER_PRINCIPAL_FIELD, RECEIVER_PRINCIPAL_FIELD, ACCEPTANCE_STATE_FIELD, ACCEPTED_AT_FIELD, ENDS_AT_FIELD, DATA_SET_ID_FIELD, SOURCE_DATA_SET_ID_FIELD, ID_FIELD, ARN_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String senderPrincipal;
    private final String receiverPrincipal;
    private final String acceptanceState;
    private final Instant acceptedAt;
    private final Instant endsAt;
    private final String dataSetId;
    private final String sourceDataSetId;
    private final String id;
    private final String arn;
    private final Instant createdAt;
    private final Instant updatedAt;

    private DataGrantSummaryEntry(BuilderImpl builder) {
        this.name = builder.name;
        this.senderPrincipal = builder.senderPrincipal;
        this.receiverPrincipal = builder.receiverPrincipal;
        this.acceptanceState = builder.acceptanceState;
        this.acceptedAt = builder.acceptedAt;
        this.endsAt = builder.endsAt;
        this.dataSetId = builder.dataSetId;
        this.sourceDataSetId = builder.sourceDataSetId;
        this.id = builder.id;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String name() {
        return this.name;
    }

    public final String senderPrincipal() {
        return this.senderPrincipal;
    }

    public final String receiverPrincipal() {
        return this.receiverPrincipal;
    }

    public final DataGrantAcceptanceState acceptanceState() {
        return DataGrantAcceptanceState.fromValue(this.acceptanceState);
    }

    public final String acceptanceStateAsString() {
        return this.acceptanceState;
    }

    public final Instant acceptedAt() {
        return this.acceptedAt;
    }

    public final Instant endsAt() {
        return this.endsAt;
    }

    public final String dataSetId() {
        return this.dataSetId;
    }

    public final String sourceDataSetId() {
        return this.sourceDataSetId;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderPrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiverPrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endsAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataGrantSummaryEntry)) {
            return false;
        }
        DataGrantSummaryEntry other = (DataGrantSummaryEntry)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.senderPrincipal(), other.senderPrincipal()) && Objects.equals(this.receiverPrincipal(), other.receiverPrincipal()) && Objects.equals(this.acceptanceStateAsString(), other.acceptanceStateAsString()) && Objects.equals(this.acceptedAt(), other.acceptedAt()) && Objects.equals(this.endsAt(), other.endsAt()) && Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.sourceDataSetId(), other.sourceDataSetId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"DataGrantSummaryEntry").add("Name", (Object)this.name()).add("SenderPrincipal", (Object)this.senderPrincipal()).add("ReceiverPrincipal", (Object)this.receiverPrincipal()).add("AcceptanceState", (Object)this.acceptanceStateAsString()).add("AcceptedAt", (Object)this.acceptedAt()).add("EndsAt", (Object)this.endsAt()).add("DataSetId", (Object)this.dataSetId()).add("SourceDataSetId", (Object)this.sourceDataSetId()).add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SenderPrincipal": {
                return Optional.ofNullable(clazz.cast(this.senderPrincipal()));
            }
            case "ReceiverPrincipal": {
                return Optional.ofNullable(clazz.cast(this.receiverPrincipal()));
            }
            case "AcceptanceState": {
                return Optional.ofNullable(clazz.cast(this.acceptanceStateAsString()));
            }
            case "AcceptedAt": {
                return Optional.ofNullable(clazz.cast(this.acceptedAt()));
            }
            case "EndsAt": {
                return Optional.ofNullable(clazz.cast(this.endsAt()));
            }
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "SourceDataSetId": {
                return Optional.ofNullable(clazz.cast(this.sourceDataSetId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataGrantSummaryEntry, T> g) {
        return obj -> g.apply((DataGrantSummaryEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String senderPrincipal;
        private String receiverPrincipal;
        private String acceptanceState;
        private Instant acceptedAt;
        private Instant endsAt;
        private String dataSetId;
        private String sourceDataSetId;
        private String id;
        private String arn;
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DataGrantSummaryEntry model) {
            this.name(model.name);
            this.senderPrincipal(model.senderPrincipal);
            this.receiverPrincipal(model.receiverPrincipal);
            this.acceptanceState(model.acceptanceState);
            this.acceptedAt(model.acceptedAt);
            this.endsAt(model.endsAt);
            this.dataSetId(model.dataSetId);
            this.sourceDataSetId(model.sourceDataSetId);
            this.id(model.id);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSenderPrincipal() {
            return this.senderPrincipal;
        }

        public final void setSenderPrincipal(String senderPrincipal) {
            this.senderPrincipal = senderPrincipal;
        }

        @Override
        public final Builder senderPrincipal(String senderPrincipal) {
            this.senderPrincipal = senderPrincipal;
            return this;
        }

        public final String getReceiverPrincipal() {
            return this.receiverPrincipal;
        }

        public final void setReceiverPrincipal(String receiverPrincipal) {
            this.receiverPrincipal = receiverPrincipal;
        }

        @Override
        public final Builder receiverPrincipal(String receiverPrincipal) {
            this.receiverPrincipal = receiverPrincipal;
            return this;
        }

        public final String getAcceptanceState() {
            return this.acceptanceState;
        }

        public final void setAcceptanceState(String acceptanceState) {
            this.acceptanceState = acceptanceState;
        }

        @Override
        public final Builder acceptanceState(String acceptanceState) {
            this.acceptanceState = acceptanceState;
            return this;
        }

        @Override
        public final Builder acceptanceState(DataGrantAcceptanceState acceptanceState) {
            this.acceptanceState(acceptanceState == null ? null : acceptanceState.toString());
            return this;
        }

        public final Instant getAcceptedAt() {
            return this.acceptedAt;
        }

        public final void setAcceptedAt(Instant acceptedAt) {
            this.acceptedAt = acceptedAt;
        }

        @Override
        public final Builder acceptedAt(Instant acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        public final Instant getEndsAt() {
            return this.endsAt;
        }

        public final void setEndsAt(Instant endsAt) {
            this.endsAt = endsAt;
        }

        @Override
        public final Builder endsAt(Instant endsAt) {
            this.endsAt = endsAt;
            return this;
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getSourceDataSetId() {
            return this.sourceDataSetId;
        }

        public final void setSourceDataSetId(String sourceDataSetId) {
            this.sourceDataSetId = sourceDataSetId;
        }

        @Override
        public final Builder sourceDataSetId(String sourceDataSetId) {
            this.sourceDataSetId = sourceDataSetId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public DataGrantSummaryEntry build() {
            return new DataGrantSummaryEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataGrantSummaryEntry> {
        public Builder name(String var1);

        public Builder senderPrincipal(String var1);

        public Builder receiverPrincipal(String var1);

        public Builder acceptanceState(String var1);

        public Builder acceptanceState(DataGrantAcceptanceState var1);

        public Builder acceptedAt(Instant var1);

        public Builder endsAt(Instant var1);

        public Builder dataSetId(String var1);

        public Builder sourceDataSetId(String var1);

        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

