/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dataexchange.model.ListOfRedshiftDataShareAssetSourceEntryCopier;
import software.amazon.awssdk.services.dataexchange.model.RedshiftDataShareAssetSourceEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportAssetsFromRedshiftDataSharesResponseDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportAssetsFromRedshiftDataSharesResponseDetails> {
    private static final SdkField<List<RedshiftDataShareAssetSourceEntry>> ASSET_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssetSources").getter(ImportAssetsFromRedshiftDataSharesResponseDetails.getter(ImportAssetsFromRedshiftDataSharesResponseDetails::assetSources)).setter(ImportAssetsFromRedshiftDataSharesResponseDetails.setter(Builder::assetSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RedshiftDataShareAssetSourceEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetId").getter(ImportAssetsFromRedshiftDataSharesResponseDetails.getter(ImportAssetsFromRedshiftDataSharesResponseDetails::dataSetId)).setter(ImportAssetsFromRedshiftDataSharesResponseDetails.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RevisionId").getter(ImportAssetsFromRedshiftDataSharesResponseDetails.getter(ImportAssetsFromRedshiftDataSharesResponseDetails::revisionId)).setter(ImportAssetsFromRedshiftDataSharesResponseDetails.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_SOURCES_FIELD, DATA_SET_ID_FIELD, REVISION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportAssetsFromRedshiftDataSharesResponseDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<RedshiftDataShareAssetSourceEntry> assetSources;
    private final String dataSetId;
    private final String revisionId;

    private ImportAssetsFromRedshiftDataSharesResponseDetails(BuilderImpl builder) {
        this.assetSources = builder.assetSources;
        this.dataSetId = builder.dataSetId;
        this.revisionId = builder.revisionId;
    }

    public final boolean hasAssetSources() {
        return this.assetSources != null && !(this.assetSources instanceof SdkAutoConstructList);
    }

    public final List<RedshiftDataShareAssetSourceEntry> assetSources() {
        return this.assetSources;
    }

    public final String dataSetId() {
        return this.dataSetId;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetSources() ? this.assetSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportAssetsFromRedshiftDataSharesResponseDetails)) {
            return false;
        }
        ImportAssetsFromRedshiftDataSharesResponseDetails other = (ImportAssetsFromRedshiftDataSharesResponseDetails)obj;
        return this.hasAssetSources() == other.hasAssetSources() && Objects.equals(this.assetSources(), other.assetSources()) && Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.revisionId(), other.revisionId());
    }

    public final String toString() {
        return ToString.builder((String)"ImportAssetsFromRedshiftDataSharesResponseDetails").add("AssetSources", this.hasAssetSources() ? this.assetSources() : null).add("DataSetId", (Object)this.dataSetId()).add("RevisionId", (Object)this.revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssetSources": {
                return Optional.ofNullable(clazz.cast(this.assetSources()));
            }
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "RevisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssetSources", ASSET_SOURCES_FIELD);
        map.put("DataSetId", DATA_SET_ID_FIELD);
        map.put("RevisionId", REVISION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportAssetsFromRedshiftDataSharesResponseDetails, T> g) {
        return obj -> g.apply((ImportAssetsFromRedshiftDataSharesResponseDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RedshiftDataShareAssetSourceEntry> assetSources = DefaultSdkAutoConstructList.getInstance();
        private String dataSetId;
        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportAssetsFromRedshiftDataSharesResponseDetails model) {
            this.assetSources(model.assetSources);
            this.dataSetId(model.dataSetId);
            this.revisionId(model.revisionId);
        }

        public final List<RedshiftDataShareAssetSourceEntry.Builder> getAssetSources() {
            List<RedshiftDataShareAssetSourceEntry.Builder> result = ListOfRedshiftDataShareAssetSourceEntryCopier.copyToBuilder(this.assetSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetSources(Collection<RedshiftDataShareAssetSourceEntry.BuilderImpl> assetSources) {
            this.assetSources = ListOfRedshiftDataShareAssetSourceEntryCopier.copyFromBuilder(assetSources);
        }

        @Override
        public final Builder assetSources(Collection<RedshiftDataShareAssetSourceEntry> assetSources) {
            this.assetSources = ListOfRedshiftDataShareAssetSourceEntryCopier.copy(assetSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetSources(RedshiftDataShareAssetSourceEntry ... assetSources) {
            this.assetSources(Arrays.asList(assetSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetSources(Consumer<RedshiftDataShareAssetSourceEntry.Builder> ... assetSources) {
            this.assetSources(Stream.of(assetSources).map(c -> (RedshiftDataShareAssetSourceEntry)((RedshiftDataShareAssetSourceEntry.Builder)RedshiftDataShareAssetSourceEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public ImportAssetsFromRedshiftDataSharesResponseDetails build() {
            return new ImportAssetsFromRedshiftDataSharesResponseDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportAssetsFromRedshiftDataSharesResponseDetails> {
        public Builder assetSources(Collection<RedshiftDataShareAssetSourceEntry> var1);

        public Builder assetSources(RedshiftDataShareAssetSourceEntry ... var1);

        public Builder assetSources(Consumer<RedshiftDataShareAssetSourceEntry.Builder> ... var1);

        public Builder dataSetId(String var1);

        public Builder revisionId(String var1);
    }
}

