/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dataexchange.model.LFPermission;
import software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionDetails;
import software.amazon.awssdk.services.dataexchange.model.LakeFormationDataPermissionType;
import software.amazon.awssdk.services.dataexchange.model.ListOfLFPermissionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LakeFormationDataPermissionAsset
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LakeFormationDataPermissionAsset> {
    private static final SdkField<LakeFormationDataPermissionDetails> LAKE_FORMATION_DATA_PERMISSION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LakeFormationDataPermissionDetails").getter(LakeFormationDataPermissionAsset.getter(LakeFormationDataPermissionAsset::lakeFormationDataPermissionDetails)).setter(LakeFormationDataPermissionAsset.setter(Builder::lakeFormationDataPermissionDetails)).constructor(LakeFormationDataPermissionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LakeFormationDataPermissionDetails").build()}).build();
    private static final SdkField<String> LAKE_FORMATION_DATA_PERMISSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LakeFormationDataPermissionType").getter(LakeFormationDataPermissionAsset.getter(LakeFormationDataPermissionAsset::lakeFormationDataPermissionTypeAsString)).setter(LakeFormationDataPermissionAsset.setter(Builder::lakeFormationDataPermissionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LakeFormationDataPermissionType").build()}).build();
    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(LakeFormationDataPermissionAsset.getter(LakeFormationDataPermissionAsset::permissionsAsStrings)).setter(LakeFormationDataPermissionAsset.setter(Builder::permissionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(LakeFormationDataPermissionAsset.getter(LakeFormationDataPermissionAsset::roleArn)).setter(LakeFormationDataPermissionAsset.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAKE_FORMATION_DATA_PERMISSION_DETAILS_FIELD, LAKE_FORMATION_DATA_PERMISSION_TYPE_FIELD, PERMISSIONS_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final LakeFormationDataPermissionDetails lakeFormationDataPermissionDetails;
    private final String lakeFormationDataPermissionType;
    private final List<String> permissions;
    private final String roleArn;

    private LakeFormationDataPermissionAsset(BuilderImpl builder) {
        this.lakeFormationDataPermissionDetails = builder.lakeFormationDataPermissionDetails;
        this.lakeFormationDataPermissionType = builder.lakeFormationDataPermissionType;
        this.permissions = builder.permissions;
        this.roleArn = builder.roleArn;
    }

    public final LakeFormationDataPermissionDetails lakeFormationDataPermissionDetails() {
        return this.lakeFormationDataPermissionDetails;
    }

    public final LakeFormationDataPermissionType lakeFormationDataPermissionType() {
        return LakeFormationDataPermissionType.fromValue(this.lakeFormationDataPermissionType);
    }

    public final String lakeFormationDataPermissionTypeAsString() {
        return this.lakeFormationDataPermissionType;
    }

    public final List<LFPermission> permissions() {
        return ListOfLFPermissionsCopier.copyStringToEnum(this.permissions);
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<String> permissionsAsStrings() {
        return this.permissions;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lakeFormationDataPermissionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.lakeFormationDataPermissionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LakeFormationDataPermissionAsset)) {
            return false;
        }
        LakeFormationDataPermissionAsset other = (LakeFormationDataPermissionAsset)obj;
        return Objects.equals(this.lakeFormationDataPermissionDetails(), other.lakeFormationDataPermissionDetails()) && Objects.equals(this.lakeFormationDataPermissionTypeAsString(), other.lakeFormationDataPermissionTypeAsString()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissionsAsStrings(), other.permissionsAsStrings()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"LakeFormationDataPermissionAsset").add("LakeFormationDataPermissionDetails", (Object)this.lakeFormationDataPermissionDetails()).add("LakeFormationDataPermissionType", (Object)this.lakeFormationDataPermissionTypeAsString()).add("Permissions", this.hasPermissions() ? this.permissionsAsStrings() : null).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LakeFormationDataPermissionDetails": {
                return Optional.ofNullable(clazz.cast(this.lakeFormationDataPermissionDetails()));
            }
            case "LakeFormationDataPermissionType": {
                return Optional.ofNullable(clazz.cast(this.lakeFormationDataPermissionTypeAsString()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissionsAsStrings()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LakeFormationDataPermissionAsset, T> g) {
        return obj -> g.apply((LakeFormationDataPermissionAsset)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LakeFormationDataPermissionDetails lakeFormationDataPermissionDetails;
        private String lakeFormationDataPermissionType;
        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LakeFormationDataPermissionAsset model) {
            this.lakeFormationDataPermissionDetails(model.lakeFormationDataPermissionDetails);
            this.lakeFormationDataPermissionType(model.lakeFormationDataPermissionType);
            this.permissionsWithStrings(model.permissions);
            this.roleArn(model.roleArn);
        }

        public final LakeFormationDataPermissionDetails.Builder getLakeFormationDataPermissionDetails() {
            return this.lakeFormationDataPermissionDetails != null ? this.lakeFormationDataPermissionDetails.toBuilder() : null;
        }

        public final void setLakeFormationDataPermissionDetails(LakeFormationDataPermissionDetails.BuilderImpl lakeFormationDataPermissionDetails) {
            this.lakeFormationDataPermissionDetails = lakeFormationDataPermissionDetails != null ? lakeFormationDataPermissionDetails.build() : null;
        }

        @Override
        public final Builder lakeFormationDataPermissionDetails(LakeFormationDataPermissionDetails lakeFormationDataPermissionDetails) {
            this.lakeFormationDataPermissionDetails = lakeFormationDataPermissionDetails;
            return this;
        }

        public final String getLakeFormationDataPermissionType() {
            return this.lakeFormationDataPermissionType;
        }

        public final void setLakeFormationDataPermissionType(String lakeFormationDataPermissionType) {
            this.lakeFormationDataPermissionType = lakeFormationDataPermissionType;
        }

        @Override
        public final Builder lakeFormationDataPermissionType(String lakeFormationDataPermissionType) {
            this.lakeFormationDataPermissionType = lakeFormationDataPermissionType;
            return this;
        }

        @Override
        public final Builder lakeFormationDataPermissionType(LakeFormationDataPermissionType lakeFormationDataPermissionType) {
            this.lakeFormationDataPermissionType(lakeFormationDataPermissionType == null ? null : lakeFormationDataPermissionType.toString());
            return this;
        }

        public final Collection<String> getPermissions() {
            if (this.permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = ListOfLFPermissionsCopier.copy(permissions);
        }

        @Override
        public final Builder permissionsWithStrings(Collection<String> permissions) {
            this.permissions = ListOfLFPermissionsCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithStrings(String ... permissions) {
            this.permissionsWithStrings(Arrays.asList(permissions));
            return this;
        }

        @Override
        public final Builder permissions(Collection<LFPermission> permissions) {
            this.permissions = ListOfLFPermissionsCopier.copyEnumToString(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(LFPermission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public LakeFormationDataPermissionAsset build() {
            return new LakeFormationDataPermissionAsset(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LakeFormationDataPermissionAsset> {
        public Builder lakeFormationDataPermissionDetails(LakeFormationDataPermissionDetails var1);

        default public Builder lakeFormationDataPermissionDetails(Consumer<LakeFormationDataPermissionDetails.Builder> lakeFormationDataPermissionDetails) {
            return this.lakeFormationDataPermissionDetails((LakeFormationDataPermissionDetails)((LakeFormationDataPermissionDetails.Builder)LakeFormationDataPermissionDetails.builder().applyMutation(lakeFormationDataPermissionDetails)).build());
        }

        public Builder lakeFormationDataPermissionType(String var1);

        public Builder lakeFormationDataPermissionType(LakeFormationDataPermissionType var1);

        public Builder permissionsWithStrings(Collection<String> var1);

        public Builder permissionsWithStrings(String ... var1);

        public Builder permissions(Collection<LFPermission> var1);

        public Builder permissions(LFPermission ... var1);

        public Builder roleArn(String var1);
    }
}

