/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dataexchange.DataExchangeClient;
import software.amazon.awssdk.services.dataexchange.DataExchangeClientBuilder;
import software.amazon.awssdk.services.dataexchange.DataExchangeServiceClientConfiguration;
import software.amazon.awssdk.services.dataexchange.DefaultDataExchangeBaseClientBuilder;
import software.amazon.awssdk.services.dataexchange.DefaultDataExchangeClient;
import software.amazon.awssdk.services.dataexchange.endpoints.DataExchangeEndpointProvider;

@SdkInternalApi
final class DefaultDataExchangeClientBuilder
extends DefaultDataExchangeBaseClientBuilder<DataExchangeClientBuilder, DataExchangeClient>
implements DataExchangeClientBuilder {
    DefaultDataExchangeClientBuilder() {
    }

    @Override
    public DefaultDataExchangeClientBuilder endpointProvider(DataExchangeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DataExchangeClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDataExchangeClientBuilder.validateClientOptions(clientConfiguration);
        DataExchangeServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDataExchangeClient client = new DefaultDataExchangeClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DataExchangeServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DataExchangeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

