/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for the response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResponseDetails implements SdkPojo, Serializable, ToCopyableBuilder<ResponseDetails.Builder, ResponseDetails> {
    private static final SdkField<ExportAssetToSignedUrlResponseDetails> EXPORT_ASSET_TO_SIGNED_URL_FIELD = SdkField
            .<ExportAssetToSignedUrlResponseDetails> builder(MarshallingType.SDK_POJO).memberName("ExportAssetToSignedUrl")
            .getter(getter(ResponseDetails::exportAssetToSignedUrl)).setter(setter(Builder::exportAssetToSignedUrl))
            .constructor(ExportAssetToSignedUrlResponseDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportAssetToSignedUrl").build())
            .build();

    private static final SdkField<ExportAssetsToS3ResponseDetails> EXPORT_ASSETS_TO_S3_FIELD = SdkField
            .<ExportAssetsToS3ResponseDetails> builder(MarshallingType.SDK_POJO).memberName("ExportAssetsToS3")
            .getter(getter(ResponseDetails::exportAssetsToS3)).setter(setter(Builder::exportAssetsToS3))
            .constructor(ExportAssetsToS3ResponseDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportAssetsToS3").build()).build();

    private static final SdkField<ExportRevisionsToS3ResponseDetails> EXPORT_REVISIONS_TO_S3_FIELD = SdkField
            .<ExportRevisionsToS3ResponseDetails> builder(MarshallingType.SDK_POJO).memberName("ExportRevisionsToS3")
            .getter(getter(ResponseDetails::exportRevisionsToS3)).setter(setter(Builder::exportRevisionsToS3))
            .constructor(ExportRevisionsToS3ResponseDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportRevisionsToS3").build())
            .build();

    private static final SdkField<ImportAssetFromSignedUrlResponseDetails> IMPORT_ASSET_FROM_SIGNED_URL_FIELD = SdkField
            .<ImportAssetFromSignedUrlResponseDetails> builder(MarshallingType.SDK_POJO).memberName("ImportAssetFromSignedUrl")
            .getter(getter(ResponseDetails::importAssetFromSignedUrl)).setter(setter(Builder::importAssetFromSignedUrl))
            .constructor(ImportAssetFromSignedUrlResponseDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportAssetFromSignedUrl").build())
            .build();

    private static final SdkField<ImportAssetsFromS3ResponseDetails> IMPORT_ASSETS_FROM_S3_FIELD = SdkField
            .<ImportAssetsFromS3ResponseDetails> builder(MarshallingType.SDK_POJO).memberName("ImportAssetsFromS3")
            .getter(getter(ResponseDetails::importAssetsFromS3)).setter(setter(Builder::importAssetsFromS3))
            .constructor(ImportAssetsFromS3ResponseDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportAssetsFromS3").build())
            .build();

    private static final SdkField<ImportAssetsFromRedshiftDataSharesResponseDetails> IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES_FIELD = SdkField
            .<ImportAssetsFromRedshiftDataSharesResponseDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ImportAssetsFromRedshiftDataShares")
            .getter(getter(ResponseDetails::importAssetsFromRedshiftDataShares))
            .setter(setter(Builder::importAssetsFromRedshiftDataShares))
            .constructor(ImportAssetsFromRedshiftDataSharesResponseDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportAssetsFromRedshiftDataShares")
                    .build()).build();

    private static final SdkField<ImportAssetFromApiGatewayApiResponseDetails> IMPORT_ASSET_FROM_API_GATEWAY_API_FIELD = SdkField
            .<ImportAssetFromApiGatewayApiResponseDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ImportAssetFromApiGatewayApi")
            .getter(getter(ResponseDetails::importAssetFromApiGatewayApi))
            .setter(setter(Builder::importAssetFromApiGatewayApi))
            .constructor(ImportAssetFromApiGatewayApiResponseDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportAssetFromApiGatewayApi")
                    .build()).build();

    private static final SdkField<CreateS3DataAccessFromS3BucketResponseDetails> CREATE_S3_DATA_ACCESS_FROM_S3_BUCKET_FIELD = SdkField
            .<CreateS3DataAccessFromS3BucketResponseDetails> builder(MarshallingType.SDK_POJO)
            .memberName("CreateS3DataAccessFromS3Bucket")
            .getter(getter(ResponseDetails::createS3DataAccessFromS3Bucket))
            .setter(setter(Builder::createS3DataAccessFromS3Bucket))
            .constructor(CreateS3DataAccessFromS3BucketResponseDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateS3DataAccessFromS3Bucket")
                    .build()).build();

    private static final SdkField<ImportAssetsFromLakeFormationTagPolicyResponseDetails> IMPORT_ASSETS_FROM_LAKE_FORMATION_TAG_POLICY_FIELD = SdkField
            .<ImportAssetsFromLakeFormationTagPolicyResponseDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ImportAssetsFromLakeFormationTagPolicy")
            .getter(getter(ResponseDetails::importAssetsFromLakeFormationTagPolicy))
            .setter(setter(Builder::importAssetsFromLakeFormationTagPolicy))
            .constructor(ImportAssetsFromLakeFormationTagPolicyResponseDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ImportAssetsFromLakeFormationTagPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXPORT_ASSET_TO_SIGNED_URL_FIELD, EXPORT_ASSETS_TO_S3_FIELD, EXPORT_REVISIONS_TO_S3_FIELD,
            IMPORT_ASSET_FROM_SIGNED_URL_FIELD, IMPORT_ASSETS_FROM_S3_FIELD, IMPORT_ASSETS_FROM_REDSHIFT_DATA_SHARES_FIELD,
            IMPORT_ASSET_FROM_API_GATEWAY_API_FIELD, CREATE_S3_DATA_ACCESS_FROM_S3_BUCKET_FIELD,
            IMPORT_ASSETS_FROM_LAKE_FORMATION_TAG_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final ExportAssetToSignedUrlResponseDetails exportAssetToSignedUrl;

    private final ExportAssetsToS3ResponseDetails exportAssetsToS3;

    private final ExportRevisionsToS3ResponseDetails exportRevisionsToS3;

    private final ImportAssetFromSignedUrlResponseDetails importAssetFromSignedUrl;

    private final ImportAssetsFromS3ResponseDetails importAssetsFromS3;

    private final ImportAssetsFromRedshiftDataSharesResponseDetails importAssetsFromRedshiftDataShares;

    private final ImportAssetFromApiGatewayApiResponseDetails importAssetFromApiGatewayApi;

    private final CreateS3DataAccessFromS3BucketResponseDetails createS3DataAccessFromS3Bucket;

    private final ImportAssetsFromLakeFormationTagPolicyResponseDetails importAssetsFromLakeFormationTagPolicy;

    private ResponseDetails(BuilderImpl builder) {
        this.exportAssetToSignedUrl = builder.exportAssetToSignedUrl;
        this.exportAssetsToS3 = builder.exportAssetsToS3;
        this.exportRevisionsToS3 = builder.exportRevisionsToS3;
        this.importAssetFromSignedUrl = builder.importAssetFromSignedUrl;
        this.importAssetsFromS3 = builder.importAssetsFromS3;
        this.importAssetsFromRedshiftDataShares = builder.importAssetsFromRedshiftDataShares;
        this.importAssetFromApiGatewayApi = builder.importAssetFromApiGatewayApi;
        this.createS3DataAccessFromS3Bucket = builder.createS3DataAccessFromS3Bucket;
        this.importAssetsFromLakeFormationTagPolicy = builder.importAssetsFromLakeFormationTagPolicy;
    }

    /**
     * <p>
     * Details for the export to signed URL response.
     * </p>
     * 
     * @return Details for the export to signed URL response.
     */
    public final ExportAssetToSignedUrlResponseDetails exportAssetToSignedUrl() {
        return exportAssetToSignedUrl;
    }

    /**
     * <p>
     * Details for the export to Amazon S3 response.
     * </p>
     * 
     * @return Details for the export to Amazon S3 response.
     */
    public final ExportAssetsToS3ResponseDetails exportAssetsToS3() {
        return exportAssetsToS3;
    }

    /**
     * <p>
     * Details for the export revisions to Amazon S3 response.
     * </p>
     * 
     * @return Details for the export revisions to Amazon S3 response.
     */
    public final ExportRevisionsToS3ResponseDetails exportRevisionsToS3() {
        return exportRevisionsToS3;
    }

    /**
     * <p>
     * Details for the import from signed URL response.
     * </p>
     * 
     * @return Details for the import from signed URL response.
     */
    public final ImportAssetFromSignedUrlResponseDetails importAssetFromSignedUrl() {
        return importAssetFromSignedUrl;
    }

    /**
     * <p>
     * Details for the import from Amazon S3 response.
     * </p>
     * 
     * @return Details for the import from Amazon S3 response.
     */
    public final ImportAssetsFromS3ResponseDetails importAssetsFromS3() {
        return importAssetsFromS3;
    }

    /**
     * <p>
     * Details from an import from Amazon Redshift datashare response.
     * </p>
     * 
     * @return Details from an import from Amazon Redshift datashare response.
     */
    public final ImportAssetsFromRedshiftDataSharesResponseDetails importAssetsFromRedshiftDataShares() {
        return importAssetsFromRedshiftDataShares;
    }

    /**
     * <p>
     * The response details.
     * </p>
     * 
     * @return The response details.
     */
    public final ImportAssetFromApiGatewayApiResponseDetails importAssetFromApiGatewayApi() {
        return importAssetFromApiGatewayApi;
    }

    /**
     * <p>
     * Response details from the CreateS3DataAccessFromS3Bucket job.
     * </p>
     * 
     * @return Response details from the CreateS3DataAccessFromS3Bucket job.
     */
    public final CreateS3DataAccessFromS3BucketResponseDetails createS3DataAccessFromS3Bucket() {
        return createS3DataAccessFromS3Bucket;
    }

    /**
     * <p>
     * Response details from the ImportAssetsFromLakeFormationTagPolicy job.
     * </p>
     * 
     * @return Response details from the ImportAssetsFromLakeFormationTagPolicy job.
     */
    public final ImportAssetsFromLakeFormationTagPolicyResponseDetails importAssetsFromLakeFormationTagPolicy() {
        return importAssetsFromLakeFormationTagPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportAssetToSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(exportAssetsToS3());
        hashCode = 31 * hashCode + Objects.hashCode(exportRevisionsToS3());
        hashCode = 31 * hashCode + Objects.hashCode(importAssetFromSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(importAssetsFromS3());
        hashCode = 31 * hashCode + Objects.hashCode(importAssetsFromRedshiftDataShares());
        hashCode = 31 * hashCode + Objects.hashCode(importAssetFromApiGatewayApi());
        hashCode = 31 * hashCode + Objects.hashCode(createS3DataAccessFromS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(importAssetsFromLakeFormationTagPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseDetails)) {
            return false;
        }
        ResponseDetails other = (ResponseDetails) obj;
        return Objects.equals(exportAssetToSignedUrl(), other.exportAssetToSignedUrl())
                && Objects.equals(exportAssetsToS3(), other.exportAssetsToS3())
                && Objects.equals(exportRevisionsToS3(), other.exportRevisionsToS3())
                && Objects.equals(importAssetFromSignedUrl(), other.importAssetFromSignedUrl())
                && Objects.equals(importAssetsFromS3(), other.importAssetsFromS3())
                && Objects.equals(importAssetsFromRedshiftDataShares(), other.importAssetsFromRedshiftDataShares())
                && Objects.equals(importAssetFromApiGatewayApi(), other.importAssetFromApiGatewayApi())
                && Objects.equals(createS3DataAccessFromS3Bucket(), other.createS3DataAccessFromS3Bucket())
                && Objects.equals(importAssetsFromLakeFormationTagPolicy(), other.importAssetsFromLakeFormationTagPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResponseDetails").add("ExportAssetToSignedUrl", exportAssetToSignedUrl())
                .add("ExportAssetsToS3", exportAssetsToS3()).add("ExportRevisionsToS3", exportRevisionsToS3())
                .add("ImportAssetFromSignedUrl", importAssetFromSignedUrl()).add("ImportAssetsFromS3", importAssetsFromS3())
                .add("ImportAssetsFromRedshiftDataShares", importAssetsFromRedshiftDataShares())
                .add("ImportAssetFromApiGatewayApi", importAssetFromApiGatewayApi())
                .add("CreateS3DataAccessFromS3Bucket", createS3DataAccessFromS3Bucket())
                .add("ImportAssetsFromLakeFormationTagPolicy", importAssetsFromLakeFormationTagPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportAssetToSignedUrl":
            return Optional.ofNullable(clazz.cast(exportAssetToSignedUrl()));
        case "ExportAssetsToS3":
            return Optional.ofNullable(clazz.cast(exportAssetsToS3()));
        case "ExportRevisionsToS3":
            return Optional.ofNullable(clazz.cast(exportRevisionsToS3()));
        case "ImportAssetFromSignedUrl":
            return Optional.ofNullable(clazz.cast(importAssetFromSignedUrl()));
        case "ImportAssetsFromS3":
            return Optional.ofNullable(clazz.cast(importAssetsFromS3()));
        case "ImportAssetsFromRedshiftDataShares":
            return Optional.ofNullable(clazz.cast(importAssetsFromRedshiftDataShares()));
        case "ImportAssetFromApiGatewayApi":
            return Optional.ofNullable(clazz.cast(importAssetFromApiGatewayApi()));
        case "CreateS3DataAccessFromS3Bucket":
            return Optional.ofNullable(clazz.cast(createS3DataAccessFromS3Bucket()));
        case "ImportAssetsFromLakeFormationTagPolicy":
            return Optional.ofNullable(clazz.cast(importAssetsFromLakeFormationTagPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResponseDetails, T> g) {
        return obj -> g.apply((ResponseDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResponseDetails> {
        /**
         * <p>
         * Details for the export to signed URL response.
         * </p>
         * 
         * @param exportAssetToSignedUrl
         *        Details for the export to signed URL response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportAssetToSignedUrl(ExportAssetToSignedUrlResponseDetails exportAssetToSignedUrl);

        /**
         * <p>
         * Details for the export to signed URL response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExportAssetToSignedUrlResponseDetails.Builder} avoiding the need to create one manually via
         * {@link ExportAssetToSignedUrlResponseDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportAssetToSignedUrlResponseDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #exportAssetToSignedUrl(ExportAssetToSignedUrlResponseDetails)}.
         * 
         * @param exportAssetToSignedUrl
         *        a consumer that will call methods on {@link ExportAssetToSignedUrlResponseDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportAssetToSignedUrl(ExportAssetToSignedUrlResponseDetails)
         */
        default Builder exportAssetToSignedUrl(Consumer<ExportAssetToSignedUrlResponseDetails.Builder> exportAssetToSignedUrl) {
            return exportAssetToSignedUrl(ExportAssetToSignedUrlResponseDetails.builder().applyMutation(exportAssetToSignedUrl)
                    .build());
        }

        /**
         * <p>
         * Details for the export to Amazon S3 response.
         * </p>
         * 
         * @param exportAssetsToS3
         *        Details for the export to Amazon S3 response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportAssetsToS3(ExportAssetsToS3ResponseDetails exportAssetsToS3);

        /**
         * <p>
         * Details for the export to Amazon S3 response.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportAssetsToS3ResponseDetails.Builder}
         * avoiding the need to create one manually via {@link ExportAssetsToS3ResponseDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportAssetsToS3ResponseDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #exportAssetsToS3(ExportAssetsToS3ResponseDetails)}.
         * 
         * @param exportAssetsToS3
         *        a consumer that will call methods on {@link ExportAssetsToS3ResponseDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportAssetsToS3(ExportAssetsToS3ResponseDetails)
         */
        default Builder exportAssetsToS3(Consumer<ExportAssetsToS3ResponseDetails.Builder> exportAssetsToS3) {
            return exportAssetsToS3(ExportAssetsToS3ResponseDetails.builder().applyMutation(exportAssetsToS3).build());
        }

        /**
         * <p>
         * Details for the export revisions to Amazon S3 response.
         * </p>
         * 
         * @param exportRevisionsToS3
         *        Details for the export revisions to Amazon S3 response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportRevisionsToS3(ExportRevisionsToS3ResponseDetails exportRevisionsToS3);

        /**
         * <p>
         * Details for the export revisions to Amazon S3 response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExportRevisionsToS3ResponseDetails.Builder} avoiding the need to create one manually via
         * {@link ExportRevisionsToS3ResponseDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportRevisionsToS3ResponseDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #exportRevisionsToS3(ExportRevisionsToS3ResponseDetails)}.
         * 
         * @param exportRevisionsToS3
         *        a consumer that will call methods on {@link ExportRevisionsToS3ResponseDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportRevisionsToS3(ExportRevisionsToS3ResponseDetails)
         */
        default Builder exportRevisionsToS3(Consumer<ExportRevisionsToS3ResponseDetails.Builder> exportRevisionsToS3) {
            return exportRevisionsToS3(ExportRevisionsToS3ResponseDetails.builder().applyMutation(exportRevisionsToS3).build());
        }

        /**
         * <p>
         * Details for the import from signed URL response.
         * </p>
         * 
         * @param importAssetFromSignedUrl
         *        Details for the import from signed URL response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importAssetFromSignedUrl(ImportAssetFromSignedUrlResponseDetails importAssetFromSignedUrl);

        /**
         * <p>
         * Details for the import from signed URL response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ImportAssetFromSignedUrlResponseDetails.Builder} avoiding the need to create one manually via
         * {@link ImportAssetFromSignedUrlResponseDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportAssetFromSignedUrlResponseDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #importAssetFromSignedUrl(ImportAssetFromSignedUrlResponseDetails)}.
         * 
         * @param importAssetFromSignedUrl
         *        a consumer that will call methods on {@link ImportAssetFromSignedUrlResponseDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importAssetFromSignedUrl(ImportAssetFromSignedUrlResponseDetails)
         */
        default Builder importAssetFromSignedUrl(
                Consumer<ImportAssetFromSignedUrlResponseDetails.Builder> importAssetFromSignedUrl) {
            return importAssetFromSignedUrl(ImportAssetFromSignedUrlResponseDetails.builder()
                    .applyMutation(importAssetFromSignedUrl).build());
        }

        /**
         * <p>
         * Details for the import from Amazon S3 response.
         * </p>
         * 
         * @param importAssetsFromS3
         *        Details for the import from Amazon S3 response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importAssetsFromS3(ImportAssetsFromS3ResponseDetails importAssetsFromS3);

        /**
         * <p>
         * Details for the import from Amazon S3 response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ImportAssetsFromS3ResponseDetails.Builder} avoiding the need to create one manually via
         * {@link ImportAssetsFromS3ResponseDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportAssetsFromS3ResponseDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #importAssetsFromS3(ImportAssetsFromS3ResponseDetails)}.
         * 
         * @param importAssetsFromS3
         *        a consumer that will call methods on {@link ImportAssetsFromS3ResponseDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importAssetsFromS3(ImportAssetsFromS3ResponseDetails)
         */
        default Builder importAssetsFromS3(Consumer<ImportAssetsFromS3ResponseDetails.Builder> importAssetsFromS3) {
            return importAssetsFromS3(ImportAssetsFromS3ResponseDetails.builder().applyMutation(importAssetsFromS3).build());
        }

        /**
         * <p>
         * Details from an import from Amazon Redshift datashare response.
         * </p>
         * 
         * @param importAssetsFromRedshiftDataShares
         *        Details from an import from Amazon Redshift datashare response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importAssetsFromRedshiftDataShares(
                ImportAssetsFromRedshiftDataSharesResponseDetails importAssetsFromRedshiftDataShares);

        /**
         * <p>
         * Details from an import from Amazon Redshift datashare response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ImportAssetsFromRedshiftDataSharesResponseDetails.Builder} avoiding the need to create one manually
         * via {@link ImportAssetsFromRedshiftDataSharesResponseDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link ImportAssetsFromRedshiftDataSharesResponseDetails.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #importAssetsFromRedshiftDataShares(ImportAssetsFromRedshiftDataSharesResponseDetails)}.
         * 
         * @param importAssetsFromRedshiftDataShares
         *        a consumer that will call methods on {@link ImportAssetsFromRedshiftDataSharesResponseDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importAssetsFromRedshiftDataShares(ImportAssetsFromRedshiftDataSharesResponseDetails)
         */
        default Builder importAssetsFromRedshiftDataShares(
                Consumer<ImportAssetsFromRedshiftDataSharesResponseDetails.Builder> importAssetsFromRedshiftDataShares) {
            return importAssetsFromRedshiftDataShares(ImportAssetsFromRedshiftDataSharesResponseDetails.builder()
                    .applyMutation(importAssetsFromRedshiftDataShares).build());
        }

        /**
         * <p>
         * The response details.
         * </p>
         * 
         * @param importAssetFromApiGatewayApi
         *        The response details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importAssetFromApiGatewayApi(ImportAssetFromApiGatewayApiResponseDetails importAssetFromApiGatewayApi);

        /**
         * <p>
         * The response details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ImportAssetFromApiGatewayApiResponseDetails.Builder} avoiding the need to create one manually via
         * {@link ImportAssetFromApiGatewayApiResponseDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportAssetFromApiGatewayApiResponseDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #importAssetFromApiGatewayApi(ImportAssetFromApiGatewayApiResponseDetails)}.
         * 
         * @param importAssetFromApiGatewayApi
         *        a consumer that will call methods on {@link ImportAssetFromApiGatewayApiResponseDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importAssetFromApiGatewayApi(ImportAssetFromApiGatewayApiResponseDetails)
         */
        default Builder importAssetFromApiGatewayApi(
                Consumer<ImportAssetFromApiGatewayApiResponseDetails.Builder> importAssetFromApiGatewayApi) {
            return importAssetFromApiGatewayApi(ImportAssetFromApiGatewayApiResponseDetails.builder()
                    .applyMutation(importAssetFromApiGatewayApi).build());
        }

        /**
         * <p>
         * Response details from the CreateS3DataAccessFromS3Bucket job.
         * </p>
         * 
         * @param createS3DataAccessFromS3Bucket
         *        Response details from the CreateS3DataAccessFromS3Bucket job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createS3DataAccessFromS3Bucket(CreateS3DataAccessFromS3BucketResponseDetails createS3DataAccessFromS3Bucket);

        /**
         * <p>
         * Response details from the CreateS3DataAccessFromS3Bucket job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateS3DataAccessFromS3BucketResponseDetails.Builder} avoiding the need to create one manually via
         * {@link CreateS3DataAccessFromS3BucketResponseDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateS3DataAccessFromS3BucketResponseDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #createS3DataAccessFromS3Bucket(CreateS3DataAccessFromS3BucketResponseDetails)}.
         * 
         * @param createS3DataAccessFromS3Bucket
         *        a consumer that will call methods on {@link CreateS3DataAccessFromS3BucketResponseDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createS3DataAccessFromS3Bucket(CreateS3DataAccessFromS3BucketResponseDetails)
         */
        default Builder createS3DataAccessFromS3Bucket(
                Consumer<CreateS3DataAccessFromS3BucketResponseDetails.Builder> createS3DataAccessFromS3Bucket) {
            return createS3DataAccessFromS3Bucket(CreateS3DataAccessFromS3BucketResponseDetails.builder()
                    .applyMutation(createS3DataAccessFromS3Bucket).build());
        }

        /**
         * <p>
         * Response details from the ImportAssetsFromLakeFormationTagPolicy job.
         * </p>
         * 
         * @param importAssetsFromLakeFormationTagPolicy
         *        Response details from the ImportAssetsFromLakeFormationTagPolicy job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importAssetsFromLakeFormationTagPolicy(
                ImportAssetsFromLakeFormationTagPolicyResponseDetails importAssetsFromLakeFormationTagPolicy);

        /**
         * <p>
         * Response details from the ImportAssetsFromLakeFormationTagPolicy job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ImportAssetsFromLakeFormationTagPolicyResponseDetails.Builder} avoiding the need to create one
         * manually via {@link ImportAssetsFromLakeFormationTagPolicyResponseDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link ImportAssetsFromLakeFormationTagPolicyResponseDetails.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #importAssetsFromLakeFormationTagPolicy(ImportAssetsFromLakeFormationTagPolicyResponseDetails)}.
         * 
         * @param importAssetsFromLakeFormationTagPolicy
         *        a consumer that will call methods on
         *        {@link ImportAssetsFromLakeFormationTagPolicyResponseDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importAssetsFromLakeFormationTagPolicy(ImportAssetsFromLakeFormationTagPolicyResponseDetails)
         */
        default Builder importAssetsFromLakeFormationTagPolicy(
                Consumer<ImportAssetsFromLakeFormationTagPolicyResponseDetails.Builder> importAssetsFromLakeFormationTagPolicy) {
            return importAssetsFromLakeFormationTagPolicy(ImportAssetsFromLakeFormationTagPolicyResponseDetails.builder()
                    .applyMutation(importAssetsFromLakeFormationTagPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ExportAssetToSignedUrlResponseDetails exportAssetToSignedUrl;

        private ExportAssetsToS3ResponseDetails exportAssetsToS3;

        private ExportRevisionsToS3ResponseDetails exportRevisionsToS3;

        private ImportAssetFromSignedUrlResponseDetails importAssetFromSignedUrl;

        private ImportAssetsFromS3ResponseDetails importAssetsFromS3;

        private ImportAssetsFromRedshiftDataSharesResponseDetails importAssetsFromRedshiftDataShares;

        private ImportAssetFromApiGatewayApiResponseDetails importAssetFromApiGatewayApi;

        private CreateS3DataAccessFromS3BucketResponseDetails createS3DataAccessFromS3Bucket;

        private ImportAssetsFromLakeFormationTagPolicyResponseDetails importAssetsFromLakeFormationTagPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseDetails model) {
            exportAssetToSignedUrl(model.exportAssetToSignedUrl);
            exportAssetsToS3(model.exportAssetsToS3);
            exportRevisionsToS3(model.exportRevisionsToS3);
            importAssetFromSignedUrl(model.importAssetFromSignedUrl);
            importAssetsFromS3(model.importAssetsFromS3);
            importAssetsFromRedshiftDataShares(model.importAssetsFromRedshiftDataShares);
            importAssetFromApiGatewayApi(model.importAssetFromApiGatewayApi);
            createS3DataAccessFromS3Bucket(model.createS3DataAccessFromS3Bucket);
            importAssetsFromLakeFormationTagPolicy(model.importAssetsFromLakeFormationTagPolicy);
        }

        public final ExportAssetToSignedUrlResponseDetails.Builder getExportAssetToSignedUrl() {
            return exportAssetToSignedUrl != null ? exportAssetToSignedUrl.toBuilder() : null;
        }

        public final void setExportAssetToSignedUrl(ExportAssetToSignedUrlResponseDetails.BuilderImpl exportAssetToSignedUrl) {
            this.exportAssetToSignedUrl = exportAssetToSignedUrl != null ? exportAssetToSignedUrl.build() : null;
        }

        @Override
        public final Builder exportAssetToSignedUrl(ExportAssetToSignedUrlResponseDetails exportAssetToSignedUrl) {
            this.exportAssetToSignedUrl = exportAssetToSignedUrl;
            return this;
        }

        public final ExportAssetsToS3ResponseDetails.Builder getExportAssetsToS3() {
            return exportAssetsToS3 != null ? exportAssetsToS3.toBuilder() : null;
        }

        public final void setExportAssetsToS3(ExportAssetsToS3ResponseDetails.BuilderImpl exportAssetsToS3) {
            this.exportAssetsToS3 = exportAssetsToS3 != null ? exportAssetsToS3.build() : null;
        }

        @Override
        public final Builder exportAssetsToS3(ExportAssetsToS3ResponseDetails exportAssetsToS3) {
            this.exportAssetsToS3 = exportAssetsToS3;
            return this;
        }

        public final ExportRevisionsToS3ResponseDetails.Builder getExportRevisionsToS3() {
            return exportRevisionsToS3 != null ? exportRevisionsToS3.toBuilder() : null;
        }

        public final void setExportRevisionsToS3(ExportRevisionsToS3ResponseDetails.BuilderImpl exportRevisionsToS3) {
            this.exportRevisionsToS3 = exportRevisionsToS3 != null ? exportRevisionsToS3.build() : null;
        }

        @Override
        public final Builder exportRevisionsToS3(ExportRevisionsToS3ResponseDetails exportRevisionsToS3) {
            this.exportRevisionsToS3 = exportRevisionsToS3;
            return this;
        }

        public final ImportAssetFromSignedUrlResponseDetails.Builder getImportAssetFromSignedUrl() {
            return importAssetFromSignedUrl != null ? importAssetFromSignedUrl.toBuilder() : null;
        }

        public final void setImportAssetFromSignedUrl(ImportAssetFromSignedUrlResponseDetails.BuilderImpl importAssetFromSignedUrl) {
            this.importAssetFromSignedUrl = importAssetFromSignedUrl != null ? importAssetFromSignedUrl.build() : null;
        }

        @Override
        public final Builder importAssetFromSignedUrl(ImportAssetFromSignedUrlResponseDetails importAssetFromSignedUrl) {
            this.importAssetFromSignedUrl = importAssetFromSignedUrl;
            return this;
        }

        public final ImportAssetsFromS3ResponseDetails.Builder getImportAssetsFromS3() {
            return importAssetsFromS3 != null ? importAssetsFromS3.toBuilder() : null;
        }

        public final void setImportAssetsFromS3(ImportAssetsFromS3ResponseDetails.BuilderImpl importAssetsFromS3) {
            this.importAssetsFromS3 = importAssetsFromS3 != null ? importAssetsFromS3.build() : null;
        }

        @Override
        public final Builder importAssetsFromS3(ImportAssetsFromS3ResponseDetails importAssetsFromS3) {
            this.importAssetsFromS3 = importAssetsFromS3;
            return this;
        }

        public final ImportAssetsFromRedshiftDataSharesResponseDetails.Builder getImportAssetsFromRedshiftDataShares() {
            return importAssetsFromRedshiftDataShares != null ? importAssetsFromRedshiftDataShares.toBuilder() : null;
        }

        public final void setImportAssetsFromRedshiftDataShares(
                ImportAssetsFromRedshiftDataSharesResponseDetails.BuilderImpl importAssetsFromRedshiftDataShares) {
            this.importAssetsFromRedshiftDataShares = importAssetsFromRedshiftDataShares != null ? importAssetsFromRedshiftDataShares
                    .build() : null;
        }

        @Override
        public final Builder importAssetsFromRedshiftDataShares(
                ImportAssetsFromRedshiftDataSharesResponseDetails importAssetsFromRedshiftDataShares) {
            this.importAssetsFromRedshiftDataShares = importAssetsFromRedshiftDataShares;
            return this;
        }

        public final ImportAssetFromApiGatewayApiResponseDetails.Builder getImportAssetFromApiGatewayApi() {
            return importAssetFromApiGatewayApi != null ? importAssetFromApiGatewayApi.toBuilder() : null;
        }

        public final void setImportAssetFromApiGatewayApi(
                ImportAssetFromApiGatewayApiResponseDetails.BuilderImpl importAssetFromApiGatewayApi) {
            this.importAssetFromApiGatewayApi = importAssetFromApiGatewayApi != null ? importAssetFromApiGatewayApi.build()
                    : null;
        }

        @Override
        public final Builder importAssetFromApiGatewayApi(ImportAssetFromApiGatewayApiResponseDetails importAssetFromApiGatewayApi) {
            this.importAssetFromApiGatewayApi = importAssetFromApiGatewayApi;
            return this;
        }

        public final CreateS3DataAccessFromS3BucketResponseDetails.Builder getCreateS3DataAccessFromS3Bucket() {
            return createS3DataAccessFromS3Bucket != null ? createS3DataAccessFromS3Bucket.toBuilder() : null;
        }

        public final void setCreateS3DataAccessFromS3Bucket(
                CreateS3DataAccessFromS3BucketResponseDetails.BuilderImpl createS3DataAccessFromS3Bucket) {
            this.createS3DataAccessFromS3Bucket = createS3DataAccessFromS3Bucket != null ? createS3DataAccessFromS3Bucket.build()
                    : null;
        }

        @Override
        public final Builder createS3DataAccessFromS3Bucket(
                CreateS3DataAccessFromS3BucketResponseDetails createS3DataAccessFromS3Bucket) {
            this.createS3DataAccessFromS3Bucket = createS3DataAccessFromS3Bucket;
            return this;
        }

        public final ImportAssetsFromLakeFormationTagPolicyResponseDetails.Builder getImportAssetsFromLakeFormationTagPolicy() {
            return importAssetsFromLakeFormationTagPolicy != null ? importAssetsFromLakeFormationTagPolicy.toBuilder() : null;
        }

        public final void setImportAssetsFromLakeFormationTagPolicy(
                ImportAssetsFromLakeFormationTagPolicyResponseDetails.BuilderImpl importAssetsFromLakeFormationTagPolicy) {
            this.importAssetsFromLakeFormationTagPolicy = importAssetsFromLakeFormationTagPolicy != null ? importAssetsFromLakeFormationTagPolicy
                    .build() : null;
        }

        @Override
        public final Builder importAssetsFromLakeFormationTagPolicy(
                ImportAssetsFromLakeFormationTagPolicyResponseDetails importAssetsFromLakeFormationTagPolicy) {
            this.importAssetsFromLakeFormationTagPolicy = importAssetsFromLakeFormationTagPolicy;
            return this;
        }

        @Override
        public ResponseDetails build() {
            return new ResponseDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
