/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the operation to be performed by the job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoExportRevisionToS3RequestDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoExportRevisionToS3RequestDetails.Builder, AutoExportRevisionToS3RequestDetails> {
    private static final SdkField<ExportServerSideEncryption> ENCRYPTION_FIELD = SdkField
            .<ExportServerSideEncryption> builder(MarshallingType.SDK_POJO).memberName("Encryption")
            .getter(getter(AutoExportRevisionToS3RequestDetails::encryption)).setter(setter(Builder::encryption))
            .constructor(ExportServerSideEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()).build();

    private static final SdkField<AutoExportRevisionDestinationEntry> REVISION_DESTINATION_FIELD = SdkField
            .<AutoExportRevisionDestinationEntry> builder(MarshallingType.SDK_POJO).memberName("RevisionDestination")
            .getter(getter(AutoExportRevisionToS3RequestDetails::revisionDestination))
            .setter(setter(Builder::revisionDestination)).constructor(AutoExportRevisionDestinationEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionDestination").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_FIELD,
            REVISION_DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ExportServerSideEncryption encryption;

    private final AutoExportRevisionDestinationEntry revisionDestination;

    private AutoExportRevisionToS3RequestDetails(BuilderImpl builder) {
        this.encryption = builder.encryption;
        this.revisionDestination = builder.revisionDestination;
    }

    /**
     * <p>
     * Encryption configuration for the auto export job.
     * </p>
     * 
     * @return Encryption configuration for the auto export job.
     */
    public final ExportServerSideEncryption encryption() {
        return encryption;
    }

    /**
     * <p>
     * A revision destination is the Amazon S3 bucket folder destination to where the export will be sent.
     * </p>
     * 
     * @return A revision destination is the Amazon S3 bucket folder destination to where the export will be sent.
     */
    public final AutoExportRevisionDestinationEntry revisionDestination() {
        return revisionDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(revisionDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoExportRevisionToS3RequestDetails)) {
            return false;
        }
        AutoExportRevisionToS3RequestDetails other = (AutoExportRevisionToS3RequestDetails) obj;
        return Objects.equals(encryption(), other.encryption())
                && Objects.equals(revisionDestination(), other.revisionDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoExportRevisionToS3RequestDetails").add("Encryption", encryption())
                .add("RevisionDestination", revisionDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "RevisionDestination":
            return Optional.ofNullable(clazz.cast(revisionDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoExportRevisionToS3RequestDetails, T> g) {
        return obj -> g.apply((AutoExportRevisionToS3RequestDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoExportRevisionToS3RequestDetails> {
        /**
         * <p>
         * Encryption configuration for the auto export job.
         * </p>
         * 
         * @param encryption
         *        Encryption configuration for the auto export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(ExportServerSideEncryption encryption);

        /**
         * <p>
         * Encryption configuration for the auto export job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportServerSideEncryption.Builder}
         * avoiding the need to create one manually via {@link ExportServerSideEncryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportServerSideEncryption.Builder#build()} is called immediately
         * and its result is passed to {@link #encryption(ExportServerSideEncryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link ExportServerSideEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(ExportServerSideEncryption)
         */
        default Builder encryption(Consumer<ExportServerSideEncryption.Builder> encryption) {
            return encryption(ExportServerSideEncryption.builder().applyMutation(encryption).build());
        }

        /**
         * <p>
         * A revision destination is the Amazon S3 bucket folder destination to where the export will be sent.
         * </p>
         * 
         * @param revisionDestination
         *        A revision destination is the Amazon S3 bucket folder destination to where the export will be sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionDestination(AutoExportRevisionDestinationEntry revisionDestination);

        /**
         * <p>
         * A revision destination is the Amazon S3 bucket folder destination to where the export will be sent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutoExportRevisionDestinationEntry.Builder} avoiding the need to create one manually via
         * {@link AutoExportRevisionDestinationEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoExportRevisionDestinationEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #revisionDestination(AutoExportRevisionDestinationEntry)}.
         * 
         * @param revisionDestination
         *        a consumer that will call methods on {@link AutoExportRevisionDestinationEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revisionDestination(AutoExportRevisionDestinationEntry)
         */
        default Builder revisionDestination(Consumer<AutoExportRevisionDestinationEntry.Builder> revisionDestination) {
            return revisionDestination(AutoExportRevisionDestinationEntry.builder().applyMutation(revisionDestination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ExportServerSideEncryption encryption;

        private AutoExportRevisionDestinationEntry revisionDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoExportRevisionToS3RequestDetails model) {
            encryption(model.encryption);
            revisionDestination(model.revisionDestination);
        }

        public final ExportServerSideEncryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        public final void setEncryption(ExportServerSideEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(ExportServerSideEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final AutoExportRevisionDestinationEntry.Builder getRevisionDestination() {
            return revisionDestination != null ? revisionDestination.toBuilder() : null;
        }

        public final void setRevisionDestination(AutoExportRevisionDestinationEntry.BuilderImpl revisionDestination) {
            this.revisionDestination = revisionDestination != null ? revisionDestination.build() : null;
        }

        @Override
        public final Builder revisionDestination(AutoExportRevisionDestinationEntry revisionDestination) {
            this.revisionDestination = revisionDestination;
            return this;
        }

        @Override
        public AutoExportRevisionToS3RequestDetails build() {
            return new AutoExportRevisionToS3RequestDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
