/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JobErrorLimitName {
    ASSETS_PER_REVISION("Assets per revision"),
    ASSET_SIZE_IN_GB("Asset size in GB"),
    AMAZON_REDSHIFT_DATASHARE_ASSETS_PER_REVISION("Amazon Redshift datashare assets per revision"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JobErrorLimitName> VALUE_MAP;
    private final String value;

    private JobErrorLimitName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobErrorLimitName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobErrorLimitName> knownValues() {
        EnumSet<JobErrorLimitName> knownValues = EnumSet.allOf(JobErrorLimitName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JobErrorLimitName.class, JobErrorLimitName::toString);
    }
}

