/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the operation to be performed by the job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportAssetFromSignedUrlRequestDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportAssetFromSignedUrlRequestDetails.Builder, ImportAssetFromSignedUrlRequestDetails> {
    private static final SdkField<String> ASSET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssetName").getter(getter(ImportAssetFromSignedUrlRequestDetails::assetName))
            .setter(setter(Builder::assetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetName").build()).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(ImportAssetFromSignedUrlRequestDetails::dataSetId))
            .setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<String> MD5_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Md5Hash").getter(getter(ImportAssetFromSignedUrlRequestDetails::md5Hash))
            .setter(setter(Builder::md5Hash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Md5Hash").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionId").getter(getter(ImportAssetFromSignedUrlRequestDetails::revisionId))
            .setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_NAME_FIELD,
            DATA_SET_ID_FIELD, MD5_HASH_FIELD, REVISION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String assetName;

    private final String dataSetId;

    private final String md5Hash;

    private final String revisionId;

    private ImportAssetFromSignedUrlRequestDetails(BuilderImpl builder) {
        this.assetName = builder.assetName;
        this.dataSetId = builder.dataSetId;
        this.md5Hash = builder.md5Hash;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name.
     * </p>
     * 
     * @return The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name.
     */
    public final String assetName() {
        return assetName;
    }

    /**
     * <p>
     * The unique identifier for the data set associated with this import job.
     * </p>
     * 
     * @return The unique identifier for the data set associated with this import job.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * The Base64-encoded Md5 hash for the asset, used to ensure the integrity of the file at that location.
     * </p>
     * 
     * @return The Base64-encoded Md5 hash for the asset, used to ensure the integrity of the file at that location.
     */
    public final String md5Hash() {
        return md5Hash;
    }

    /**
     * <p>
     * The unique identifier for the revision associated with this import request.
     * </p>
     * 
     * @return The unique identifier for the revision associated with this import request.
     */
    public final String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetName());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(md5Hash());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportAssetFromSignedUrlRequestDetails)) {
            return false;
        }
        ImportAssetFromSignedUrlRequestDetails other = (ImportAssetFromSignedUrlRequestDetails) obj;
        return Objects.equals(assetName(), other.assetName()) && Objects.equals(dataSetId(), other.dataSetId())
                && Objects.equals(md5Hash(), other.md5Hash()) && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportAssetFromSignedUrlRequestDetails").add("AssetName", assetName())
                .add("DataSetId", dataSetId()).add("Md5Hash", md5Hash()).add("RevisionId", revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssetName":
            return Optional.ofNullable(clazz.cast(assetName()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "Md5Hash":
            return Optional.ofNullable(clazz.cast(md5Hash()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportAssetFromSignedUrlRequestDetails, T> g) {
        return obj -> g.apply((ImportAssetFromSignedUrlRequestDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportAssetFromSignedUrlRequestDetails> {
        /**
         * <p>
         * The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name.
         * </p>
         * 
         * @param assetName
         *        The name of the asset. When importing from Amazon S3, the S3 object key is used as the asset name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetName(String assetName);

        /**
         * <p>
         * The unique identifier for the data set associated with this import job.
         * </p>
         * 
         * @param dataSetId
         *        The unique identifier for the data set associated with this import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * The Base64-encoded Md5 hash for the asset, used to ensure the integrity of the file at that location.
         * </p>
         * 
         * @param md5Hash
         *        The Base64-encoded Md5 hash for the asset, used to ensure the integrity of the file at that location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder md5Hash(String md5Hash);

        /**
         * <p>
         * The unique identifier for the revision associated with this import request.
         * </p>
         * 
         * @param revisionId
         *        The unique identifier for the revision associated with this import request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);
    }

    static final class BuilderImpl implements Builder {
        private String assetName;

        private String dataSetId;

        private String md5Hash;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportAssetFromSignedUrlRequestDetails model) {
            assetName(model.assetName);
            dataSetId(model.dataSetId);
            md5Hash(model.md5Hash);
            revisionId(model.revisionId);
        }

        public final String getAssetName() {
            return assetName;
        }

        @Override
        public final Builder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        public final void setAssetName(String assetName) {
            this.assetName = assetName;
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final String getMd5Hash() {
            return md5Hash;
        }

        @Override
        public final Builder md5Hash(String md5Hash) {
            this.md5Hash = md5Hash;
            return this;
        }

        public final void setMd5Hash(String md5Hash) {
            this.md5Hash = md5Hash;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public ImportAssetFromSignedUrlRequestDetails build() {
            return new ImportAssetFromSignedUrlRequestDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
