/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databrew.DataBrewClient;
import software.amazon.awssdk.services.databrew.internal.UserAgentUtils;
import software.amazon.awssdk.services.databrew.model.JobRun;
import software.amazon.awssdk.services.databrew.model.ListJobRunsRequest;
import software.amazon.awssdk.services.databrew.model.ListJobRunsResponse;

public class ListJobRunsIterable
implements SdkIterable<ListJobRunsResponse> {
    private final DataBrewClient client;
    private final ListJobRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListJobRunsIterable(DataBrewClient client, ListJobRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListJobRunsResponseFetcher();
    }

    public Iterator<ListJobRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobRun> jobRuns() {
        Function<ListJobRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobRuns() != null) {
                return response.jobRuns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListJobRunsResponseFetcher
    implements SyncPageFetcher<ListJobRunsResponse> {
        private ListJobRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListJobRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListJobRunsResponse nextPage(ListJobRunsResponse previousPage) {
            if (previousPage == null) {
                return ListJobRunsIterable.this.client.listJobRuns(ListJobRunsIterable.this.firstRequest);
            }
            return ListJobRunsIterable.this.client.listJobRuns((ListJobRunsRequest)((Object)ListJobRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

