/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProjectRequest extends DataBrewRequest implements
        ToCopyableBuilder<UpdateProjectRequest.Builder, UpdateProjectRequest> {
    private static final SdkField<Sample> SAMPLE_FIELD = SdkField.<Sample> builder(MarshallingType.SDK_POJO).memberName("Sample")
            .getter(getter(UpdateProjectRequest::sample)).setter(setter(Builder::sample)).constructor(Sample::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sample").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateProjectRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateProjectRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLE_FIELD, ROLE_ARN_FIELD,
            NAME_FIELD));

    private final Sample sample;

    private final String roleArn;

    private final String name;

    private UpdateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.sample = builder.sample;
        this.roleArn = builder.roleArn;
        this.name = builder.name;
    }

    /**
     * Returns the value of the Sample property for this object.
     * 
     * @return The value of the Sample property for this object.
     */
    public final Sample sample() {
        return sample;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to be assumed for this request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to be assumed for this request.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The name of the project to be updated.
     * </p>
     * 
     * @return The name of the project to be updated.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sample());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectRequest)) {
            return false;
        }
        UpdateProjectRequest other = (UpdateProjectRequest) obj;
        return Objects.equals(sample(), other.sample()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProjectRequest").add("Sample", sample()).add("RoleArn", roleArn()).add("Name", name())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sample":
            return Optional.ofNullable(clazz.cast(sample()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProjectRequest, T> g) {
        return obj -> g.apply((UpdateProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataBrewRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProjectRequest> {
        /**
         * Sets the value of the Sample property for this object.
         *
         * @param sample
         *        The new value for the Sample property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sample(Sample sample);

        /**
         * Sets the value of the Sample property for this object.
         *
         * This is a convenience that creates an instance of the {@link Sample.Builder} avoiding the need to create one
         * manually via {@link Sample#builder()}.
         *
         * When the {@link Consumer} completes, {@link Sample.Builder#build()} is called immediately and its result is
         * passed to {@link #sample(Sample)}.
         * 
         * @param sample
         *        a consumer that will call methods on {@link Sample.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sample(Sample)
         */
        default Builder sample(Consumer<Sample.Builder> sample) {
            return sample(Sample.builder().applyMutation(sample).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role to be assumed for this request.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role to be assumed for this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The name of the project to be updated.
         * </p>
         * 
         * @param name
         *        The name of the project to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataBrewRequest.BuilderImpl implements Builder {
        private Sample sample;

        private String roleArn;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectRequest model) {
            super(model);
            sample(model.sample);
            roleArn(model.roleArn);
            name(model.name);
        }

        public final Sample.Builder getSample() {
            return sample != null ? sample.toBuilder() : null;
        }

        @Override
        public final Builder sample(Sample sample) {
            this.sample = sample;
            return this;
        }

        public final void setSample(Sample.BuilderImpl sample) {
            this.sample = sample != null ? sample.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProjectRequest build() {
            return new UpdateProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
