/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDatasetRequest extends DataBrewRequest implements
        ToCopyableBuilder<UpdateDatasetRequest.Builder, UpdateDatasetRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateDatasetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<FormatOptions> FORMAT_OPTIONS_FIELD = SdkField
            .<FormatOptions> builder(MarshallingType.SDK_POJO).memberName("FormatOptions")
            .getter(getter(UpdateDatasetRequest::formatOptions)).setter(setter(Builder::formatOptions))
            .constructor(FormatOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatOptions").build()).build();

    private static final SdkField<Input> INPUT_FIELD = SdkField.<Input> builder(MarshallingType.SDK_POJO).memberName("Input")
            .getter(getter(UpdateDatasetRequest::input)).setter(setter(Builder::input)).constructor(Input::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            FORMAT_OPTIONS_FIELD, INPUT_FIELD));

    private final String name;

    private final FormatOptions formatOptions;

    private final Input input;

    private UpdateDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.formatOptions = builder.formatOptions;
        this.input = builder.input;
    }

    /**
     * <p>
     * The name of the dataset to be updated.
     * </p>
     * 
     * @return The name of the dataset to be updated.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the FormatOptions property for this object.
     * 
     * @return The value of the FormatOptions property for this object.
     */
    public final FormatOptions formatOptions() {
        return formatOptions;
    }

    /**
     * Returns the value of the Input property for this object.
     * 
     * @return The value of the Input property for this object.
     */
    public final Input input() {
        return input;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(formatOptions());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatasetRequest)) {
            return false;
        }
        UpdateDatasetRequest other = (UpdateDatasetRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(formatOptions(), other.formatOptions())
                && Objects.equals(input(), other.input());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDatasetRequest").add("Name", name()).add("FormatOptions", formatOptions())
                .add("Input", input()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "FormatOptions":
            return Optional.ofNullable(clazz.cast(formatOptions()));
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatasetRequest, T> g) {
        return obj -> g.apply((UpdateDatasetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataBrewRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDatasetRequest> {
        /**
         * <p>
         * The name of the dataset to be updated.
         * </p>
         * 
         * @param name
         *        The name of the dataset to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the FormatOptions property for this object.
         *
         * @param formatOptions
         *        The new value for the FormatOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatOptions(FormatOptions formatOptions);

        /**
         * Sets the value of the FormatOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link FormatOptions.Builder} avoiding the need to
         * create one manually via {@link FormatOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link FormatOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #formatOptions(FormatOptions)}.
         * 
         * @param formatOptions
         *        a consumer that will call methods on {@link FormatOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #formatOptions(FormatOptions)
         */
        default Builder formatOptions(Consumer<FormatOptions.Builder> formatOptions) {
            return formatOptions(FormatOptions.builder().applyMutation(formatOptions).build());
        }

        /**
         * Sets the value of the Input property for this object.
         *
         * @param input
         *        The new value for the Input property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(Input input);

        /**
         * Sets the value of the Input property for this object.
         *
         * This is a convenience that creates an instance of the {@link Input.Builder} avoiding the need to create one
         * manually via {@link Input#builder()}.
         *
         * When the {@link Consumer} completes, {@link Input.Builder#build()} is called immediately and its result is
         * passed to {@link #input(Input)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link Input.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(Input)
         */
        default Builder input(Consumer<Input.Builder> input) {
            return input(Input.builder().applyMutation(input).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataBrewRequest.BuilderImpl implements Builder {
        private String name;

        private FormatOptions formatOptions;

        private Input input;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatasetRequest model) {
            super(model);
            name(model.name);
            formatOptions(model.formatOptions);
            input(model.input);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final FormatOptions.Builder getFormatOptions() {
            return formatOptions != null ? formatOptions.toBuilder() : null;
        }

        @Override
        public final Builder formatOptions(FormatOptions formatOptions) {
            this.formatOptions = formatOptions;
            return this;
        }

        public final void setFormatOptions(FormatOptions.BuilderImpl formatOptions) {
            this.formatOptions = formatOptions != null ? formatOptions.build() : null;
        }

        public final Input.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        @Override
        public final Builder input(Input input) {
            this.input = input;
            return this;
        }

        public final void setInput(Input.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatasetRequest build() {
            return new UpdateDatasetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
