/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sample configuration for Profile Jobs only. Determines the number of rows on which the Profile job will be executed.
 * If a JobSample value is not provided for profile jobs, the default value will be used. The default value is
 * CUSTOM_ROWS for the mode parameter and 20000 for the size parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobSample implements SdkPojo, Serializable, ToCopyableBuilder<JobSample.Builder, JobSample> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(JobSample::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<Long> SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Size")
            .getter(getter(JobSample::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mode;

    private final Long size;

    private JobSample(BuilderImpl builder) {
        this.mode = builder.mode;
        this.size = builder.size;
    }

    /**
     * <p>
     * Determines whether the profile job will be executed on the entire dataset or on a specified number of rows. Must
     * be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * FULL_DATASET: Profile job will be executed on the entire dataset.
     * </p>
     * </li>
     * <li>
     * <p>
     * CUSTOM_ROWS: Profile job will be executed on the number of rows specified in the Size parameter.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link SampleMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Determines whether the profile job will be executed on the entire dataset or on a specified number of
     *         rows. Must be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         FULL_DATASET: Profile job will be executed on the entire dataset.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CUSTOM_ROWS: Profile job will be executed on the number of rows specified in the Size parameter.
     *         </p>
     *         </li>
     * @see SampleMode
     */
    public final SampleMode mode() {
        return SampleMode.fromValue(mode);
    }

    /**
     * <p>
     * Determines whether the profile job will be executed on the entire dataset or on a specified number of rows. Must
     * be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * FULL_DATASET: Profile job will be executed on the entire dataset.
     * </p>
     * </li>
     * <li>
     * <p>
     * CUSTOM_ROWS: Profile job will be executed on the number of rows specified in the Size parameter.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link SampleMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Determines whether the profile job will be executed on the entire dataset or on a specified number of
     *         rows. Must be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         FULL_DATASET: Profile job will be executed on the entire dataset.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CUSTOM_ROWS: Profile job will be executed on the number of rows specified in the Size parameter.
     *         </p>
     *         </li>
     * @see SampleMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * Size parameter is only required when the mode is CUSTOM_ROWS. Profile job will be executed on the the specified
     * number of rows. The maximum value for size is Long.MAX_VALUE.
     * </p>
     * <p>
     * Long.MAX_VALUE = 9223372036854775807
     * </p>
     * 
     * @return Size parameter is only required when the mode is CUSTOM_ROWS. Profile job will be executed on the the
     *         specified number of rows. The maximum value for size is Long.MAX_VALUE.</p>
     *         <p>
     *         Long.MAX_VALUE = 9223372036854775807
     */
    public final Long size() {
        return size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobSample)) {
            return false;
        }
        JobSample other = (JobSample) obj;
        return Objects.equals(modeAsString(), other.modeAsString()) && Objects.equals(size(), other.size());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobSample").add("Mode", modeAsString()).add("Size", size()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobSample, T> g) {
        return obj -> g.apply((JobSample) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobSample> {
        /**
         * <p>
         * Determines whether the profile job will be executed on the entire dataset or on a specified number of rows.
         * Must be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * FULL_DATASET: Profile job will be executed on the entire dataset.
         * </p>
         * </li>
         * <li>
         * <p>
         * CUSTOM_ROWS: Profile job will be executed on the number of rows specified in the Size parameter.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mode
         *        Determines whether the profile job will be executed on the entire dataset or on a specified number of
         *        rows. Must be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        FULL_DATASET: Profile job will be executed on the entire dataset.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CUSTOM_ROWS: Profile job will be executed on the number of rows specified in the Size parameter.
         *        </p>
         *        </li>
         * @see SampleMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SampleMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * Determines whether the profile job will be executed on the entire dataset or on a specified number of rows.
         * Must be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * FULL_DATASET: Profile job will be executed on the entire dataset.
         * </p>
         * </li>
         * <li>
         * <p>
         * CUSTOM_ROWS: Profile job will be executed on the number of rows specified in the Size parameter.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mode
         *        Determines whether the profile job will be executed on the entire dataset or on a specified number of
         *        rows. Must be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        FULL_DATASET: Profile job will be executed on the entire dataset.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CUSTOM_ROWS: Profile job will be executed on the number of rows specified in the Size parameter.
         *        </p>
         *        </li>
         * @see SampleMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SampleMode
         */
        Builder mode(SampleMode mode);

        /**
         * <p>
         * Size parameter is only required when the mode is CUSTOM_ROWS. Profile job will be executed on the the
         * specified number of rows. The maximum value for size is Long.MAX_VALUE.
         * </p>
         * <p>
         * Long.MAX_VALUE = 9223372036854775807
         * </p>
         * 
         * @param size
         *        Size parameter is only required when the mode is CUSTOM_ROWS. Profile job will be executed on the the
         *        specified number of rows. The maximum value for size is Long.MAX_VALUE.</p>
         *        <p>
         *        Long.MAX_VALUE = 9223372036854775807
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Long size);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private Long size;

        private BuilderImpl() {
        }

        private BuilderImpl(JobSample model) {
            mode(model.mode);
            size(model.size);
        }

        public final String getMode() {
            return mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(SampleMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public final Long getSize() {
            return size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public JobSample build() {
            return new JobSample(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
